/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AnQF
 */

package
{
    // SUPERFORMULA 2D
    // http://en.wikipedia.org/wiki/Superformula

    import flash.events.*;
    import flash.display.*;

    import com.bit101.components.*;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [ SWF (width = '465', height = '465', backgroundColor = '0x000000', frameRate = '50')]

    public class SUPERFORMULA_2D extends Sprite
    {
        private var W : uint = 465, H : uint = 465;

        private var hue : Vector.<uint> = lut ();

        private var pi2 : Number = Math.PI * 2;

        private var _a : Number, _r : Number;
        private var _n : Number;

        private var a  : Number = 1;
        private var b  : Number = 1;
        private var m  : Number = 8;
        private var n1 : Number = 1;
        private var n2 : Number = 5;
        private var n3 : Number = 1;

        //

        private var granularity : Number = 10/10000;    // [ 0.01 | 0.0001 ]
        private var variation : uint = 5;               // [ 1 | 10 ]
        private var step : Number = 0.50;               // [ 0 | 5  ]
        private var scale : Number = 100;
        private var center : int = W / 2;
        private var i : int,  j : Number;

        private var render : Boolean = true;

        //

        private var s__m : HUISlider, s_n1 : HUISlider;
        private var s_n2 : HUISlider, s_n3 : HUISlider;

        private var panel_rec : Sprite, panel : Sprite;
        private var panel_btn : CheckBox;
        private var s : BitmapData;


        public function SUPERFORMULA_2D ()
        {
            Wonderfl.disable_capture ();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {removeEventListener (Event.ADDED_TO_STAGE, init);}

            stage.scaleMode = 'noScale';

            graphics.beginFill (0, 1);
            graphics.drawRect  (0, 0, W, H);

            //

            addChild (new Bitmap (s = new BitmapData (W, H, false, 0)));

            setUI ();

            frame (); stage.addEventListener (Event.ENTER_FRAME, frame);
        }

        private function frame ($ : Event = null) : void
        {
            if (! render) return;

            s.lock ();
            s.fillRect (s.rect, 0);

            for (i = 0; i < variation; i++)
            {
                _n = step * i;

                for (j = 0; j <= pi2; j += granularity)
                {
                    _a = m * j / 4;
                    _r = Math.pow
                    (
                        (Math.pow (Math.abs (Math.cos (_a) / a), n2) + Math.pow (Math.abs (Math.sin (_a) / b), n3 - _n)),
                        -1 / (n1 + _n)
                    );

                    s.setPixel
                    (
                        center + _r * Math.cos (j) * scale,
                        center + _r * Math.sin (j) * scale,
                        hue [int (360 / (pi2 / j))]
                    );
                }
            }

            s.unlock ();

            render = false;
        }

        private function lut () : Vector.<uint>
        {
            hue = new Vector.<uint> (360, true);

            for (i = 0; i < hue.length; i++)

            hue[i] = hsv2rgb (i);

            return hue;
        }

        private function hsv2rgb (h : Number = 0, s : Number = 1, v : Number = 1) : uint
        {
            var i : int = int (h / 60);
            var f : Number = h / 60 - i;
            var p : Number = v * (1 - s);
            var q : Number = v * (1 - s * f);
            var t : Number = v * (1 - s * (1 - f));

            switch (i)
            {
                case 0: return v * 0xFF << 16 | t * 0xFF << 8 | p * 0xFF << 0;
                case 1: return q * 0xFF << 16 | v * 0xFF << 8 | p * 0xFF << 0;
                case 2: return p * 0xFF << 16 | v * 0xFF << 8 | t * 0xFF << 0;
                case 3: return p * 0xFF << 16 | q * 0xFF << 8 | v * 0xFF << 0;
                case 4: return t * 0xFF << 16 | p * 0xFF << 8 | v * 0xFF << 0;
                case 5: return v * 0xFF << 16 | p * 0xFF << 8 | q * 0xFF << 0;
            }

            return 0;

            //  http://wonderfl.net/c/dtn8
        }

        private function setUI () : void
        {
            panel = new Sprite ();

            // --o BACKGROUND

            panel_rec = new Sprite ();
            panel_rec.graphics.drawGraphicsData
            (
                Vector.<IGraphicsData>
                ([
                    new GraphicsStroke (1, true, 'normal', 'none', 'round', 3, new GraphicsSolidFill (0xFFFFFF, 0.5)),
                    new GraphicsSolidFill (0, 0.65),
                    graphicsBorderPath (0, 0, 161, 153)
                ])
            );

            panel_rec.addEventListener (MouseEvent.MOUSE_DOWN, drag);
            panel_rec.addEventListener (MouseEvent.MOUSE_UP,   drag);

            panel.addChild (panel_rec);

            // --o CHECKBOX | BTN

            panel_btn = new CheckBox (panel, 5, 5, null, display);
            panel_btn.selected = true;

            // --o SLIDERS | OFFSETS

            var _lbl : Label = new Label (panel, 30, 1, 'a = b = 1');

            s__m = new HUISlider (panel, 30, 16, 'm ', set__m);
            s__m.setSliderParams (0, 40, m);
            s__m.labelPrecision = 0;
            s__m.width = 180;
            s__m.tick = 2;
            s__m.draw ();

            s_n1 = new HUISlider (panel, 30, 32, 'n1', set_n1);
            s_n1.setSliderParams (1, 20, n1);
            s_n1.labelPrecision = 0;
            s_n1.width = 180;
            s_n1.tick = 1;
            s_n1.draw ();

            s_n2 = new HUISlider (panel, 30, 48, 'n2', set_n2);
            s_n2.setSliderParams (1, 20, n2);
            s_n2.labelPrecision = 0;
            s_n2.width = 180;
            s_n2.tick = 1;
            s_n2.draw ();

            s_n3 = new HUISlider (panel, 30, 64, 'n3', set_n3);
            s_n3.setSliderParams (1, 20, n3);
            s_n3.labelPrecision = 0;
            s_n3.width = 180;
            s_n3.tick = 1;
            s_n3.draw ();

            var s__g : HUISlider = new HUISlider (panel, 30, 80, 'GRANULARITY', set__g);
            s__g.setSliderParams (1, 100, granularity * 10000);
            s__g.labelPrecision = 0;
            s__g.width = 180;
            s__g.draw ();

            var s__v : HUISlider = new HUISlider (panel, 30, 96, 'VARIATIONS', set__v);
            s__v.setSliderParams (1, 10, variation);
            s__v.labelPrecision = 0;
            s__v.width = 180;
            s__v.tick = 1;
            s__v.draw ();

            var s__s : HUISlider = new HUISlider (panel, 30, 112, 'STEP', set__s);
            s__s.setSliderParams (0, 5, step);
            s__s.labelPrecision = 1;
            s__s.width = 180;
            s__s.tick = 0.1;
            s__s.draw ();

            // --o COMBOBOX

            var cb_p : ComboBox = new ComboBox (panel, 63, 132, 'PRESETS',
            [
                {label : '1 | .5 | .5 | .5'},  {label : '2 | .5 | .5 | .5'},
                {label : '2 | 2 | 2 | 2'},     {label : '3 | 10 | 15 | 15'},
                {label : '4 | 0.5 | 0.5 | 4'}, {label : '4 | 4 | 7 | 7'},
                {label : '5 | 2 | 5 | 5'},     {label : '6 | 1 | 1 | 1'},
                {label : '6 | 1 | 1 | 8'},     {label : '8 | 1 | 1 | 8'},
                {label : '8 | 1 | 5 | 1'},     {label : '6 | 10 | 20 | 6'},
                {label : '12 | 1 | 1 | 2'},    {label : '14 | 1 | 4 | 1'},
                {label : '18 | 2 | 18 | 1'}
            ]);
            cb_p.addEventListener (Event.SELECT, set__p);
            cb_p.numVisibleItems = cb_p.items.length;
            cb_p.setSize (92, 15);
            cb_p.draw ();

            //

            panel.x = W - (panel.width + 10);
            panel.y = 10;

            addChild (panel);
        }

        private function set__m (e : Event) : void { m  = e.target.value; render = true; }
        private function set_n1 (e : Event) : void { n1 = e.target.value; render = true; }
        private function set_n2 (e : Event) : void { n2 = e.target.value; render = true; }
        private function set_n3 (e : Event) : void { n3 = e.target.value; render = true; }

        private function set__v (e : Event) : void { variation = e.target.value; render = true; }
        private function set__s (e : Event) : void { step = e.target.value; render = true; }

        private function set__g (e : Event) : void { granularity = e.target.value/10000; render = true; }
        private function set__p (e : Event) : void
        {
            var a : Array = e.target.selectedItem.label.split (' | ');

            s__m.value = m  = a[0];
            s_n1.value = n1 = a[1];
            s_n2.value = n2 = a[2];
            s_n3.value = n3 = a[3];

            render = true;
        }

        private function display (e : Event) : void
        {
            panel.x = W - (e.target.selected ? panel.width + 10 : 20);
            panel.y = 10;
        }

        private function drag (e : MouseEvent) : void
        {
            if (panel_btn.selected) panel[(e.type == 'mouseUp' ? 'stopDrag' : 'startDrag')]();
        }

        private function graphicsBorderPath (x : int, y : int, w : Number, h : Number) : GraphicsPath
        {
            var header_size : uint = 20;

            return new GraphicsPath
            (
                Vector.<int>([1, 2, 2, 2, 2, 2, 2]),
                Vector.<Number>
                ([
                    x, y,
                    x + w + header_size, y, x + w + header_size, y + h,
                    x + header_size, y + h, x + header_size, y + header_size,
                    x, y + header_size,  x, y
                ])
            );
        }
    }
}