/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/An9v
 */

// forked from greentec's Diffusion-Limited Aggregation - Circular
// forked from greentec's Diffusion-Limited Aggregation
package {
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.BlendMode;
    import flash.display.Shape;
    
    public class FlashTest extends Sprite {
        
        public var centerX:Number = 465 / 2;
        public var centerY:Number = 465 / 2;
        
        public var _bitmap:Bitmap;
        public var _bitmapData:BitmapData;
        
        public var _baseBitmap:Bitmap;
        public var _baseBitmapData:BitmapData;
        
        public var hitBitmapData:BitmapData;
        
        public var particleNum:int = 5000;
        public var particles:Array = [];
        public var particleColor:Array = [0xFAF0FE, 0xF4F7F7, 0xE3F6F3, 0xC4EDE4, 0xADD8C7, 0x1F192F, 0x2D6073, 0x21CFD4, 0x92F5F5];
    
        public function FlashTest() {
            // write as3 code here..
            
            _bitmapData = new BitmapData(465, 465, true, 0xff292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            _baseBitmapData = new BitmapData(465, 465, true, 0xff000000);
            var _circle:Shape = new Shape();
            _circle.graphics.beginFill(0x000000);
            _circle.graphics.drawCircle(465 / 2, 465 / 2, 465 * 0.45);
            _circle.graphics.endFill();
            _baseBitmapData.draw(_circle, null, null, BlendMode.ERASE);_baseBitmap = new Bitmap(_baseBitmapData);
            addChild(_baseBitmap);
            _baseBitmap.alpha = 1;
            
            hitBitmapData = new BitmapData(2, 2, true, 0xffffffff);
            
            initParticles();
            
            var _button:PushButton = new PushButton(this, 10, 465 - 30, "Hide", onShow);
            _button.alpha = 0.8;
            _button.toggle = true;
            _button.selected = true;
            
            addEventListener(Event.ENTER_FRAME, onLoop);
            
        }
        
        public function onShow(e:Event):void
        {
            if (e.target.selected == true)
            {
                e.target.label = "隠す";
                _baseBitmap.alpha = 1;
            }
            else
            {
                e.target.label = "見せる";
                _baseBitmap.alpha = 0;
            }
        }
        
        public function onLoop(e:Event):void
        {
            _bitmapData.fillRect(_bitmapData.rect, 0xff292929);
            
            var i:int;
            var p:Particle;
            var tx:Number;
            var ty:Number;
            for (i = 0; i < particleNum; i += 1)
            {
                p = particles[i];
                tx = Math.round(p.x);
                ty = Math.round(p.y);
                
                if (_baseBitmapData.hitTest(new Point(_baseBitmapData.rect.x, _baseBitmapData.rect.y), 255, hitBitmapData, new Point(tx, ty)) == true)
                //if (_baseBitmap.hitTestPoint(Math.round(p.x), Math.round(p.y))==true)
                {
                    if (p.x > tx)
                    {
                        tx += 1;
                    }
                    if (p.y > ty)
                    {
                        ty += 1;
                    }
                    
                    _baseBitmapData.setPixel32(tx, ty, 255 << 24 | p.color);
                    respawn(p);
                    
                }
                else
                {
                    p.vx += Math.random() * .1 - .05;
                    p.vy += Math.random() * .1 - .05;
                    p.x += p.vx;
                    p.y += p.vy;
                    p.vx *= .99;
                    p.vy *= .99;
                    
                    if (p.x > 465)
                    {
                        p.x -= 465;
                    }
                    else if (p.x < 0)
                    {
                        p.x += 465;
                    }
                    if (p.y > 465)
                    {
                        p.y -= 465;
                    }
                    else if (p.y < 0)
                    {
                        p.y += 465;
                    }
                    
                    _bitmapData.setPixel32(p.x, p.y, 255 << 24 | p.color);
                }
            }
            
            
            
        }
        
        public function respawn(p:Particle):void
        {
            p.x = 465 / 2;
            p.y = 465 / 2;
        }
        
        public function initParticles():void
        {
            var i:int;
            var p:Particle;
            var randColor:uint;
            for (i = 0; i < particleNum; i += 1)
            {
                randColor = particleColor[int(Math.random() * particleColor.length)];
                p = new Particle(465 / 2, 465 / 2, randColor);
                particles.push(p);
            }

        }
    }
}

Class
{
    class Particle 
    {
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
        public var color:uint;
        
        public function Particle(x:Number, y:Number, color:uint) 
        {
            this.x = x;
            this.y = y;
            this.vx = Math.random() * .1 - .05;
            this.vy = Math.random() * .1 - .05;
            
            this.color=color;
        }
    }
}
