/**
 * Copyright irobutsu ( http://wonderfl.net/user/irobutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Amex
 */

package{
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.geom.*;

    [SWF(width="400", height="400",backgroundColor=0xffffff)]

    public class jiba2 extends Sprite
    {
	private var V:Vector.<Vector.<int>>;
	private var nowDrag:int = 0 ; 

	private var sbI1:Tsumami , sbI2:Tsumami ; 

	private var sbE:Tsumami ; 

	private var w:int , h:int ; 

	private var M1:Magnet,I1:current,I2:current;

	public function jiba2():void { 
	    w=400;
	    h=364;

	    M1=new Magnet(100,200,this);
	    sbI1 = new Tsumami(this, 3, -3 , 3 ,0,364,200,"電流１=" ,0xaa00 ) ;
	    sbI2 = new Tsumami(this,-3, -3 , 3 ,0,382,200,"電流２=" ,0xbbbb ) ;
	    sbE = new Tsumami(this,  0,-50,50,200,364,200, "外部磁場上=") ;


	    I1=new current(this,3,300,180,0xaa00);
	    I2=new current(this,-3,300,220,0xbbbb);

	    stage.addEventListener(MouseEvent.MOUSE_DOWN, mPressed);
	    stage.addEventListener(MouseEvent.MOUSE_UP, mReleased);
	    stage.addEventListener(MouseEvent.MOUSE_MOVE, mMove)
	    addEventListener("update",updateEvt);

	    V=new Vector.<Vector.<int>>(w+1);

	    var i:int;
	    for(i=0; i<=w ; i++ ) {
		V[i]=new Vector.<int>(h+1);
	    }

	    update();
	}

	public function mMove(e:MouseEvent ):void { 
	    if( nowDrag == 2 ) {
		M1.setAngle(e.stageX,e.stageY);
		update();
	    } else if( nowDrag !=0 ) {
		update();
	    }
	}

	public function updateEvt(e:Event ):void {
	    I1.setI(sbI1.value());
	    I2.setI(sbI2.value());

	    I1.update();
	    I2.update();

	    update();
	}

	public function mPressed( e:MouseEvent ):void { 
	    var mx:int = e.stageX ;
	    var my:int = e.stageY ;

	    if( I1.isNear(mx,my) ) {
		nowDrag = 3 ;
		I1.goDrag();
	    } else if( I2.isNear(mx,my) ) {
		nowDrag = 4 ;
		I2.goDrag();
	    } else if( M1.isCenter(mx , my) ) {
		M1.startDrag(false,new Rectangle(0,0,400,364));
		nowDrag = 1 ;
		return  ;
	    } else if( M1.isNPole(mx , my) ) {
		nowDrag = 2;
		M1.TurnOn();
		return  ;
	    }
	}
	
	public function mReleased( e:MouseEvent ):void { 
	    if( nowDrag ==1 ) {
		M1.stopDrag();
	    } else if( nowDrag ==2 ) {
		M1.TurnOff();
	    } else if( nowDrag ==3 ) {
		I1.endDrag();
	    } else if( nowDrag ==4 ) {
		I2.endDrag();
	    }
	    nowDrag = 0 ;
	    update();
	}
	
	public function update():void { 

	    var XX:int, YY:int;

	    var x1:int=M1.NX();
	    var x2:int=M1.SX();
	    var x3:int=I1.X();
	    var x4:int=I2.X();
	    var y1:int=M1.NY();
	    var y2:int=M1.SY();
	    var y3:int=I1.Y();
	    var y4:int=I2.Y();
	    var i1:int=I1.I();
	    var i2:int=I2.I();


	    var R:int;
	    var I:int;

	    var RR:int;
	    var II:int;

	    var DX1:Vector.<int>=new Vector.<int>(w+1);
	    var SQX1:Vector.<int>=new Vector.<int>(w+1);
	    var DX2:Vector.<int>=new Vector.<int>(w+1);
	    var SQX2:Vector.<int>=new Vector.<int>(w+1);
	    var SQX3:Vector.<int>=new Vector.<int>(w+1);
	    var SQX4:Vector.<int>=new Vector.<int>(w+1);

	    var DY1:Vector.<int>=new Vector.<int>(h+1);
	    var SQY1:Vector.<int>=new Vector.<int>(h+1);
	    var DY2:Vector.<int>=new Vector.<int>(h+1);
	    var SQY2:Vector.<int>=new Vector.<int>(h+1);
	    var SQY3:Vector.<int>=new Vector.<int>(h+1);
	    var SQY4:Vector.<int>=new Vector.<int>(h+1);


	    for( XX = 0 ; XX <= w  ; XX++ ) {
		SQX3[XX]=(XX-x3)*(XX-x3);
		SQX4[XX]=(XX-x4)*(XX-x4);
	    }

	    for( YY = 0 ; YY <= h  ; YY++ ) {
		SQY3[YY]=(YY-y3)*(YY-y3);
		SQY4[YY]=(YY-y4)*(YY-y4);
	    }


	    for( XX = 0 ; XX <= w  ; XX++ ) {
		for( YY = 0 ; YY <= h  ; YY++ ) {
		    R= XX-x1;
		    I= YY-y1;

		    RR= XX-x2;
		    II= y2-YY;

		    var RRR:Number=R*RR-I*II;
		    var III:Number=R*II+RR*I;

		    var NR:Number;
		    var Acos:Number;
		    var Asin:Number;
		    var A:Number=1.0;
			
		    if( i1 !=0 || i2 != 0 ) {
			var A1:Number=Number(SQX3[XX] + SQY3[YY]);
			var A2:Number=Number(SQX4[XX] + SQY4[YY]);

			if( A1 != 0 ) {
			    switch( i1 ) {
				case 1:
				A=A1;
				break;
				case 2:
				A=A1*A1;
				break;
				case 3:
				A=A1*A1*A1;
				break;
				case -1:
				A=1.0/A1;
				break;
				case -2:
				A=1.0/(A1*A1);
				break;
				case -3:
				A=1.0/(A1*A1*A1);
				break;
			    }
			}
		    
			if( A2 != 0.0 ) {
			    switch( i2 ) {
				case 1:
				A*=A2;
				break;
				case 2:
				A*=A2*A2;
				break;
				case 3:
				A*=A2*A2*A2;
				break;
				case -1:
				A/=A2;
				break;
				case -2:
				A/=(A2*A2);
				break;
				case -3:
				A/=(A2*A2*A2);
				break;
			    }
			}
			A = 0.5*Math.log(A);
			if( sbE.value() != 0 ) {
			    A += sbE.value() * XX / 1000.0 ;
			}
			Acos=Math.cos(A);
			Asin=Math.sin(A);
			
			NR=RRR*Acos-III*Asin;
			III=RRR*Asin+III*Acos;
			RRR=NR;
		    } else {
			if( sbE.value() != 0 ) {
			    var EE:Number = sbE.value() * XX / 1000.0 ;	
			    Acos=Math.cos(EE);
			    Asin=Math.sin(EE);
			    NR=RRR*Acos-III*Asin;
			    III=RRR*Asin+III*Acos;
			    RRR=NR;
			}
		    }

		    var v:Number = Math.atan2(RRR,III);
		    
		    v *= 5.0 ;
		    v /= Math.PI ;
		    V[XX][YY] = int(Math.floor(v)) ;
		}
	    }
	    graphics.clear();
	    graphics.lineStyle(1,0xffffff);
	    graphics.beginFill(0xffffff);
	    graphics.drawRect(0 , 0 , w , h) ;
	    graphics.endFill();

	    var diff:int ;


	    for( XX = 0 ; XX < w ; XX++ ) {
		for( YY = 0 ; YY < h ; YY++ ) {
		    if( !M1.isNPole(XX,YY) && !M1.isSPole(XX,YY) && !I1.isNear(XX,YY) && !I2.isNear(XX,YY) ) {
			if( V[XX ][YY] != V[XX][YY + 1] ) {
			    graphics.lineStyle(1,0xff0000);
			    graphics.beginFill(0xff0000);
			    graphics.drawRect(XX , YY , 1 , 1) ;
			    graphics.endFill();
			} else if( V[XX][YY] != V[XX + 1][YY] ) {
			    graphics.lineStyle(1,0xff0000);
			    graphics.beginFill(0xff0000);
			    graphics.drawRect(XX , YY , 1 , 1) ;
			    graphics.endFill();
			}
		    }
		}
	    }
	}
    }
}

import flash.events.Event;
import flash.events.MouseEvent;
import flash.display.Sprite;
import flash.display.*;
import flash.system.*;
import flash.geom.*;
import flash.text.*

class Clickable extends Sprite {
    public function Clickable(pp:Sprite):void {
	buttonMode=true;
	pp.addChild(this);
    }

}

class current extends Clickable {
    private var i:int;
    private var hankei:int;
    private var color:int;
    private var nowDrag:Boolean;

    public function I():int { return i;}
    public function X():int {return x;}
    public function Y():int {return y;}

    public function current(pp:Sprite, qq:int,XX:int, YY:int, c:int):void {
	super(pp);
	x=XX;
	y=YY;
	i=qq;
	hankei=10;
	color=c;
	nowDrag=false;
	write();
    }
    public function setI(qq:int):void { i=qq; }

    public function goDrag():void {
	nowDrag=true;
	startDrag(false,new Rectangle(hankei,hankei,400-hankei*2,346-hankei*2));
    }

    public function isNear(xx:int, yy:int):Boolean {
	return (xx-x)*(xx-x)+(yy-y)*(yy-y) < hankei*hankei;
    }

    public function endDrag():void {
	nowDrag=false;
	stopDrag();
	update();
    }

    public function update():void {
	write();
    }

    public function write():void {
	graphics.clear();
	graphics.lineStyle(1,color);
	graphics.beginFill(color);
	graphics.drawCircle(0,0,hankei);
	graphics.endFill();
	if( i > 0 ) {
	    graphics.lineStyle(1,0);
	    graphics.beginFill(0);
	    graphics.drawCircle(0,0,hankei/2);
	    graphics.endFill();
	} else if( i< 0 ) {
	    graphics.lineStyle(1,0);
	    graphics.moveTo(-7*hankei/10,-7*hankei/10);
	    graphics.lineTo(7*hankei/10,7*hankei/10);
	    graphics.moveTo(-7*hankei/10,7*hankei/10);
	    graphics.lineTo(7*hankei/10,-7*hankei/10);
	}
    }
}


class Plate extends Sprite {
    protected var txt:TextField;
    protected var Width:int;
    public function Plate(pp:Sprite,X:int,Y:int,W:int,s:String):void {
	x=X;
	y=Y;
	txt=new TextField();
	txt.text=s;
	txt.height=18;
	txt.width=W-20;
	txt.y=0;
	addChild(txt);

	Width=W;
	buttonMode=true;
	writeNormal();
	pp.addChild(this);
    }

    protected function writeNormal():void { 
	graphics.clear();
	graphics.lineStyle(1,0xaaaaaa);
	graphics.beginFill(0xdddddd);
	graphics.drawRect(0,0,Width-1,17);
	graphics.endFill();
	graphics.lineStyle(1,0x666666);
	graphics.moveTo(1,17);
	graphics.lineTo(Width-1,17);
	graphics.lineTo(Width-1,1);
    }
}

class MessagePlate extends Plate {
    private var normalTxt:String;
    private var messageTxt:String;
    private var normalColor:int;
    private var messageColor:int;

    public function MessagePlate(pp:Sprite,X:int,Y:int,W:int,s1:String,s2:String,c1:int=0,c2:int=0xff0000):void {
	super(pp,X,Y,W,s1);
	normalTxt=s1;
	messageTxt=s2;
	normalColor=c1;
	messageColor=c2;
	Off();
    }
    public function On():void {
	txt.text=messageTxt;
	txt.textColor=messageColor;
    }
    public function Off():void {
	txt.text=normalTxt;
	txt.textColor=normalColor;
    }
}

class ClickablePlate extends Plate {
    public function ClickablePlate(pp:Sprite,X:int,Y:int,W:int,s:String):void {
	super(pp,X,Y,W,s);

	buttonMode=true;
	addEventListener(MouseEvent.MOUSE_UP,MUp);
	addEventListener(MouseEvent.MOUSE_OVER,MOver);
	addEventListener(MouseEvent.MOUSE_OUT,MOut);
    }

    public function MUp(e:Event):void {
	;
    }

    public function MOut(e:Event):void {
	writeNormal();
    }

    public function MOver(e:Event):void {
	writeHilight();
    }
    protected function writeHilight():void {
	graphics.clear();
	graphics.lineStyle(1,0xffffff);
	graphics.beginFill(0xdddddd);
	graphics.drawRect(0,0,Width-1,17);
	graphics.endFill();
	graphics.lineStyle(1,0xaaaaaa);
	graphics.moveTo(1,17);
	graphics.lineTo(Width-1,17);
	graphics.lineTo(Width-1,1);
    }
}

class Check extends ClickablePlate {
    private var val:Boolean;
    private var box:Sprite;

    public function Check(pp:Sprite,now:Boolean,X:int,Y:int,W:int,l:String,c:int=0):void {
	super(pp,X,Y,W,l);
	val=now;
	txt.x=16;
	txt.textColor=c;
	box=new Sprite();
	box.buttonMode=true;
	addChild(box);
	write();
    }

    public override function MUp(e:Event):void {
	toggle();
	dispatchEvent(new Event("update",true));
    }

    public function setValue(a:Boolean):void {
	val=a;
	write();
    }


    public function isChecked():Boolean {
	return val;
    }

    public function toggle():void {
	setValue(!val);
    }

    public function update():void {
	write();
    }

    public function write():void {
	box.graphics.clear();
	box.graphics.lineStyle(1,0);
	box.graphics.beginFill(0xffffff);
	box.graphics.drawRect(1,1,14,14);
	box.graphics.endFill();	
	if( val ) {
	    box.graphics.lineStyle(2,0);
	    box.graphics.moveTo(2,11);
	    box.graphics.lineTo(4,11);
	    box.graphics.lineTo(6,13);
	    box.graphics.lineTo(14,3);
	}
    }
}



class Tsumami extends Plate {
    private var val:int;
    private var min:int;
    private var max:int;
    private var label:String;
    private var nowDrag:Boolean;
    private var lever:Sprite;
    private var mizo:Sprite;
    public function Tsumami(pp:Sprite,now:int,minimum:int,maximum:int,X:int,Y:int,WW:int,l:String,c:int=0):void {
	super(pp,X,Y,WW,l);
	txt.textColor=c;
	buttonMode=false;
	nowDrag=false;
	min=minimum;
	max=maximum;
	val=now;
	label=l;
	lever=new Sprite();
	mizo=new Sprite();
	addChild(mizo);
	addChild(lever);
	mizo.x=Width/2;
	mizo.y=6;
	mizo.buttonMode=true;
	lever.buttonMode=true;
	mizo.addEventListener(MouseEvent.MOUSE_UP,mizoMUp);
	mizo.addEventListener(MouseEvent.MOUSE_OVER,mizoMOver);
	mizo.addEventListener(MouseEvent.MOUSE_OUT,mizoMOut);
	stage.addEventListener(MouseEvent.MOUSE_UP,leverMUp);
	lever.addEventListener(MouseEvent.MOUSE_DOWN,leverMDown);
	lever.addEventListener(MouseEvent.MOUSE_OVER,leverMOver);
	lever.addEventListener(MouseEvent.MOUSE_OUT,leverMOut);
	leverNormal();
	mizoNormal();
	update();
    }

    public function leverMUp(e:MouseEvent):void {
    	if(nowDrag ) {
	    endDrag();
    	}
    }
    public function leverMOver(e:MouseEvent):void {
	leverHighlight();
    }
    public function leverMDown(e:MouseEvent):void {
	goDrag();
    }


    public function mizoMUp(e:MouseEvent):void {
	var p:Point=localToGlobal(new Point(lever.x,lever.y) );
	if( e.stageX < p.x+6 ) {
	    oneDown();
	} else {
	    oneUp();
	}
	mizoHighlight(e);
    }
    public function mizoMOver(e:MouseEvent):void {
	mizoHighlight(e);
    }
    public function mizoMOut(e:MouseEvent):void {
	mizoNormal();
    }

    public function mizoNormal():void {
	mizo.graphics.clear();
	mizo.graphics.lineStyle(1,0x555555);
	mizo.graphics.beginFill(0x555555);
	mizo.graphics.drawRect(0,0,Width/2-4,5);
	mizo.graphics.endFill();
	mizo.graphics.lineStyle(1,0);
	mizo.graphics.moveTo(0,5);
	mizo.graphics.lineTo(0,0);
	mizo.graphics.lineTo(Width/2-4,0);
    }

    public function mizoHighlight(e:MouseEvent):void {
	if( nowDrag ) {
	    return;
	}
	var p:Point=localToGlobal(new Point(lever.x,lever.y) );
	mizo.graphics.clear();
	mizo.graphics.lineStyle(1,0x555555);
	mizo.graphics.beginFill(0x555555);
	mizo.graphics.drawRect(0,0,Width/2-4,5);
	mizo.graphics.endFill();
	mizo.graphics.lineStyle(1,0xffffff);
	if( e.stageX > p.x+6 ) {
	    mizo.graphics.moveTo(lever.x-mizo.x,0);
	    mizo.graphics.lineTo(Width/2-4,0);
	    mizo.graphics.beginFill(0xaaaa);
	    mizo.graphics.moveTo(lever.x-mizo.x+8,0);
	    mizo.graphics.lineTo(lever.x-mizo.x+18,3);
	    mizo.graphics.lineTo(lever.x-mizo.x+8,6);
	    mizo.graphics.endFill();
	} else {
	    mizo.graphics.moveTo(lever.x-mizo.x,0);
	    mizo.graphics.lineTo(0,0);
	    mizo.graphics.lineTo(0,6);
	    mizo.graphics.beginFill(0xaaaa);
	    mizo.graphics.moveTo(lever.x-mizo.x-2,0);
	    mizo.graphics.lineTo(lever.x-mizo.x-12,3);
	    mizo.graphics.lineTo(lever.x-mizo.x-2,6);
	    mizo.graphics.endFill();
	}
    }

    public function leverMOut(e:MouseEvent):void {
	if( !nowDrag ) {
	    leverNormal();
	}
    }

    public function oneUp():void {
	setValue(val+1);
    }

    public function oneDown():void {
	setValue(val-1);
    }

    private function XIchi():int{
	return int(Number((Width/2-6)*(val-min))/Number(max-min))+Width/2;
    }


    public function goDrag():void {
	nowDrag=true;
	leverInDrag();
	lever.startDrag(false,new Rectangle(Width/2,0,Width/2-6,0));
    }

    public function endDrag():void {
	nowDrag=false;
	leverNormal();
	lever.stopDrag();
	val=min + int(Number((lever.x-Width/2)*(max-min))/Number(Width/2-6)+0.5);
	update();
    }

    public function setValue(a:int):void { 
	if( a>max ) {
	    a=max;
	}
	if( a<min ) {
	    a=min;
	}
	val=a; 
	update();
    }

    public function value():int {
	return val;
    }

    public function update():void {
	lever.x=XIchi();
	txt.text=label+String(val);
	dispatchEvent(new Event("update",true));
    }

    public function leverNormal():void {
	lever.graphics.clear();
	lever.graphics.lineStyle(1,0x333300);
	lever.graphics.beginFill(0xaa0000);
	lever.graphics.drawRect(0,0,6,18);
	lever.graphics.endFill();	
    }

    public function leverHighlight():void {
	lever.graphics.clear();
	lever.graphics.lineStyle(1,0xaaaa33);
	lever.graphics.beginFill(0xaa0000);
	lever.graphics.drawRect(0,0,6,18);
	lever.graphics.endFill();	
    }

    public function leverInDrag():void {
	lever.graphics.clear();
	lever.graphics.lineStyle(1,0x888800);
	lever.graphics.beginFill(0xee8888);
	lever.graphics.drawRect(0,0,6,18);
	lever.graphics.endFill();
    }
}

class Magnet extends Clickable {
    private var cosine:Number ; 
    private var sine:Number ; 
    private var hankei:int;
    private var R:int;
    private var nowTurn:Boolean;

    function Magnet(xx:int, yy:int, pp:Sprite ){ 
	super(pp);
	hankei=5;
	R=30;
	x = xx;
	y = yy;
	cosine = 1.0;
	sine = 0.0;
	nowTurn=false;
	write();
	addEventListener(MouseEvent.MOUSE_OVER,MOver);
	addEventListener(MouseEvent.MOUSE_MOVE,MOver);
	addEventListener(MouseEvent.MOUSE_OUT,MOut);
    }
    
    public function Mark():void {
	graphics.lineStyle(1,0x8888);
	graphics.beginFill(0xaaaaaa);
	graphics.drawRect(-3,-3,6,6);
	graphics.endFill();
    }

    public function TurnMark():void {
	graphics.lineStyle(1,0x8888);
	graphics.beginFill(0xaaaaaa);

	graphics.moveTo(
	    int(  1.5*hankei * sine + (R-hankei/2) * cosine ),
	    int(  -1.5* hankei * cosine + (R-hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R-hankei/2) * cosine ),
	    int( 1.5*hankei * cosine + (R-hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R-hankei) * cosine ),
	    int( 1.5*hankei * cosine + (R-hankei)  * sine )) ;
	graphics.lineTo(
	    int(  -3* hankei * sine + R * cosine ),
	    int( 3*hankei * cosine + R  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R+hankei) * cosine ),
	    int( 1.5*hankei * cosine + (R+hankei)  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R+hankei/2) * cosine ),
	    int( 1.5*hankei * cosine + (R+hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R+hankei/2) * cosine ),
	    int( -1.5*hankei * cosine + (R+hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R+hankei) * cosine ),
	    int( -1.5*hankei * cosine + (R+hankei)  * sine )) ;
	graphics.lineTo(
	    int(  3* hankei * sine + R * cosine ),
	    int( -3*hankei * cosine + R  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R-hankei) * cosine ),
	    int( -1.5*hankei * cosine + (R-hankei)  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R-hankei/2) * cosine ),
	    int( -1.5*hankei * cosine + (R-hankei/2)  * sine )) ;

	graphics.endFill();
    }

    public function TurnOn():void {nowTurn=true; write();}
    public function TurnOff():void {nowTurn=false; write();}

    public function MOver(e:MouseEvent):void {
	if( isNPole(e.stageX,e.stageY) || nowTurn ) {
	    TurnMark();
	} else if( isCenter(e.stageX,e.stageY) ) {
	    Mark();
	} else {
	    write();
	}
    }

    public function MOut(e:MouseEvent):void {
	write();
    }

    public function write():void {
	graphics.clear();
	graphics.lineStyle(1,0xff0000);
	graphics.beginFill(0xff0000) ;

	graphics.moveTo(int(  - hankei * sine),int(  + hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine),int(  - hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine + ( R + hankei ) * cosine ),
	    int(  - hankei * cosine + ( R + hankei ) * sine )) ;
	graphics.lineTo(int(  - hankei * sine + ( R + hankei ) * cosine ),
	    int(  + hankei * cosine + ( R + hankei ) * sine )) ;
	graphics.endFill();
	graphics.lineStyle(1,0);
	graphics.beginFill(0) ;
	graphics.moveTo(int(  - hankei * sine),int(  + hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine),int(  - hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine - ( R + hankei ) * cosine ),
	    int(  - hankei * cosine - ( R + hankei ) * sine )) ;
	graphics.lineTo(int( - hankei * sine - ( R + hankei ) * cosine ),
	    int( + hankei * cosine - ( R + hankei ) * sine )) ;
	graphics.endFill();

	if( nowTurn ) {
	    TurnMark();
	}
    }

    public function X():int { 
	return x ;
    }
    
    public function Y():int { 
	return y ;
    }
    
    public function cos():Number { 
	return cosine ;
    }
    
    public function sin():Number { 
	return sine ;
    }
    
    public function setX( xx:int ):void { 
	x = xx ;
    }
	
    public function setY( yy:int ):void { 
	y = yy ;
    }
    
    public function setCosineSin( c:Number , s:Number ):void { 
	cosine = c ;
	sine = s ;
    }

    public function isCenter( x1:int , y1:int ):Boolean { 
	return ( ( x - x1 ) * ( x - x1 ) + ( y - y1 ) * ( y - y1 ) <= hankei * hankei );
    }

    public function isNPole( x1:int , y1:int ):Boolean { 
	var xx:int = NX();
	var yy:int = NY();
	return ( ( xx - x1 ) * ( xx - x1 ) + ( yy - y1 ) * ( yy - y1 ) <= hankei * hankei );
    }
    public function isSPole( x1:int , y1:int ):Boolean { 
	var xx:int = SX() ;
	var yy:int = SY() ;
	return ( ( xx - x1 ) * ( xx - x1 ) + ( yy - y1 ) * ( yy - y1 ) <= hankei * hankei );
    }
    

    public function NX():int {
	return int(Math.floor(x + R * cosine)) ;
    }
    
    public function NY():int {
	return int(Math.floor(y+ R * sine )) ;
    }

    public function SX():int {
	return int(Math.floor(x - R * cosine)) ;
    }
    
    public function SY():int {
	return int(Math.floor(y- R * sine )) ;
    }

    public function setAngle(xx:int,yy:int):void {
	var YY:Number = Number(( yy - y )) ;
	var XX:Number = Number(( xx - x )) ;
	var RR:Number = Math.sqrt(XX * XX + YY * YY) ;
	cosine=XX / RR;
	sine=YY / RR ;
    }

    public function setPoint(xx:int,yy:int):void {
	x=xx;
	y =yy;
    }
}