/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Am9Z
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=
    public class Euler extends Sprite {
        private var _tf : TextField;
  
        public function Euler() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            tr(solve());
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        private function solve() : Number
        {
            var primes : Array = doEratosthenes(100);
            var P : int = primes.length; // 25;
            var mul : Number = 1;
            for(i = 0;i < 14;i++)mul *= primes[i];
            tr(mul);
            
            var Q : uint = P + 1;
           　var f : Array = new Array(716 * Q);
            var i : uint, r : uint, m : uint;
            for(i = 0;i < f.length;i++)f[i] = 0;
            
            // f[r * (P + 1) + m]
            for(r = 2;r <= 715;r++){
                for(m = 5;m <= 13;m++){
                    if(m > 4 * r)continue;
                    var imp : uint = C(m, 4);
                    if(imp < r)continue;
                    
                    var val : Number = C(imp, r);
                    for(i = 5;i < m;i++){
//                        tr(C(m, i), f[r * Q + i]);
                        val -= C(m, i) * f[r * Q + i];
                    }
                    f[r * Q + m] = val;
                    tr(m, r, val);
                }
            }
            
            return 0;
        }
        
        private function C(n : uint, k : uint) : Number
        {
            if(n < k)return 0;
            if(k > n / 2)k = n - k;
            var mul : Number = 1;
            for(var i : uint = 1;i <= k;i++){
                mul *= (n - i + 1);
                mul /= i;
            }
            return mul;
        }

        private function doEratosthenes(n : int) : Array
        {
            var nn : uint = ((n / 2 - 1) >>> 5) + 1;
            var ar : Vector.<uint> = new Vector.<uint>(nn);
            var i : uint, j : uint;
            for(i = 0;i < nn - 1;i++)ar[i] = 0xffffffff;
            ar[nn - 1] = (1 << ((n / 2 - 1) & 31)) - 1;
            
            var sq : uint = (Math.sqrt(n) - 3) >>> 1;
            for(var p : uint = 0;p <= sq;p++){
                if(ar[p >>> 5] & (1 << (p & 31))){
                    var m : uint = (p << 1) + 3;
                    var m2 : uint = m << 1;
                    for(var mm : uint = m * m;mm <= n;mm += m2){
                        var ind : uint = (mm - 3) >>> 1;
                        ar[ind >>> 5] &= ~(1 << (ind & 31));
                    }
                }
            }
            
            var ret : Array = [2];
            for(i = 0;i < nn;i++){
                for(j = 0;j <= 31;j++){
                    if(ar[i] & (1 << j))ret.push((((i << 5) | j) << 1) + 3);
                }
            }
            return ret;
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}