/**
 * Copyright glasses_factory ( http://wonderfl.net/user/glasses_factory )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Am7Z
 */

/**
 * 勉強というか実験のためMr.doobがやってた奴を参考につくってみる。
 * 元ネタ
 * http://mrdoob.com/24/Webcam_effect_Nanika_01
 */

package
{
	import flash.display.*;
	import flash.events.Event;
	import flash.media.Camera;
	import flash.media.Video;
	
	[SWF(width = "465", height = "465", backgroundColor="0x000000", frameRate="24")]
	public class SatelliteTV extends Sprite
	{
		public function SatelliteTV() 
		{
			stageInit();
			
			if(setUPCamera())
			{
				setUPLCD();
			}
		}
		
		private function stageInit():void
		{
			stage.quality = StageQuality.LOW;
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;           
                         Wonderfl.capture_delay(10);
		}
		
		private function setUPCamera():Boolean
		{
			var _camera:Camera = Camera.getCamera();
			if(_camera == null)
			{
				return false;
			}
			_camera.setMode( 320, 240, 40, false );
			_camera.setQuality( 5000, 0  );
			var vidW:Number = stage.stageWidth / 3 * 0.169;
			var vidH:Number =  _camera.height * (vidW  / _camera.width);
			_video = new Video( vidW, vidH );
			_video.attachCamera( _camera );
			_video.smoothing = true;
			
			_mc = new MovieClip();
			
			setUpBmp();
			addEventListener(Event.RESIZE,resizeHandler);
			return true;
		}
		
		private function setUpBmp():void
		{
			_bmpVect = new Vector.<Bitmap>();
			var bmp:Bitmap;
			
			_row = Math.ceil( stage.stageHeight * ( _ratio / 2.385 ) / _video.height );
			_sourceBmd = new BitmapData(stage.stageWidth * ( _ratio / 2.385 ), stage.stageHeight * ( _ratio / 2.385 ), false, 0);
			
			for(var i:int = 0; i < _row; i++)
			{
				for(var j:int = 0; j < 3; j++)
				{
					bmp = generate( j * _video.width, i * _video.height );
					_bmpVect.push( bmp );
					_mc.addChild( bmp );
				}
			}
			addEventListener(Event.ENTER_FRAME,videoEnterFrameHandler);
		}
		
		private function generate(xx:Number, yy:Number):Bitmap
		{
			var bmd:BitmapData = new BitmapData( _video.width, _video.height, false, 0 );
			var bmp:Bitmap = new Bitmap( bmd );
			bmp.x = xx;
			bmp.y = yy;
			return bmp;
		}
		
		private function setUPLCD():void
		{
			var lcd:LCDBitmap = new LCDBitmap( _sourceBmd, _tileSize, _tileMargin );
			addChild( lcd );
		}
		
		private function videoEnterFrameHandler( e:Event ):void
		{
			_sourceBmd.fillRect( _sourceBmd.rect, 0x000000 );       
			_bmpVect[0].bitmapData.draw( _video );
			
			for(var i:int = _bmpVect.length - 1; i > 0; i--)
			{
				_bmpVect[i].bitmapData.draw( _bmpVect[i - 1].bitmapData );
			}
			_sourceBmd.draw( _mc );
			_cnt++;
			if(_cnt > 90)
			{
				move();
			}
		}
		
		private function resizeHandler(e:Event):void
		{
			setUpBmp();
		}
		
		private function move():void
		{
			
			for(var i:int = 0; i < _bmpVect.length; i ++ )
			{
				_bmpVect[i].y -= 1;
				
				if(_bmpVect[i].y < _bmpVect[i].height * -2)
				{
					_bmpVect.splice(i,1);
				}
				if(_bmpVect[i].y < _bmpVect[i].height * -2.1)
				{
					_mc.removeChild(_bmpVect[i]);
				}
				
			}
			var yy:Number;
			if(_currentX == 0)
				yy = _bmpVect[ _bmpVect.length - 1 ].y + _bmpVect[ _bmpVect.length - 1 ].height;
			else
				yy = _bmpVect[ _bmpVect.length - 1 ].y;
			
			var bmp:Bitmap = generate(_currentX * _video.width,yy );
			_bmpVect.push( bmp );
			_mc.addChild( bmp );
			_currentX++;
			if(_currentX > 5) _currentX = 0;
		}
		
		private var _cnt:uint;
		
		private var _ratio:Number = 0.4;
		
		private var _mc:MovieClip;
		
		private var _video:Video;
		
		private var _sourceBmd:BitmapData;
		
		private var _bmpVect:Vector.<Bitmap>;
		
		private var _colum:Number;
		
		private var _row:Number;
		
		private var _currentX:uint;
		
		private var _tileSize:uint = 1;
		
		private var _tileMargin:uint = 1;
	}
}

/*
* LCDBitmap
* 
* Licensed under the MIT License
* 
* Copyright (c) 2009 Jin Saburi (metalred.com),
*                    BeInteractive! (www.be-interactive.org) and
*                    Spark project  (www.libspark.org)
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
* 
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.geom.Rectangle;

/**
 * Display the BitmapData like a LCD display.
 *
 * This is a class of <a href="http://blog.jactionscripters.com/2009/05/18/study-recreating-lcd-panels-trinitron-like-matrices/">
 * Jin Saburi's effect</a>.
 *
 * @see http://blog.jactionscripters.com/2009/05/18/study-recreating-lcd-panels-trinitron-like-matrices/
 */
class LCDBitmap extends Bitmap
{
	/**
	 * Create a new instance of the LCDBitmap.
	 *
	 * @param	bitmapData	an instance of BitmapData you need to display.
	 * @param	tileSize	size of tile displays RGB color.
	 * @param	tileMargin	margin of each tiles
	 * @param	pixelSnapping	same as Bitmap class.
	 * @param	smoothing	same as Bitmap class.
	 */
	public function LCDBitmap(bitmapData:BitmapData, tileSize:uint = 3, tileMargin:uint = 1, pixelSnapping:String = 'auto', smoothing:Boolean = false)
	{
		_sourceBitmapData = bitmapData;
		_lcdBitmapData = new BitmapData(bitmapData.width * ((tileSize + tileMargin) * 3), bitmapData.height * ((tileSize + tileMargin) * 3), true, 0x00000000);
		super(_lcdBitmapData, pixelSnapping, smoothing);
		_tileSize = tileSize;
		_tileMargin = tileMargin;
		_tile = new Rectangle(0, 0, _tileSize, _tileSize);
		addEventListener(Event.ENTER_FRAME, renderHandler);
	}
	
	private var _sourceBitmapData:BitmapData;
	private var _lcdBitmapData:BitmapData;
	private var _tileSize:uint;
	private var _tileMargin:uint;
	private var _tile:Rectangle;
	
	private function renderHandler(e:Event):void
	{
		var source:BitmapData = _sourceBitmapData;
		var bitmap:BitmapData = _lcdBitmapData;
		bitmap.lock();
		bitmap.fillRect(bitmap.rect, 0x00000000);
		var sw:uint = source.width;
		var sh:uint = source.height;
		var size:uint = _tileSize;
		var margin:uint = _tileMargin;
		var tsize:uint = (size + margin);
		var psize:uint = tsize * 3;
		var tile:Rectangle = _tile;
		var px:uint, py:uint;
		var c:uint, r:uint, g:uint, b:uint;
		var x:uint, y:uint;
		for (x = 0; x < sw; ++x) {
			for (y = 0; y < sh; ++y) {
				c = source.getPixel(x, y);
				r = (c & 0xff0000) | 0xff000000;
				g = (c & 0x00ff00) | 0xff000000;
				b = (c & 0x0000ff) | 0xff000000;
				px = psize * x;
				py = psize * y;
				tile.x = px;
				tile.y = py;
				bitmap.fillRect(tile, r);
				tile.x = px + tsize;
				bitmap.fillRect(tile, g);
				tile.x = px + tsize * 2;
				bitmap.fillRect(tile, b);
				tile.x = px + margin;
				tile.y = py + tsize;
				bitmap.fillRect(tile, b);
				tile.x = px + margin + tsize;
				bitmap.fillRect(tile, r);
				tile.x = px + margin + tsize * 2;
				bitmap.fillRect(tile, g);
				tile.x = px + margin * 2;
				tile.y = py + tsize * 2;
				bitmap.fillRect(tile, g);
				tile.x = px + margin * 2 + tsize;
				bitmap.fillRect(tile, b);
				tile.x = px + margin * 2 + tsize * 2;
				bitmap.fillRect(tile, r);
			}
		}
		bitmap.unlock();
	}
}