/**
 * Copyright brane7 ( http://wonderfl.net/user/brane7 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Als6
 */

/*
Full Screenで見ると見やすいかと思います。
3D酔いには注意！
*/

package {
	import __AS3__.vec.Vector;
	
	import flash.events.Event;
	import flash.filters.*;
	
	import frocessing.color.ColorHSV;
	
	import org.papervision3d.cameras.*;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;

	[SWF(backgroundColor=0x000000)]
	public class Papervision_Line3D_rainbow extends BasicView
	{
		//カメラが追う球
		private var sphere:Sphere;
		//描く線
		private var line:Lines3D;
		//ここを変更すると描かれる線が変わる
		private const A:Number = 10.0, B:Number = 25.0, C:Number = 8.0/3.0, D:Number = 0.01;
		//向かう座標
		private var xx:Number, yy:Number, zz:Number;
		//HSV->RGB変換用の変数
		private var hsv:ColorHSV;
		private var glow:GlowFilter;
		//Planeを格納するためのVector
		private var particles:Vector.<Plane>;

		public function Papervision_Line3D_rainbow()
		{
			super(465, 465, true, false, CameraType.SPRING);
			//初期化
			hsv = new ColorHSV(0, 1, 1);
			glow = new GlowFilter(0, 1, 8, 8, 2);
			particles = new Vector.<Plane>();
			xx = yy = zz = 1;
			
			//球の生成
			sphere = new Sphere(new ColorMaterial(0xffffff), 3);
			sphere.x = sphere.y = sphere.z = 1;
			//scene.addChild(sphere);
			//フィルターを有効にする
			sphere.useOwnContainer = true;
			sphere.filters = [new BlurFilter(8,8,4), glow];
			//カメラが追うものを球に設定
			camera.target = sphere;
			//各パラメータの設定
			SpringCamera3D(camera).mass = 20;
			SpringCamera3D(camera).damping = 30;
			SpringCamera3D(camera).stiffness = 8;
			
			line = new Lines3D(null);
			scene.addChild(line);
			startRendering();

			addEventListener(Event.ENTER_FRAME, onFrame);
		}

		private function onFrame(event:Event):void{
			//from
			var preX:Number = sphere.x;
			var preY:Number = sphere.y;
			var preZ:Number = sphere.z;
			//進む距離
			var dx:Number, dy:Number, dz:Number;
			dx = A*(yy-xx);
			dy = xx * (B - zz) - yy;
			dz = xx * yy - C * zz;
			//to
			xx += D*dx;
			yy += D*dy;
			zz += D*dz;
			
			sphere.x = xx*2;
			sphere.y = yy*2;
			sphere.z = zz*2;
			
			//線を描画
			line.addNewLine(2, preX, preY, preZ, sphere.x, sphere.y, sphere.z);
			
			//HSV->RGBの変換
			var color:uint = hsv.toRGB().value;
			//glowフィルターの色変更
			glow.color = color;
			//線の色を変更
			(line.lines[line.lines.length-1] as Line3D).material = new LineMaterial(color);
			
			//球から出るパーティクルの生成
			
			
			
			hsv.h += 1;
		}
	}
}
