/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Akhg
 */

/*
per frame event flow:
1. timer, mouseMove, click...
2. enterFrame
3. timer (also possible)
4. frameConstructed
5. exitFrame
6. render (if requested)
X. FRAME RENDERED

more reading about "Elastic Racetrack AVM2"
http://www.craftymind.com/2008/04/18/updated-elastic-racetrack-for-flash-9-and-avm2/
*/

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.utils.Timer;
    
    [SWF(width="465", height="465", frameRate="1", backgroundColor="#FFFFFF")]
    public class WonderflApp extends Sprite
    {
        private var tf:TextField = new TextField;
        private var history:Array = [];
        
        public function WonderflApp():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            tf.width = stage.stageWidth;
            tf.height = stage.stageHeight;
            addChild(tf);
            
            var timer:Timer = new Timer(100);
            
            timer.start();
            
            addEventListener(Event.ENTER_FRAME, log);
            addEventListener(Event.FRAME_CONSTRUCTED, log);
            addEventListener(Event.EXIT_FRAME, log);
            addEventListener(Event.RENDER, log);
            addEventListener(MouseEvent.MOUSE_MOVE, log);
            addEventListener(MouseEvent.CLICK, log);
            timer.addEventListener(TimerEvent.TIMER, log);
            
            //addEventListener(Event.ENTER_FRAME, heavy, false, -1);
            //addEventListener(Event.FRAME_CONSTRUCTED, heavy, false, -1);
            //addEventListener(Event.EXIT_FRAME, heavy, false, -1);
            //addEventListener(Event.RENDER, heavy, false, -1);
            
            addEventListener(Event.ENTER_FRAME, invalidate);
        }
        
        private function log(event:Event):void
        {
            event is MouseEvent && MouseEvent(event).updateAfterEvent();
            
            history.push(event.type);
            history.length > 20 && history.shift();
            tf.text = history.join("\n");
        }
        
        private function invalidate(... rest):void
        {
            stage.invalidate();
        }
        
        private function heavy(... rest):void
        {
            for(var i:uint = 0; i < 100000000; i++){}
        }
    }
}
