/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AjUs
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.Timer;
    
    [SWF(width='465', height='465',  frameRate='30', backgroundColor='#222222')]
    public class FlashTest extends Sprite {
        public static const W : int = 465;
        public static const H : int = 465;
        public static const RECT : Rectangle = new Rectangle(0, 0, W, H);
        
        
        private var __index : int = 0;
        private var __bmpd : BitmapData;
        private var __bmpdMap : BitmapData;
        private var __isStarted : Boolean = false;
        private var __aSwarm : Array = [];
        private var __timer : Timer;
        
        public function FlashTest() {
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, __onLoadedHandler);
            loader.load(new URLRequest("http://www.bongiovi.tw/mood.jpg"), new LoaderContext(true));
        }
        
        
        private function __onLoadedHandler(e:Event) : void {
            __bmpdMap = Bitmap(e.currentTarget.content).bitmapData;
            __bmpd = new BitmapData(W, H, true, 0x0000000);
            var bmp:Bitmap = Bitmap(addChild(new Bitmap(__bmpd)));
            bmp.filters = [new GlowFilter(0x000000, 1, 12, 12, 1, 3 ) ];
            
            addSwarm();
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        
        public function render(e:Event=null) : void {
            if(__aSwarm.length <= 0) return;
            __bmpd.lock();
            var blur:Number = 1.1;
            var swarm:Swarm;
            var aTemp:Array = []
            for each( swarm in __aSwarm) {
                if(swarm.x < W && swarm.y < H && swarm.x >=0 && swarm.y >= 0) {
                    var color:uint = __bmpdMap.getPixel(swarm.x, swarm.y);
                    var bmpd:BitmapData = getCircle(swarm.radius, color);
                    __bmpd.copyPixels(bmpd, bmpd.rect, new Point(swarm.x - bmpd.width*.5, swarm.y - bmpd.height*.5), null, null, true);
                    
                    if(swarm.update()) aTemp.push(swarm); 
                    else swarm.destory();
                }else swarm.destory();
            }
            
            __aSwarm = aTemp;
            __bmpd.unlock();
        }
        
        
        public function addSwarm(e:Event=null) : void {
            var swarm:Swarm = new Swarm();
            swarm.x = W * .5;
            swarm.y = H * .5;
            swarm.x = W * Math.random() * .5 + W * .25;
            swarm.y = H * Math.random() * .5 + H * .25;
            
            __aSwarm.push(swarm);
            
            var delay:Number = Math.random()*.3 + .3;
            if( __timer != null) __timer.removeEventListener(TimerEvent.TIMER, addSwarm);
            __timer = new Timer(delay * 1000, 1);
            __timer.addEventListener(TimerEvent.TIMER, addSwarm);
            __timer.start();
        }
        
        
        public function clear(e:Event=null) : void {
            __bmpd.fillRect(RECT, 0x00000000);
        }
        
        
        public function getCircle(r:Number, color:uint) : BitmapData {
            var s:Shape = new Shape;
            s.graphics.beginFill(color, 1);
            s.graphics.drawCircle(r, r, r);
            s.graphics.endFill();
            
            var bmpd:BitmapData = getBitmapFromDisplayObject(s, true);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point, new GlowFilter(0x000000, .5, 20, 20, 1, 3, true));
            return bmpd;
        }
        
        
        public static function getBitmapFromDisplayObject(doTarget:DisplayObject, isTransparent:Boolean=true, defaultColor:uint=0x00000000) : BitmapData {
            var bmpd:BitmapData = new BitmapData(doTarget.width, doTarget.height, isTransparent, defaultColor);
            bmpd.draw(doTarget);
            return bmpd;
        }

    }
}

import flash.display.BitmapData;

class Swarm {
    public static const VELOCITY            : Number = 5;
    public var x                             : Number = 0;
    public var y                             : Number = 0;
    public var size                         : Number;
    public var bmpd                         : BitmapData;
    public var count                         : int;
    public var w                             : int;
    public var radius                        : Number = 10;
    
    public function Swarm(){
        w = int(Math.random() * 150) + 150;
        bmpd = new BitmapData(w, 1);
        bmpd.perlinNoise(w, 1, 3, Math.random()*1000, false, false);
        count = 0; 
    }
    
    
    public function update() : Boolean {
        count ++ ;
        if(count >= w)    return false;
        
        var color:uint = bmpd.getPixel(count, 0);
        var r:Number = (color >> 16 & 0xFF ) / 0xFF;
        var g:Number = (color >> 8 & 0xFF ) / 0xFF;
        var b:Number = (color & 0xFF ) / 0xFF;
        
        x += ( g - .3) * VELOCITY;
        y += ( b - .3) * VELOCITY;
        radius = 10 + 50 * r;
        
        return true;
    }
    
    
    public function destory() : void {
        bmpd.dispose();
    }
}
