/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Aitg
 */

package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class Partickles extends Sprite {
        public var partickles:Array;
        public var textles:Array;
        public var all:Array;
        
        public var textfield:TextField;
        public var textformat:TextFormat;
        
        public var bitmapdata:BitmapData;
        
        // change these two parameters
        public const MESSAGE:String = "gf";
        public const UNIT:Number = 2;
        
        public function Partickles() {
            partickles = [];
            textles = [];
            
            stage.quality = "low";
            
            for (var ci:int = 0; ci < 10; ci++) {
                partickles.push(
                                {
                                    x:465 / 2,
                                    y:465 / 2,
                                    ax:(Math.random() * 100 - 50) / 100,
                                    ay:(Math.random() * 100 - 50) / 100,
                                    fixed:false
                                }
                                );
            }
            
            textformat = new TextFormat();
            textformat.font = "Segoe UI Light";
            textformat.size = 192;
            textformat.align = "center";
            
            textfield = new TextField();
            textfield.text = MESSAGE;
            
            textfield.setTextFormat(textformat);
            
            textfield.width = textfield.textWidth + 4;
            textfield.height = textfield.textHeight + 4;
            textfield.x = 465 / 2 - textfield.width / 2;
            textfield.y = 465 / 2 - textfield.height / 2;
            
            this.addChild(textfield);
            
            bitmapdata = new BitmapData(465, 465);
            bitmapdata.draw(this);
            
            this.removeChild(textfield);
            
            for (var pw:int = 0; pw < 465; pw += UNIT) {
                for (var ph:int = 0; ph < 465; ph += UNIT) {
                    if (bitmapdata.getPixel(pw, ph) != 0xffffff) {
                        textles.push(
                                     {
                                         x:pw,
                                         y:ph,
                                         ax:(Math.random() * 100 - 50) / 100,
                                         ay:(Math.random() * 100 - 50) / 100,
                                         fixed:true
                                     }
                                     );
                    }
                }
            }
            
            all = partickles.concat(textles);
            
            this.addEventListener(Event.ENTER_FRAME, murmur);
        }
        
        public function murmur(e:Event):void {
            this.graphics.clear();
            
            for (var pi:int = 0; pi < all.length; pi++) {
                var cp:Object = all[pi];
                
                for (var ppi:int = 0; ppi < all.length; ppi++) {
                    if (ppi != pi) {
                        var cpp:Object = all[ppi];
                        var distance:Number = Point.distance(new Point(cp.x, cp.y), new Point(cpp.x, cpp.y));
                        
                        if (distance < mouseX / 5) {
                            this.graphics.lineStyle(1, 0, 1 - distance / (mouseX / 5));
                            this.graphics.moveTo(cp.x, cp.y);
                            this.graphics.lineTo(cpp.x, cpp.y);
                            
                            // this.graphics.lineStyle(1, 0, (1 - distance / (mouseX / 5)) / 2);
                            // this.graphics.drawCircle(cp.x + (cpp.x - cp.x) / 2, cp.y + (cpp.y - cp.y) / 2, distance / 2);
                        }
                    }
                }
                
                if (!cp.fixed) {
                    cp.x += cp.ax;
                    cp.y += cp.ay;
                    
                    cp.ax += (Math.random() * 100 - 50) / 100;
                    cp.ay += (Math.random() * 100 - 50) / 100;
                    
                    if (cp.x > 465) {
                        cp.x = 465;
                        cp.ax = -Math.abs(cp.ax);
                    }
                    if (cp.x < 0) {
                        cp.x < 0;
                        cp.ax = Math.abs(cp.ax);
                    }
                    if (cp.y > 465) {
                        cp.y = 465;
                        cp.ay = -Math.abs(cp.ay);
                    }
                    if (cp.y < 0) {
                        cp.y < 0;
                        cp.ay = Math.abs(cp.ay);
                    }
                        
                    if (Math.abs(cp.ax) > 10) {
                        cp.ax *= .25;
                    }
                    if (Math.abs(cp.ay) > 10) {
                        cp.ay *= .25;
                    }
                }
            }
        }
        
        public function isInsideTriangle(ax:Number, ay:Number, bx:Number, by:Number, cx:Number, cy:Number, px:Number, py:Number):Boolean {
            var planeAB:Number = (ax - px) * (by - py) - (bx - px) * (ay - py);
            var planeBC:Number = (bx - px) * (cy - py) - (cx - px) * (by - py);
            var planeCA:Number = (cx - px) * (ay - py) - (ax - px) * (cy - py);
            
            return sign(planeAB)==sign(planeBC) && sign(planeBC)==sign(planeCA);
        }
        
        public function sign(n:Number):int {
            return Math.abs(n)/n;
        }
    }
}