/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Aibd
 */

// forked from hacker_7daxapax's PV3DTest23　：テクスチャ貼り付け練習
//Base64データでのテクスチャ貼り付け練習です。 今回はFirefox、IE、Google Chromeともに動作しました。

//★★★　操作オブジェクトについて　：★★★★★★★★★★★★★★★★★★★★★
//←↑→↓ボタンで操作オブジェクトを移動させます
//←　→で方向決定、↑で前進、↓で後退
//Zボタンで弾丸発射
//ステージクリア時にZボタン押下で次ステージへ遷移
//ゲームオーバー時にZボタン押下でゲーム最初からリスタート
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

//★★★　移動状態について　：★★★★★★★★★★★★★★★★★★★★★★★★
//移動すると手足を動かします
//Bボタン押しながら前進・後退で移動速度3倍(手足を動かす速さは変わらず。。。)
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

//★★★　カメラについて　：★★★★★★★★★★★★★★★★★★★★★★★★★★
//W、Sボタンでカメラ位置を上下に変更(カメラのX軸回転を行います)
//A、Dボタンで操作オブジェクトの周りをカメラが回転します(カメラのY軸回転を行います)
//Aボタンで移動オブジェクトを中心にして左回転、Dボタンでは右回転します
//Fボタンで移動オブジェクトからのカメラの距離が変わります
//Rボタンでデフォルトのカメラ設定にもどる
//Qボタンで操作オブジェクトの背中側の真後ろにカメラを設定
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.KeyboardEvent; 
    import flash.events.IOErrorEvent;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.MovieMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.utils.MaterialsList;     
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.AntiAliasType;
    import flash.text.TextFormatAlign;
    import flash.geom.Rectangle;
    
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#111111")]
 
    public class MovieFigure extends Sprite
    {
        private var container    : Sprite;
        private var viewport     : Viewport3D;
        private var scene        : Scene3D;
        private var camera       : Camera3D;
        private var wireFramMate : WireframeMaterial;
        private var planeObj     : Plane;
        private var planeTexture : Plane;
        private var renderer     : BasicRenderEngine;
        private var PLANE_SIZE   : int = 4000; //土台となるPlaneオブジェクト1辺の長さ
        
        private var cameraPitch: int = 90; //カメラのX軸回転の値　
        private var cameraYaw : int = 270; //カメラのY軸回転の値　
        private var cameraDist : int = -1000; //カメラと操作オブジェクトのキョリ
        
        private var figure : Figure; //人型操作オブジェクト　カメラ視点の基準となる
        private var attackPow : int = 1; //人型操作オブジェクトの攻撃力
        private var enemyArray : Array = new Array(); //敵用配列       
        private var bulletArray : Array = new Array(); //弾丸用配列
        private const BULLET_NUM : int = 5; //最大弾丸表示数
        
        private var gameOrver : Boolean = false;
        private var stageClear : Boolean = false;
        private var stageNo : int = 1;
        private var label:Object=new Object(); //テキストフィールド(ラベル)用
        private var format:Object=new Object();//テキストフォーマット用
        
        private var attackSE : Sound;
        private var collisionSE : Sound;
        private var defeatSE : Sound;
        private var req : URLRequest;
        private var loader:Loader = new Loader();
        //Base64形式によるスライム画像データ
        private var base64SlaData:String = "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";

        //MovieFigureクラスのコンストラクタ
        public function MovieFigure():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //Planeオブジェクト用ワイヤーフレームマテリアル設定
            wireFramMate = new WireframeMaterial(0x0000FF);

            //Planeオブジェクト生成
            planeObj= new Plane(wireFramMate, PLANE_SIZE, PLANE_SIZE, 4, 4);
            planeObj.rotationX = 90;
            scene.addChild(planeObj);

            //Base64形式のデータからスライム画をロード
            var loader:Loader;
            loader = Util.base64ImageLoad(base64SlaData);
            //スライム画を単純表示＆3D用テクスチャとして貼り付ける実験
            addChild(loader);
            //↓BitmapMaterialではうまく表示できなかったのでMovieMaterialを使用
            //var material:BitmapMaterial = new BitmapMaterial(Bitmap(loader.content).bitmapData); 
            var material:MovieMaterial= new MovieMaterial(loader,true,true,true,new Rectangle(0,0,125,125));
            material.doubleSided = true; // 両面にテクスチャを貼る
            material.precise = true; // テクスチャの歪み防止
            planeTexture = new Plane(material, 1000, 1000);
            scene.addChild(planeTexture);

            //テキストフィールド(ラベル)を初期化
            labelInitializer();
            //効果音を初期化            
            soundInitializer();

            //ステージを初期化
            stageInitializer();

            //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;

            //イベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }

        //テキストフィールド(ラベル)の初期化処理
        private function labelInitializer():void{
            //操作オブジェクトを初期化
            //テキストフィールド(ラベル)の生成
            label["stageclear"]=Util.makeLabel(60,100,640,80);
            addChild(label["stageclear"]);
            label["gameover"]=Util.makeLabel(110,100,640,80);
            addChild(label["gameover"]);
            label["gameclear"]=Util.makeLabel(100,100,640,80);
            addChild(label["gameclear"]);
            //テキストフォーマットの生成
            format["stageclear"]=Util.makeTextFormat(50,0xFFFFFF);
            format["gameover"]=Util.makeTextFormat(50,0xFF0000);
            format["gameclear"]=Util.makeTextFormat(50,0x00FF00);      
        }

        //効果音の初期化処理
        private function soundInitializer():void{
            //mp3ファイルを読み込んでサウンドオブジェクト生成
            attackSE = new Sound();
            req = new URLRequest("http://oretaikan.atukan.com/mp3/attackSE.mp3");
            attackSE.load(req);
            attackSE.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            collisionSE = new Sound();
            req = new URLRequest("http://oretaikan.atukan.com/mp3/collisionSE.mp3");
            collisionSE.load(req); 
            collisionSE.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            defeatSE = new Sound();
            req = new URLRequest("http://oretaikan.atukan.com/mp3/defeatSE.mp3");
            defeatSE.load(req); 
            defeatSE.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
        }

        //各ステージの初期化処理
        private function stageInitializer():void{
            //操作オブジェクトを初期化
            initFigure();
            initBulleyArray(); //弾丸用配列の初期化
            //各ステージの敵の初期化
            var enemy : Enemy;
            if (stageNo == 1) {
                //体力３＆速度4(デフォルト)で敵Cubeを1体生成
                enemy = new Enemy(new MaterialsList({all:new ColorMaterial(0x0000FF)}),1800,230,1800,3);
                enemyArray.push(enemy)
                scene.addChild(enemy.body)
            } else if (stageNo == 2) {
                //ゲームクリア時処理
                editLabel("stageclear","");
                editLabel("gameclear","GAME CLEAR");
                defeatSE.play();
            }        
        }

        //Figureオブジェクトの初期化
        private function initFigure():void{
            //Figureオブジェクト生成          
            figure = new Figure(new MaterialsList({all:new ColorMaterial(0xFF0000)}),
                                  new ColorMaterial(0xFF7700),
                                  0,230,-1800);
            scene.addChild(figure.body);          
        }
        
        //弾丸用配列の初期化
        private function initBulleyArray():void{
            var bullet : Bullet;
            for (var i : int = 0; i < bulletArray.length; i++) {
                bullet = bulletArray[i];
                scene.removeChild(bullet.body);
                bulletArray.splice(i,1);
                i--;
           }          
        }
        
        //敵配列の初期化
        private function initEnemyArray():void{
            var enemy : Enemy;
            for (var i : int = 0; i < enemyArray.length; i++) {
                enemy = enemyArray[i];
                scene.removeChild(enemy.body);
                enemyArray.splice(i,1);
                i--;
           }          
        }
        
        //フレーム毎の処理
        private function onEnterFrame(event:Event):void{
            figure.draw();
            calcEnemy();
            calcBullet();
            //カメラ視点設定            
            setCamera();
            renderer.renderScene(scene, camera, viewport);          
        }

        //カメラ視点設定
        private function setCamera():void{
            //camera.x=-1000*Math.cos((90-body.rotationY)*Math.PI/180)+body.x;  
            //camera.z=-1000*Math.sin((90-body.rotationY)*Math.PI/180)+body.z;
            camera.x=cameraDist*Math.cos((90-figure.getRotY())*Math.PI/180)+figure.getPosX();  
            camera.z=cameraDist*Math.sin((90-figure.getRotY())*Math.PI/180)+figure.getPosZ();
            camera.target.x=figure.body.x;
            camera.target.y=figure.body.y;
            camera.target.z=figure.body.z;
                        
            camera.orbit(cameraPitch, cameraYaw, true, figure.body);
        }    
            
        
        //キーボードを押したときの処理
        //←↑→↓ボタン処理：　操作オブジェクト移動処理
        //A、D、W、Sボタン処理：　カメラ視点変更処理
        //F、R、Qボタン処理　F：カメラ距離変更　R：カメラ設定をデフォルトに　Q：カメラを操作オブジェクトの背面に設定
        //Zボタン：　１.通常時は弾丸発射　２.ステージクリア時は次のステージへ　３.ゲームオーバー時はゲームリスタート
        //Bボタン処理：　Bダッシュを行う
        private function onKeyDown(event:KeyboardEvent):void{
            //ステージクリア時とゲームオーバー時のキーボード処理
            if (stageClear) { //ステージクリア時
                if (event.keyCode == 90) { //Zボタン押下で次ステージへ遷移
                    editLabel("stageclear","");
                    stageClear = false; //クリア時ステータスを初期化
                    scene.removeChild(figure.body); //初期化のため一時操作オブジェクトを削除
                    stageInitializer(); //次のステージの初期化
                }
                return;
            } else if (gameOrver) { //ゲームオーバー時
                if (event.keyCode == 90) { //Zボタン押下でゲームリスタート
                    initEnemyArray();  //残っている敵オブジェクト配列を初期化
                    editLabel("gameover","");
                    gameOrver = false;  //ゲームオーバー時ステータスを初期化
                    stageNo = 1;  //ステージを1にもどす
                    scene.removeChild(figure.body);  //初期化のため一時操作オブジェクトを削除
                    stageInitializer();  //ステージの初期化
                }                
                return;
            }
            
            //←ボタンDOWN 左回転の設定    
            if (event.keyCode == 37) {
                figure.leftButtonActioin();
            //→ボタンDOWN 右回転の設定
            } else if (event.keyCode == 39) {
                figure.rightButtonActioin();
            //↑ボタンDOWN 前進の設定
            } else if (event.keyCode == 38) {
                figure.upButtonActioin();
            //↓ボタンDOWN 後退の設定
            } else if (event.keyCode == 40) {
                figure.downButtonActioin();
            //Bボタン　Bボタン押下中は前進・後退中の移動速度3倍
            } else if (event.keyCode == 66) {
                figure.bButtonActioin();
            //Zボタン　攻撃用の弾を発射
            } else if (event.keyCode == 90) {
                attack();
            //Aボタン　操作オブジェクトを中心にカメラを左回り回転(Y軸回転)
            //4度づつ左回り回転   
            }  else if (event.keyCode == 65) {
                cameraYaw = cameraYaw - 4;
                if(cameraYaw < 0) {cameraYaw = 360;}
            //Dボタン　操作オブジェクトを中心にカメラを右回り回転(Y軸回転)    
            //4度づつ右回り回転
            } else if (event.keyCode == 68) {
                cameraYaw = cameraYaw + 4;
                if(cameraYaw > 360) {cameraYaw = 0;}
            //Wボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 87) {        
                if(cameraPitch > 50) {cameraPitch = cameraPitch - 10;}
            //Sボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 83) {           
                if(cameraPitch < 100) {cameraPitch = cameraPitch + 10;}
            //Fボタン　カメラと操作オブジェクトの距離を変更
            } else if (event.keyCode == 70) {
                cameraDist += 500;
                if(cameraDist > -500) {cameraDist = -1500;}
            //Rボタン　カメラの設定をデフォルトにもどす
            } else if (event.keyCode == 82) {
                cameraDist = -1000;
                cameraPitch = 90; //カメラのX軸回転の値　
                cameraYaw = 270; //カメラのY軸回転の値
            //Qボタン　カメラの操作オブジェクト背中の真後ろに設定
            } else if (event.keyCode == 81) {
                cameraYaw = 270 - figure.getRotY();
            }
        }
        
        //キーボードを離したときの処理
        //←↑→↓ボタンリリース時処理(操作オブジェクト移動のための設定解除)
        private function onKeyUp(event:KeyboardEvent):void{
            //←ボタンUP 左回転の設定設定解除     
            if (event.keyCode == 37) {
                figure.leftButtonRelease();
            //→ボタンUP 右回転の設定設定解除
            } else if (event.keyCode == 39) {
                figure.rightButtonRelease();               
            //↑ボタンUP 前進の設定設定解除
            } else if (event.keyCode == 38) {
                figure.upButtonRelease();
            //↓ボタンUP 後退の設定設定解除
            } else if (event.keyCode == 40) {
                figure.downButtonRelease();
            //BボタンUP　Bダッシュ解除
            } else if (event.keyCode == 66) {
                figure.bButtonRelease();
            }
        }
        
        //Zボタン押下時に攻撃用の弾丸を発射
        private function attack():void{
            //Shpereによる攻撃用の弾丸を生成
            //画面内に最大5発の弾丸を表示
            if (bulletArray.length < BULLET_NUM) {
                var bullet : Bullet = new Bullet(figure.getRotY(),figure.getPosX(),figure.getPosZ());
                bulletArray.push(bullet);
                scene.addChild(bullet.body);
                attackSE.play(); //弾丸発射時効果音を鳴らす
            }            
        }
        
        //発射された弾丸の処理
        private function calcBullet():void{
            //bulleArray配列内から弾丸をとりだして処理を行う
            var bullet : Bullet;
            for (var i : int = 0; i < bulletArray.length; i++) {
                bullet = bulletArray[i];
                bullet.move(); //弾丸の移動処理
                //土台となるPlaneオブジェクトの範囲より外に出た弾丸は削除
                //Planeオブジェクトのサイズを元に範囲指定
                if (bullet.boundaryCheck(PLANE_SIZE/2)) {
                    scene.removeChild(bullet.body);
                    bulletArray.splice(i,1);
                    i--;
                    continue;
                } 
                //弾丸と攻撃対象敵Cubeの当たり判定を行う
                //弾丸と衝突した攻撃対象敵Cubeは削除
                var enemy : Enemy;
                for (var j : int = 0; j < enemyArray.length; j++) {
                    enemy = enemyArray[j];
                    //弾丸が敵Cubeと衝突時、弾丸を削除　
                    //攻撃力にあわせて敵Ｃｕｂｅの体力も減らす(isCollisionメソッド内で処理)
                    if (enemy.isCollision(
                        bullet.getLeftPosX(),bullet.getRightPosX(),bullet.getFrontPosZ(),bullet.getBackPosZ(),attackPow)) {
                        scene.removeChild(bullet.body);
                        bulletArray.splice(i,1);
                        i--;
                        collisionSE.play(); //衝突時効果音を鳴らす
                        //敵Cube体力がなくなったときは敵Ｃｕｂｅ削除
                        if (!enemy.isAlive()) {
                            scene.removeChild(enemy.body);
                            enemyArray.splice(j,1);
                            j--;
                            //敵Cube全て削除時はステージクリア
                            if (enemyArray.length < 1) {
                                editLabel("stageclear","STAGE"+stageNo+" CLEAR");
                                stageClear = true;
                                stageNo += 1; 
                                break;                           
                            }                            
                        }

                    }
                }
            }
        }
        
        //敵Cubeの処理
        private function calcEnemy():void{
            //enemyArray配列内から敵データをとりだして処理を行う
            var enemy : Enemy;
            for (var i : int = 0; i < enemyArray.length; i++) {
                enemy = enemyArray[i];
                enemy.move(figure.getPosX(),figure.getPosZ());
                if (enemy.body.hitTestObject(figure.body)) {
                    editLabel("gameover","GAME OVER");
                    gameOrver = true;
                    scene.removeChild(figure.body); //操作オブジェクトを削除
                }
            }
        }

        //テキストフィールド(ラベル)の編集
        private function editLabel(key:String,text:String):void {
            label[key].text=text;
            label[key].setTextFormat(format[key]);        
        }

        //Soundオブジェクト用エラーハンドラ
        private function errorHandler(event:IOErrorEvent):void {
            trace("Couldn't load sound resource file " + event.text);
        }                                                           
    }
}
    
import flash.display.Sprite;
import org.papervision3d.objects.primitives.Cube;
import org.papervision3d.objects.primitives.Sphere;
import org.papervision3d.objects.primitives.Cylinder;   
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.utils.MaterialsList;
//操作オブジェクトを作成
class Figure
{
    public var body : Cube; //胴体部
    private var head : Sphere; //頭部
    private var leftHand : Cylinder; //画面向かって左側手
    private var rightHand : Cylinder; //画面向かって右側手
    private var leftFoot : Cylinder; //画面向かって左側足
    private var rightFoot : Cylinder; //画面向かって右側足
    private var materials : MaterialsList;
    
    private var status : int = 0; //操作オブジェクトの表示制御用ステータス　
    private var rotat : Boolean = false; //Y軸回転判定　
    private var rotatNum : int = 0; //Y軸回転角度　
    private var wardMove : Boolean = false; //前進後退判定　
    private var wardMoveNum : int = 0; //前進後退速度 
    private var bDash : Boolean = false; //Bダッシュ判定
    private var walkDispInterval : int = 0; //歩行表示間隔カウンター
    private const INTERVAL: int = 24; //歩行表示間隔
           
    public function Figure(colMateListForBody:MaterialsList,
                           colMateForLimbs:ColorMaterial,
                           x:int=0,y:int=230,z:int=0):void {
        //操作用人型オブジェクトを作成
        //胴体部オブジェクトを親として頭部・手足を子オブジェクトとして加えていく
        //胴体部をCubeオブジェクトで作成
        body = new Cube(colMateListForBody, 150, 100, 160);
        body.x = x;
        body.y = y;
        body.z = z;
                    
        //頭部をSphereでオブジェクト作成
        head = new Sphere(colMateForLimbs, 65, 8, 6);
        head.y = 150;
        body.addChild(head);
       
        //Cylinderオブジェクトで手足を作成
        //画面向かって左側の手をCylinderオブジェクトで生成
        leftHand = new Cylinder(colMateForLimbs,20,130);
        leftHand.x = -110;
        leftHand.y = 10;
        body.addChild(leftHand);
            
        //画面向かって右側の手をCylinderオブジェクトで生成
        rightHand = new Cylinder(colMateForLimbs,20,130);
        rightHand.x = 110;
        rightHand.y = 10;
        body.addChild(rightHand);
            
        //画面向かって左側の足をCylinderオブジェクトで生成
        leftFoot = new Cylinder(colMateForLimbs,30,130);
        leftFoot.x = -50;
        leftFoot.y = -160;
        body.addChild(leftFoot);
            
        //画面向かって右側の足をCylinderオブジェクトで生成
        rightFoot = new Cylinder(colMateForLimbs,30,130);
        rightFoot.x = 50;
        rightFoot.y = -160;
        body.addChild(rightFoot);
    }
    
    //←ボタン押下時処理
    public function leftButtonActioin():void {
        rotat = true;
        rotatNum = -5;
        //操作ボタン押下時の値：1を設定
        if(walkDispInterval < 1) {
            walkDispInterval = 1;
        }
    }//←ボタンリリース時処理
    public function leftButtonRelease():void {
        rotat = false;
        //操作ボタンリリース時の値：0を設定　他の操作ボタン押下中には設定しない
        if(!rotat && !wardMove) {
            walkDispInterval = 0;
        }
    }
    
    //→ボタン押下時処理        
    public function rightButtonActioin():void {
        rotat = true;
        rotatNum = 5;
        if(walkDispInterval < 1) {
            walkDispInterval = 1;
        }       
    }//→ボタンリリース時処理
    public function rightButtonRelease():void {
        rotat = false;
        if(!rotat && !wardMove) {
            walkDispInterval = 0;
        }
    }
    
    //↑ボタン押下時処理 
    public function upButtonActioin():void {
        wardMove = true;
        wardMoveNum = 10; 
        if(walkDispInterval < 1) {
            walkDispInterval = 1;
        }       
    }//↑ボタンリリース時処理 
    public function upButtonRelease():void {
        wardMove = false;
        if(!rotat && !wardMove) {
            walkDispInterval = 0;
        }
    }
    
    //↓ボタン押下時処理 
    public function downButtonActioin():void {
        wardMove = true;
        wardMoveNum = -5;
        if(walkDispInterval < 1) {
            walkDispInterval = 1;
        }        
    }//↓ボタンリリース時処理 
    public function downButtonRelease():void {
        wardMove = false;
        if(!rotat && !wardMove) {
            walkDispInterval = 0;
        }
    }
    
    //Bボタン押下時処理 
    public function bButtonActioin():void {
        bDash = true;        
    }//Bボタンリリース時処理 
    public function bButtonRelease():void {
        bDash = false;
    }
    
    //胴体部の方向情報を返す
    public function getRotY():int {
        return body.rotationY;        
    }
    //胴体部のX軸位置情報を返す 
    public function getPosX():int {
        return body.x;
    }
    //胴体部のZ軸位置情報を返す
    public function getPosZ():int {
        return body.z;
    }
    
    //操作オブジェクトのY軸回転を設定
    public function setRotationY(rotY:int=0):void {
        body.rotationY = rotY;
    }     
    //操作オブジェクトの位置を設定
    public function setPosision(x:int=0,y:int=230,z:int=0):void {
        body.x = x;
        body.y = y;
        body.z = z;
    }    
    //操作対象オブジェクトの手足表示を初期状態にもどす
    public function setDefaultWalkDisp():void {
        //左手、右足を初期状態へもどす
        leftHand.z = 0;
        leftHand.rotationX = 0;
        rightFoot.z = 0;
        rightFoot.rotationX = 0;
        //右手、左足を初期状態へもどす
        rightHand.z = 0;
        rightHand.rotationX = 0;
        leftFoot.z = 0;
        leftFoot.rotationX = 0;
        status = 0;
    }        
    //操作対象オブジェクトの手足表示を制御
    private function ctrlWaklDisp():void{
        //status：操作オブジェクトの表示制御用ステータス　
        //0:直立　
        //1:左手、右足前方＆右手、左足後方
        //2:左手、右足後方＆右手、左足前方
        //前進・後退時は1と2の状態を交互に繰り返す
        //直立状態(0)からは(1)の状態へ遷移
        if (status == 0) {status = 1;}
        //(1)の状態をセット後、ステータスを(2)に変更
        if (status == 1) {
            //左手、右足前方
            leftHand.z = 70;
            leftHand.rotationX = -40;
            rightFoot.z = 50;
            rightFoot.rotationX = -30;
            //右手、左足後方
            rightHand.z = -70;
            rightHand.rotationX = 40;
            leftFoot.z = -50;
            leftFoot.rotationX = 30;
            status = 2;
        //(2)の状態をセット後、ステータスを(1)に変更
        } else if (status == 2) {
            //左手、右足後方
            leftHand.z = -70;
            leftHand.rotationX = 40;
            rightFoot.z = -50;
            rightFoot.rotationX = 30;
            //右手、左足前方
            rightHand.z = 70;
            rightHand.rotationX = -40;
            leftFoot.z = 50;
            leftFoot.rotationX = -30;
            status = 1;
        }
    }
                     
    public function draw():void {
        //←　→ボタンが押され続けている間、操作オブジェクトを回転させる
        if (rotat) {
           body.rotationY += rotatNum; 
        }
        //↑　↓ボタンが押され続けている間、操作オブジェクトを前進・後退させる
        if (wardMove) {
            //Bボタンが押されていないときの前進・後退は通常の移動速度
            if (!bDash) {
                body.moveForward(wardMoveNum);
            //Bボタンが押されているときの前進・後退は通常の3倍速    
            } else {
                body.moveForward(wardMoveNum*3);    
            }   
        }
        
        //walkDispInterval：
        //操作ボタン押下時は1の値、
        //操作ボタン押下継続中は1以上の値、
        //操作ボタンリリース時は0を設定
            
        //操作ボタンの最初の押下時の歩行表示を行う
        if(walkDispInterval == 1) {
            //歩行表示
            ctrlWaklDisp();
        }
        //操作ボタン押下継続の間、指定した間隔で歩行表示
        if((rotat || wardMove) && walkDispInterval >= 1) {
            //いずれかの操作ボタン押下継続時に歩行表示カウンタをカウントアップ
            walkDispInterval++;
            //指定したインターバルを経過時に歩行表時
            if(walkDispInterval > INTERVAL) {
                //歩行表示
                ctrlWaklDisp();
                //歩行表示カウンタを2にもどす(1にもどした場合上記の最初の押下時処理を必ず通り表示がおかしくなるため)
                walkDispInterval = 2;
            }
        }        
    }
}

import flash.display.Sprite;
import org.papervision3d.objects.primitives.Sphere;  
import org.papervision3d.materials.ColorMaterial;
//弾丸Sphereを作成
class Bullet
{
    public var body : Sphere; //攻撃用の弾丸本体
    
    private var speedX : int = 0; //弾丸X方向速度
    private var speedZ : int = 0; //弾丸Z方向速度　
    private const SPEED : int = 30; //弾丸の速度　
    private const RADIUS: int = 15; //弾丸本体Sphereの半径
                   
    public function Bullet(figRotation:int=0,figX:int=0,figZ:int=0):void {
        body = new Sphere(new ColorMaterial(0xFFFF00), RADIUS, 8, 6);
        body.x = figX; //　弾丸のX軸の初期値を設定
        body.y = 250; //　弾丸のY軸の初期値を設定
        body.z = figZ; //　弾丸のZ軸の初期値を設定
        //　弾丸速度をX軸の速度成分に分解
        speedX = SPEED * Math.cos((90-figRotation)*Math.PI/180);
        //　弾丸速度をZ軸の速度成分に分解
        speedZ = SPEED * Math.sin((90-figRotation)*Math.PI/180);
    }
    
    //X軸とZ軸の速度成分を加算して、X軸とZ軸の移動先の座標を計算
    public function move():void {
        body.x += speedX;
        body.z += speedZ;
    }    

    //弾丸Sphereが画面指定範囲内かチェック
    public function boundaryCheck(boundary:int):Boolean {
        if(body.x > boundary || body.x < -1*boundary
           || body.z > boundary || body.z < -1*boundary) {
               return true;
        }
        return false;
    } 
        
    //X軸位置情報を返す 
    public function getPosX():int {
        return body.x;
    }
    //Z軸位置情報を返す
    public function getPosZ():int {
        return body.z;
    }

    //弾丸Sphere左端のX軸位置情報を返す 
    public function getLeftPosX():int {
        return body.x - RADIUS;
    }
    //弾丸Sphere右端のX軸位置情報を返す
    public function getRightPosX():int {
        return body.x + RADIUS;
    } 
    //弾丸Sphereの手前側のZ軸位置情報を返す 
    public function getFrontPosZ():int {
        return body.z - RADIUS;
    }
    //弾丸Sphereの奥側のZ軸位置情報を返す
    public function getBackPosZ():int {
        return body.z + RADIUS;
    }       
}                               
                               
import flash.display.Sprite;
import org.papervision3d.objects.primitives.Cube;  
import org.papervision3d.materials.ColorMaterial;
//敵Cubeを作成
class Enemy
{
    public var body : Cube; //攻撃対象となる敵本体
    
    private var energy : int = 1; //体力
    private var duration : int = 0; //
    private var speedX : int = 0; //敵X方向移動速度
    private var speedZ : int = 0; //敵Z方向移動速度　
    private var speed : int = 4; //敵移動速度　
    private const SIZE: int = 300; //敵本体Cubeのサイズ(縦、横、高さ同じ)
    private const DURATION: int = 180; //敵移動先の再計算までの間隔
               
    public function Enemy(colMateList:MaterialsList,
                           posX:int=0,posY:int=0,posZ:int=0,energy:int=1,speed:int=4):void {
        body = new Cube(colMateList, SIZE, SIZE, SIZE);
        body.x = posX; //　敵のX軸の初期値を設定
        body.y = posY; //　敵のY軸の初期値を設定
        body.z = posZ; //　敵のZ軸の初期値を設定
        this.energy = energy;
        this.speed = speed;
    }
    
    //操作オブジェクトのXとZ軸の座標を元に、敵の移動先を計算  
    public function move(figX:int,figZ:int):void {
        var dist : Number;
        if (duration > 0) {
            body.x += speedX;
            body.z += speedZ;
            duration--;
        } else {
            dist = Math.sqrt(Math.pow(figX-body.x,2)+Math.pow(figZ-body.z,2));
            speedX = Math.round((figX-body.x)/dist*speed);
            speedZ = Math.round((figZ-body.z)/dist*speed);
            duration = DURATION;
        }
    }    
    
    //敵Cubeが画面指定範囲内かチェック(予定)
    public function boundaryCheck(boundary:int):Boolean {
        if(body.x > boundary || body.x < -1*boundary
           || body.z > boundary || body.z < -1*boundary) {
               return true;
        }
        return false;
    } 
        
    //X軸位置情報を返す 
    public function getPosX():int {
        return body.x;
    }
    //Z軸位置情報を返す
    public function getPosZ():int {
        return body.z;
    }

    //敵Cube左端のX軸位置情報を返す 
    public function getLeftPosX():int {
        return body.x - SIZE/2;
    }
    //敵Cube右端のX軸位置情報を返す
    public function getRightPosX():int {
        return body.x + SIZE/2;
    } 
    //敵Cubeの手前側のZ軸位置情報を返す 
    public function getFrontPosZ():int {
        return body.z - SIZE/2;
    }
    //敵Cubeの奥側のZ軸位置情報を返す
    public function getBackPosZ():int {
        return body.z + SIZE/2;
    }
        
    //対象と敵CubeのXZ軸端の座標の交差による当たり判定(交差判定によるあたり判定)
    //Y軸は同じ座標にあるものとして判定を行わない
    public function isCollision(bulLeftX:int,bulRightX:int,bulFrontZ:int,bulBackZ:int,attackPow:int=1):Boolean {
        //交差判定による敵Cubeとの当たり判定計算
        if ((getRightPosX() > bulLeftX) && (bulRightX > getLeftPosX()) 
             && (getBackPosZ() > bulBackZ) && (bulFrontZ > getFrontPosZ())) {
            energy -= attackPow; //体力を減らす
            return true;
        } else {
            return false;
        }
    }

    //敵Cubeの体力が残っているか判定
    //Y軸は同じ座標にあるものとして判定を行わない
    public function isAlive():Boolean {
        //体力が0以下の場合、真を返す
        if (energy > 0) {
            return true;
        } else {
            return false;
        }
    }

    //対象と敵Cubeの距離で当たり判定(平方根によるあたり判定)
    //Y軸は同じ座標にあるものとして判定を行わない
    public function isCollisionBySqrt(bulX:int,bulZ:int,compDist:int):Boolean {
        //平方根を用いて弾丸と攻撃対象Cubeとの距離を計算
        var dist : Number = 
        Math.sqrt(Math.pow(bulX-getPosX(),2)+Math.pow(bulZ-getPosX(),2));
        if (dist > compDist) {
            return false;
        } else {
            return true;
        } 
    }         
}                                                                      
                                                             
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.AntiAliasType;
import flash.text.TextFormatAlign;
import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.utils.ByteArray;
import mx.utils.Base64Decoder;
//ユーティリティ
class Util
{
    //テキストフィールドの生成
    public static function makeLabel(posX:int,posY:int,width:int,height:int):TextField {
        var label:TextField=new TextField();
        label.selectable=false;
        label.x       =posX;
        label.y       =posY;
        label.width   =width;
        label.height  =height;
        label.antiAliasType=AntiAliasType.ADVANCED;
        return label;
    }

    //テキストフォーマットの生成
    public static function makeTextFormat(size:uint,color:uint,align:String=TextFormatAlign.LEFT):TextFormat {
        var format:TextFormat=new TextFormat();
        format.font ="Courier New"; // 等幅フォント
        format.size =size;  
        format.color=color;
        format.bold =true;
        format.align=align;
        return format;
    }

    //Base64化された画像データを表示可能な形式に変換する
    public static function base64ImageLoad(data:String):Loader {
        var byteArray:ByteArray;
        var base64Decoder:Base64Decoder;
        var loader:Loader;
        
        base64Decoder = new Base64Decoder();
        base64Decoder.decode(data);
        
        try {
            byteArray = base64Decoder.toByteArray();
            byteArray.position = 0;
        } catch (e:Error) {
            return null;
        }
        
        loader = new Loader();
        loader.loadBytes(byteArray);
        
        return loader;
    }
}



