/**
 * Copyright dotton ( http://wonderfl.net/user/dotton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AiTY
 */

// forked from dotton's パーティクルテスト
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    
    import idv.cjcat.stardust.common.actions.*;
    import idv.cjcat.stardust.common.clocks.*;
    import idv.cjcat.stardust.common.emitters.*;
    import idv.cjcat.stardust.common.renderers.*;
    import idv.cjcat.stardust.common.initializers.*;
    import idv.cjcat.stardust.common.math.*;
    import idv.cjcat.stardust.twoD.actions.*;
    import idv.cjcat.stardust.twoD.emitters.*;
    import idv.cjcat.stardust.twoD.initializers.*;
    import idv.cjcat.stardust.twoD.zones.*;
    import idv.cjcat.stardust.twoD.renderers.*;
    
    [SWF(frameRate="30", backgroundColor="#000000")]
    public class FlashTest extends Sprite {
        
    		//エミッター パーティクルの発生源
    		private var emitter:Emitter2D;
    		//レンダラー レンダリング用
    		private var renderer:Renderer;
    		
    		protected var point:SinglePoint;
    		
        private var _bmd:BitmapData;
        private var _sp:Sprite;
        private var _container:Sprite;
        private var _filter:BlurFilter;
        
        public function FlashTest() {
        	
    	
     		stage.scaleMode = StageScaleMode.NO_SCALE;
      		stage.align = StageAlign.TOP_LEFT;
      		stage.quality = StageQuality.MEDIUM;
        		
            _filter =new BlurFilter(7,7);
            _filter.quality = BitmapFilterQuality.MEDIUM;
      	  	_bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00FFFFFF);
            addChild(new Bitmap(_bmd));
            
        		var mc:MovieClip = new MovieClip();
            mc.x = 0;
            mc.y = 0;
            
            _container = new Sprite();
            _container.addChild(mc);
            addChild(_container);
            
            point = new SinglePoint(0,0);
            
            //クロック １ステップごとに発生させたい数値
            var clock:SteadyClock =new SteadyClock(5);
            
            //エミッターを定義し、クロックを渡す
            emitter =new Emitter2D(clock);
            
            //レンダラーを定義し、レンダリングするmcを渡す
            renderer = new DisplayObjectRenderer(mc);
            
            //レンダラーにエミッターを渡す
            renderer.addEmitter(emitter);
            
            //エミッターの初期値を定義
            //パーティクル用のアイテムを指定
            emitter.addInitializer(new DisplayObjectClass(MyCircle));
            
            //パーティクルにかかる力を指定
            emitter.addInitializer(new Velocity(new LazySectorZone(0.2,0)));
            
            //パーティクルのライフを指定
            emitter.addInitializer(new Life(new UniformRandom(10, 10)));
            
            //パーティクルの発生位置を
            emitter.addInitializer(new Position(point));
            
            //エミッターのアクションを登録
            //寿命を有効化
            emitter.addAction(new Age());
            //消えるを有効化
            emitter.addAction(new DeathLife());
           	//加速を有効化
           	emitter.addAction(new Accelerate(0.1));
           	//移動を有効化
           	emitter.addAction(new Move());
           	// スケール変化を有効化
           	emitter.addAction(new ScaleCurve(1, 5));
           	
           	
           	//エンターフレームイベントの記録
           	addEventListener(Event.ENTER_FRAME, loop);
            
        }
        
        private function loop(e:Event):void{
        		point.x = mouseX;
			point.y = mouseY;
        		//エミッターを更新
        		emitter.step();
        		
        		//_bmd.draw(_container, null, null, BlendMode.DARKEN);
        		//_bmd.applyFilter(_bmd, _bmd.rect, new Point(), _filter);
      
        }
    }
}

import flash.display.*;
class MyCircle extends Sprite{
	public function MyCircle(){
		this.graphics.beginFill(0x99ff11, .5);
		this.graphics.drawCircle(0, 0 , 1);
	}
}