/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AhYs
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	
	[SWF(backgroundColor=0x000000)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const DOT_NUM:int = 400;
		private const SIDE:int = 20;
		
		private var container:Sprite;
		private var dots:Vector.<Sprite> = new Vector.<Sprite>(DOT_NUM, true);
		private var len:Number = 10;
		private var minDist:Number = 100;
		private var point:Point = new Point();
		
		public function Main():void 
		{
			container = new Sprite();
			container.graphics.beginFill(0x0);
			container.graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight);
			addChild(container);
			
			for (var i:int = 0; i < DOT_NUM; i++)
			{
				var dot:Sprite = new Sprite();
				dot.graphics.beginFill(0xFFFFFF);
				dot.graphics.drawCircle(0, 0, 5);
				dot.graphics.endFill();
				dot.scaleX = dot.scaleY = .2;
				dot.blendMode = BlendMode.DIFFERENCE;
				dot.x = (i % SIDE + 1) * len + ((stage.stageWidth-SIDE*len)/2) ;
				dot.y = int(i / SIDE + 1 ) * len + ((stage.stageHeight-SIDE*len)/2) ;
				dots[i] = dot;
				container.addChild(dot);
			}
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			point.x += (container.mouseX - point.x) * .2;
			point.y += (container.mouseY - point.y) * .2;
			for (var i:int = 0; i < DOT_NUM; i++) 
			{
				var dot:Sprite = dots[i] as Sprite;
				var dx:Number = point.x - dot.x;
				var dy:Number = point.y - dot.y;
				var dist:Number = Math.sqrt(dx * dx + dy * dy);
				if (dist < minDist)
				{
					var scale:Number = (minDist - dist) / minDist * 5 + .1;
					dot.scaleX = dot.scaleY = scale;
				}
				else
				{
					dot.scaleX = dot.scaleY = .2;
				}
			}
		}
	}
}