/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AhH2
 */

package {	
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0x000000")]
	
    public class FlashTest extends Sprite {
    	
		private var polygons:Vector.<Polygon>;
		private var tf:TextField;
		private var fm:TextFormat;
        public function FlashTest() {
            // write as3 code here..
            
Wonderfl.capture_delay(10);
			fm = new TextFormat('_typewriter', 12, 0x000000);
			polygons = new Vector.<Polygon>;
			for (var i:int = 0; i < 7; i++ ) {
				for (var j:int = 0; j < 6; j++ ) {
					var p:Polygon = new Polygon(6, 50);
					p.drawPolygon();
					addChild(p);
					p.filters = [new BlurFilter(2, 2)];
					polygons.push(p);
					//p.rotation = 0;
					
					tf = new TextField();
					tf.name = 'text';
					tf.defaultTextFormat = fm;
					tf.text = 'Emergency';
					tf.x = -tf.textWidth / 2;
					tf.y = -tf.textHeight / 2;
					p.addChild(tf);
					
					var a:Sprite = new Sprite();
					a.graphics.beginFill(0x00000);
					a.graphics.moveTo(20 / 2, 10);
					a.graphics.lineTo(20, 20);
					a.graphics.lineTo(0, 20);
					a.graphics.endFill();
					p.addChild(a);
					a.x = -10;
					a.y = -50;
					
					var b:Sprite = new Sprite();
					b.graphics.beginFill(0x000000);
					b.graphics.moveTo(0, 0);
					b.graphics.lineTo(20, 0);
					b.graphics.lineTo(20 / 2, 10);
					b.graphics.endFill();
					p.addChild(b);
					b.x = -10;
					b.y = 30;
					
					//手計算気持ち悪い
					p.x = 78 * i;
					if ((i + 1) % 2) {
						p.y = 90 * j;
					} else {
						p.y = 45 + (90 * j);
					}
				}
			}
			
			alert();
			youtube();
            
        }
        
		private function alert():void
		{
			var alertTween:ITween;
			var tweens:Array = [];
			polygons.forEach(function(p:Polygon, i:int, a:Vector.<Polygon>):void {
				tweens.push(BetweenAS3.tween(p, { alpha:0 }, { alpha:1 }, Math.random() * 2));
			} );
			alertTween = BetweenAS3.parallelTweens(tweens);
			alertTween.play();
			alertTween.onStop = function():void {
				polygonsEffect();
			}
			alertTween.onComplete = function():void {
				alert();
			}
			//alertTween.stopOnComplete = false;
			stage.addEventListener(MouseEvent.CLICK, function():void {alertTween.stop()} );
		}
		
		private function polygonsEffect(e:MouseEvent = null):void
		{
			polygons.forEach(function(p:Polygon, i:int, a:Vector.<Polygon>):void {
				p.alpha = 1;
				p.removeChild(p.getChildByName('text'));
				p.drawPolygon(0x00ff00);
			} );
		}
        
		private function youtube():void
		{
			Security.allowDomain('www.youtube.com');
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
			loader.load(new URLRequest('http://www.youtube.com/apiplayer?version=3'));
		}
		
		private function onLoaderInit(e:Event):void 
		{
			e.currentTarget.loader.content.addEventListener('onReady', onPleyerReady);
			e.currentTarget.loader.x = stage.stageWidth - 100;
			e.currentTarget.loader.y = stage.stageHeight - 100;
			addChild(e.currentTarget.loader);
		}
		
		private function onPleyerReady(e:Event):void 
		{
			e.currentTarget.setSize(100,100);
			e.currentTarget.cueVideoById('AtW1nHbXa34');
			e.currentTarget.playVideo();
			
			stage.addEventListener(MouseEvent.CLICK, function():void {
				e.currentTarget.stopVideo();
			} );
		}
    }
}

import flash.display.Sprite;
import flash.geom.Point;

class Polygon extends Sprite
{
	private var points:Array;
	private var _num_point:uint;
	private var _r:Number;
	
	public function Polygon(num_point:uint, r:Number)
	{
		_num_point = num_point;
		_r = r;
		
		var theta:Number = (360 / _num_point) * (Math.PI / 180);
		points = new Array();
		for (var i:int = 0; i < _num_point; i++ ) {
			var pt:Point = Point.polar(_r, theta * i);
			points.push(pt);
		}
		this.rotation -= 90;
	}
	
	public function drawPolygon(color:uint = 0xff0000):void
	{
		graphics.clear();
		graphics.beginFill(color);
		points.forEach(function(p:Point, i:int, a:Array):void {
			if (i == 0) {
				graphics.moveTo(p.x, p.y);
			} else {
				graphics.lineTo(p.x, p.y);
			}
		} );
		graphics.endFill();
		this.rotation = 0;
	}
	
}