/**
 * Copyright stenpel ( http://wonderfl.net/user/stenpel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AgMj
 */

/*
写経本に感謝。
写経本：Flash3Dコンテンツ制作のためのPapervision3D入門（池田 泰延）
*/

package {
    import flash.display.*;
    import flash.events.*;
    import org.papervision3d.core.utils.*;
    import org.papervision3d.view.*;
    	import org.papervision3d.objects.primitives.*;
    	import org.papervision3d.materials.*;    	
    import flash.geom.Rectangle;
    
    public class FlashTest extends BasicView {
    	private var sphere:Sphere;
    	private var material:MovieMaterial;
    	
        public function FlashTest() {
            // write as3 code here..
            super(0, 0, true, true);
            
            // Mouse3Dを使用可能にする
            Mouse3D.enabled = true;
            
            //
            var mc:MovieClip = new MovieClip();
            var rect:Rectangle = new Rectangle(0, 0, 1000, 500);
            material = new MovieMaterial(mc, false, true, false, rect);
            material.interactive = true;
            material.allowAutoResize = false;
            material.smooth = true;
            
            sphere = new Sphere(material, 400, 14, 14);
            scene.addChild(sphere);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            startRendering();
        }
        
        private function onEnterFrame(e:Event):void {
        	if(InteractiveSceneManager.MOUSE_IS_DOWN) {
        		var vx:Number = viewport.interactiveSceneManager.virtualMouse.x;
        		var vy:Number = viewport.interactiveSceneManager.virtualMouse.y;
        		
        		// マテリアルの元になっているムービークリップを参照
        		var mc:MovieClip = MovieClip(material.movie);
        		
        		// ムービークリップに円を描写
        		mc.graphics.beginFill(0xFF0000);
        		mc.graphics.drawCircle(vx, vy, 5);
        	}
        	sphere.rotationY += 1;
        }
    }
}