/**
 * Copyright kazuhiroyamada ( http://wonderfl.net/user/kazuhiroyamada )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AgEZ
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.net.URLRequest;
    import flash.geom.Point;
    import flash.system.LoaderContext;
    
    public class Water extends Sprite {
        private var loaderObj:Loader;
        private var perlinBitmapData:BitmapData;
        private var offsetArray:Array;
        private var speedArray:Array;
        private var dist:int = 3;
        private var oct:int = 1;
        private var disp_filter:DisplacementMapFilter;
        
        public function Water() {
            offsetArray = [];
            speedArray = [];
            loadImage("http://assets.wonderfl.net/images/related_images/9/9f/9fe3/9fe38020b23a7d1934b9f955aa01618707b11933");
        }
        
        private function loadImage(imageName:String):void{
            loaderObj = new Loader();
            var _url:URLRequest = new URLRequest(imageName);
            var loaderContext:LoaderContext = new LoaderContext();
            loaderContext.checkPolicyFile = true;
            loaderObj.load(_url, loaderContext);
            loaderObj.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadedImage);
        }
        
        private function onLoadedImage(e:Event):void{
            loaderObj.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoadedImage);
            addChild(loaderObj);
            setPerlinNoise();
        }
        
        private function setPerlinNoise():void{
            perlinBitmapData = new BitmapData(465, 465);
            initOffsetArray();
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler, false, 0, true);
        }
        
        private function initOffsetArray():void{
            for(var i:int = 0; i < oct; i++){
                offsetArray[i] = new Point(0, 0);
                speedArray[i] = new Array(2);
                speedArray[i][0] = Math.random() * dist;
                speedArray[i][1] = Math.random() * dist;
            }
        }
        
        private function onEnterFrameHandler(e:Event):void{
            for(var i:int = 0; i < oct; i++){
                offsetArray[i].x += speedArray[i][0];
                offsetArray[i].y += speedArray[i][1];
            }
            perlinBitmapData.perlinNoise(150, 150, oct, 1, false, false, 1, false, offsetArray);
            disp_filter = new DisplacementMapFilter(perlinBitmapData, new Point(0, 0), 1, 1, 10, 10, DisplacementMapFilterMode.CLAMP);
            loaderObj.content.filters = [disp_filter];
        }
    }
}