/**
 * Copyright nontsu ( http://wonderfl.net/user/nontsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AfR6
 */

// forked from FlashBum's forked from: Pseudo 3D Push Button Decorator ( now with more animation )
// forked from FlashBum's forked from: forked from: Pseudo 3D Push Button Decorator
// forked from FlashBum's forked from: Pseudo 3D Push Button Decorator
// forked from FlashBum's Pseudo 3D Push Button Decorator
package {

    import caurina.transitions.Tweener;
    
    import flash.display.DisplayObject;
    import flash.display.DisplayObjectContainer;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
 
    /**
      * author Jesse Freeman aka @theFlashBum | http://jessefreeman.com
      * 
      * This is a simple demo of how to create a "3d Push Button" similar
      * to the new UI on wp7 phones. Noting fancy here but I do add the
      * notion of force so depending on where you press the button it will
      * rotate farther.
      * 
       * Since this is a decorator (see internal class) it can be applied
       * to any button (as long as you are compiling for FP 10.0).
      * 
      * It is important to note that the rotation will be "off" based on
      * the center position of the box.
      *
      * v1.0
      * v1.1 - added in build up animation and remove animation.
      *
      */
      
public class ButtonTest extends Sprite {

    private var decorator:PushButtonDecorator = new PushButtonDecorator();
        private var display:Sprite;
        private var rowContainers:Array = [];
        private const REMOVE_ANIMATION:String = "remove";
        private const RESET_ANIMATION:String = "reset";
        
        public function ButtonTest() {

            configureStage();
            init();
        }

        protected function configureStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            transform.perspectiveProjection = new PerspectiveProjection();
            transform.perspectiveProjection.fieldOfView=10;
            transform.perspectiveProjection.projectionCenter=new Point(stage.stageWidth *.5,stage.stageHeight *.5);
        }

        protected function init():void
        {
            createDisplay();

            createButtonGid();
        }

        private function createDisplay():void {
            display = addChild(new Sprite()) as Sprite;
            display.x = 15;
            display.y = 30;
            display.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        private function createButtonGid():void {
            var nextX:Number = 0;
            var nextY:Number = 0;
            var total:Number = 4;
            var padding:Number = 6;
            var maxPerColumn:Number = 2;
            var i:int = 0;
            var tempButton:Sprite;
            var currentRowContainer:Sprite = createRowContainer(display, 0);

            for (i = 0; i < total; i ++)
            {
                tempButton = currentRowContainer.addChild(createButton()) as Sprite;
                tempButton.x = nextX;
                //tempButton.y = nextY;

                nextX += tempButton.width + padding;


                if ((i % maxPerColumn) == 1)
                {
                    nextX = 0;
                    nextY += tempButton.height + padding;

                    currentRowContainer = createRowContainer(display, nextY);
                }

            }

            tempButton = currentRowContainer.addChild(createButton(206, 100)) as Sprite;

            toggleAnimation(RESET_ANIMATION, 0);
        }

        private function createRowContainer(attachToTarget:DisplayObjectContainer, y:Number):Sprite {
            var container:Sprite = attachToTarget.addChild(new Sprite()) as Sprite;
            rowContainers.push(container);
            container.y = y;
            container.alpha = 0;
            container.rotationY = 90;
            return container;
        }
        
        private function onMouseDown(event:MouseEvent):void {

            decorator.target = event.target as DisplayObject;
            display.addChildAt(decorator.target.parent, 0);
            decorator.push(event.localX / decorator.target.width, true);

            toggleAnimation(REMOVE_ANIMATION, .6);
            toggleAnimation(RESET_ANIMATION, 2);
        }

        private function toggleAnimation(type:String, delay:Number = 0):void {

            var rowContainer:Sprite;
            var total:int = rowContainers.length;
            var delayOffset:Number;
            var i:int;
            trace(total);
            for (i = 0; i < total; i ++)
            {
                rowContainer = rowContainers[i];
                delay +=  (i * .1);

                if(type == REMOVE_ANIMATION)
                {
                    Tweener.addTween(rowContainer, {time:.5, rotationY: 85, delay: delay});
                    Tweener.addTween(rowContainer, {time:.1, alpha:0, delay: delay+.2});
                }
                else
                {
                    Tweener.addTween(rowContainer, {time:0, alpha:1, delay: delay});
                    Tweener.addTween(rowContainer, {time:1, rotationY: 0, delay:delay});
                }
            }
        }

        private function createButton(w:Number = 100, h:Number = 100):Sprite {

            var button:Sprite = new Sprite();
            button.graphics.beginFill(Math.random() * 0xFFFFFF);
            button.graphics.drawRect(0, 0, w, h);
            button.graphics.endFill();

            button.buttonMode = true;
            button.useHandCursor = true;

            return button;
        }
    }
}

    import caurina.transitions.*;

    import flash.display.DisplayObject;

    internal class PushButtonDecorator {

        private var _target:DisplayObject;

        public function PushButtonDecorator(target:DisplayObject = null) {
            if(target) _target = target;
        }

        public function get target():DisplayObject {
            return _target;
        }

        public function set target(value:DisplayObject):void {
            _target = value;
        }
        
        public function push(force:Number = 1, autoReset:Boolean = true):void {

            var rotY:Number = -30 * force;
            _target.z = 100 * force;

            Tweener.addTween(_target,{time: .2, rotationX: -10, rotationY: rotY, onComplete: autoReset ? reset : null});

        }

        public function reset(delay:Number = 0):void
        {
            Tweener.addTween(_target,{time: .2, alpha: 1, z:0, rotationX: 0, rotationY: 0, delay:delay});
        }


    }