/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AfR1
 */

package {
    import flash.display.Sprite;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]    
    
    public class FlashTest extends Sprite {
        private var twinkle:TwinkleParticles;
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            var label:Label = new Label(400, 80, 40, Label.CENTER);
            addChild(label);
            label.x = 32;
            label.y = 202;
            label.textColor = 0xffffff;
            label.alpha = 0.3;
            label.text = "Twinkle Particles";
            
            twinkle = new TwinkleParticles();
            addChild(twinkle);
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class TwinkleParticles extends Sprite {
    private var particles:Array;
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var colorTrans:ColorTransform;
    private static var point:Point = new Point();
    private static var blur:BlurFilter;
    private var count:uint = 0;
    private var color:ColorHSV;
    private static var cx:uint = 232;
    private static var cy:uint = 116;
    private static var radius:uint = 100;
    private static var radian:Number = Math.PI/180;
    
    public function TwinkleParticles() {
        particles = new Array();
        if(stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }
    
    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        colorTrans = new ColorTransform(1, 1, 1, 0.8, 0, 0, 0, 0);
        blur = new BlurFilter(16, 16, 3);
        color = new ColorHSV(0, 0.5);
        addEventListener(Event.ENTER_FRAME, create, false, 0, true);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    
    private function create(evt:Event):void {
        count += 8;
        color.h = count;
        var particle:Particle = new Particle(color.value);
        particle.x = cx - radius *((1 + 2 * Math.cos(count*radian))*Math.sin(count*radian));
        particle.y = cy - radius *((1 + 2 * Math.cos(count*radian))*Math.cos(count*radian));
        container.addChild(particle);
        particles.push(particle);
    }
    private function update(evt:Event):void {
        for(var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.update();
            if(particle.life < 0 || particle.y > stage.stageHeight + 50) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        draw();
    }
    private function draw():void {
        bitmapData.lock();
        bitmapData.draw(container, null, colorTrans);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
    }
}

import flash.display.Sprite;
import flash.filters.GlowFilter;

class Particle extends Sprite {
    private var glow:GlowFilter;
    private var _width:uint = 12;
    private var _height:uint = 18;
    private var blur:uint = 8;
    private static var color:uint = 0xffffff;
    private static var max:uint = 50;
    public var life:int = max;
    private static var radius:Number = 0.6;
    private var dx:Number = 0;
    private var gravity:Number = -2;
    private static var acceleration:Number = 0.1;
    
    public function Particle(rgb:uint=0xffffff, w:uint = 12, h:uint=18, b:uint=8)
    {
        _width = w;
        _height = h;
        blur = b;
        glow = new GlowFilter(rgb, 1, blur, blur, 2, 3, false, false);
        draw();
        init();
    }
    
    private function init():void {
        dx = Math.random()*radius*2 - radius;
    }
    
    public function update():void {
        if(life < 0) return;
        life--;
        x += dx;
        gravity += acceleration;
        y += gravity;
        alpha = (life/max < 0.5) ? life * 2/max : 1;
        blink();
    }
    private function blink():void {
        if(life%4 == 0) {
            visible = false;
        } else {
            visible = true;
        }
    }
    private function draw():void {
        graphics.beginFill(color);
        graphics.moveTo(0, -height/2);
        graphics.curveTo(0, 0, -_width/2, 0);
        graphics.curveTo(0, 0, 0, _height/2);
        graphics.curveTo(0, 0, _width/2, 0);
        graphics.curveTo(0, 0, 0, -_height/2);
        graphics.endFill();
        filters = [glow];
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;
    
    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }
    
    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:String):void {
        txt.textColor = param;
    }
}

