/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AeIo
 */

// forked from yonatan's forked from: Plasmountains
// forked from yonatan's Plasmountains
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import net.hires.debug.Stats;
	import flash.net.*;
	import flash.system.*;

    [SWF(width=465,height=465,frameRate=30,backgroundColor=0x88aaff)]
    public class EnvThingy extends Sprite {
        private static const SIZE:int = 0x80;
        private static const W:int = SIZE;
        private static const H:int = SIZE;
        private static const OCTAVES:int = 5;

        private var heightMap:BitmapData = new BitmapData(W, H, false);
        private var loader:Loader;
		private var imageBmd:BitmapData = new BitmapData(W, H, false);
		private var canvas:BitmapData = new BitmapData(W, H, false);

        private var stats:Sprite = new Sprite;

        public function EnvThingy() {
			loader = new Loader;
			loader.contentLoaderInfo.addEventListener (Event.COMPLETE, init);
			loader.addEventListener(Event.COMPLETE, init);
			loader.load(
				// new URLRequest("http://farm4.static.flickr.com/3306/3579595198_bebb3fd5e7.jpg"), 
				// new URLRequest("http://farm4.static.flickr.com/3032/2985065777_21ab94337d.jpg"), 
				new URLRequest("http://farm3.static.flickr.com/2249/2197367316_077c7c93c7.jpg"), 
				new LoaderContext(true));
		}
			
		public function init(e:Event):void {
			var bmp:Bitmap = e.target.content;
			bmp.width = W;
			bmp.height = H;
			imageBmd.draw(bmp, bmp.transform.matrix);

			bmp = new Bitmap(canvas);
			bmp.width = bmp.height = 465;
			addChild(bmp);

            stats.addChild(new Bitmap(heightMap));
            stats.addChild(new Stats()).x=400;
            addChild(stats).visible = false;

            addEventListener("enterFrame", loop);
            stage.addEventListener("click", function(e:*):void { stats.visible = !stats.visible; });
        }

        private function loop(e:*):void {
            var offsets:Array = [];
            var offset:Number = -getTimer()/100;

            for(var i:uint = 0; i < OCTAVES; i++) {
                offsets.push(new Point(offset/(i+2), offset/(i+1)));
            }
            
            heightMap.perlinNoise(W, H, OCTAVES, 16, false, true,
                BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE, true,
                offsets);

			canvas.lock();
			function v(x:int, y:int):Vector3D {
				x=(x+W)%W;
				y=(y+H)%H;
				return(new Vector3D(x, (heightMap.getPixel((x+W)%W, (y+H)%H) & 0xFF), y));
			}

			for(var y:int=0; y < H; y++) {
				for(var x:int=0; x < W; x++) {
					var hn:Vector3D = v(x?x-1:x, y).subtract(v(x+1<W?x+1:x, y));
					var vn:Vector3D = v(x, y?y-1:y).subtract(v(x, y+1<H?y+1:y));
					var n:Vector3D = vn.crossProduct(hn);

					n.normalize();
					var tx:Number = Math.floor((Math.atan2(n.y,n.z)/Math.PI+1)/2 * W);
					var ty:Number = Math.floor((Math.atan2(n.x,n.z)/Math.PI+1)/2 * H);
					canvas.setPixel(x, y, imageBmd.getPixel(tx, ty));
				}
			}
			canvas.unlock();
        }
    }
}