/**
 * Copyright 16pavel ( http://wonderfl.net/user/16pavel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AeAg
 */

package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.ui.Keyboard;
 
    [SWF(backgroundColor=0x000000, width="800", height="600")]
    public class Ex09_Filters extends Sprite
    {
        private var sp_blur:Sprite = new Sprite();
        private var sp_glow:Sprite = new Sprite();
        private var sp_blend:Sprite = new Sprite();
 
        public function Ex09_Filters()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
 
            DrawCircle(sp_blur, 100, 100, 50, 0xFF0000);
            //addChild(sp_blur);
 
            DrawCircle(sp_glow, 200, 100, 50, 0x00FF00);
 
            DrawCircle(sp_blend, 150, 100, 50, 0x0000FF);
 
            addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
            addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
 
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
 
        private function DrawCircle(sp:Sprite, x:int, y:int, rad:int, color:uint):void
        {
            sp.graphics.beginFill(color);
            sp.graphics.drawCircle(x, y, rad);
            sp.graphics.endFill();
 
            addChild(sp);
        }
 
        private function onMouseOver(e:MouseEvent):void{
            if(e.target == sp_blur){
                sp_blur.filters = [new BlurFilter(5, 5, 1)];
            }
            else if(e.target == sp_glow){
                sp_glow.filters = [new GlowFilter(0xFFFFFF, 1.0, 10, 10)];
            }
            else if(e.target == sp_blend){
                sp_blend.blendMode = BlendMode.ADD;
            }
        }
 
        private function onMouseOut(e:MouseEvent):void
        {
            sp_blur.filters = [];
            sp_glow.filters = [];
            sp_blend.blendMode = BlendMode.NORMAL;
        }
 
        private function onMouseDown(e:MouseEvent):void
        {
            if(e.target == sp_blur){
                sp_blur.startDrag();
            }
            else if(e.target == sp_glow){
                sp_glow.startDrag();
            }
            else if(e.target == sp_blend){
                sp_blend.startDrag();
            }
        }
 
        private function onMouseUp(e:MouseEvent):void
        {
            if(e.target == sp_blur){
                sp_blur.stopDrag();
            }
            else if(e.target == sp_glow){
                sp_glow.stopDrag();
            }
            else if(e.target == sp_blend){
                sp_blend.stopDrag();
            }
        }
 
        private function onKeyDown(e:KeyboardEvent):void
        {
            if(e.keyCode == Keyboard.B){
                sp_blur.x = 0;
                sp_blur.y = 0;
                sp_glow.x = 0;
                sp_glow.y = 0;
                sp_blend.x = 0;
                sp_blend.y = 0;
 
                //trace("press down!");
            }
        }
    }
}