/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ad8W
 */

// Game of Life shader
// http://johnblackburne.blogspot.co.uk/2012/03/game-of-life-shader.html
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.ShaderFilter;
    import flash.geom.*;
    import mx.utils.*;

    public class Life extends Sprite {

        public static const asShader:Vector.<String> = Vector.<String>([
	"pQEAAACkBABMaWZloAxuYW1lc3BhY2UAAKAMdmVuZG9yAEpXQiBTb2Z0d2FyZQCg",
	"CHZlcnNpb24AAgCgDGRlc2NyaXB0aW9uAENvbndheSdzIGdhbWUgb2YgbGlmZQCh",
	"AQIAAAxfT3V0Q29vcmQAowAEc3JjAKECBAEAD2RzdAAyAAAgAAAAADICAIC/gAAA",
	"MgIAQL+AAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIC/gAAA",
	"MgIAQAAAAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIC/gAAA",
	"MgIAQD+AAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIAAAAAA",
	"MgIAQL+AAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIAAAAAA",
	"MgIAQD+AAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIA/gAAA",
	"MgIAQL+AAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIA/gAAA",
	"MgIAQAAAAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADICAIA/gAAA",
	"MgIAQD+AAAAdAgAxAAAQAAECADECABAAMAMA8QIAsAABAAAgAwAAADIAABBAQAAA",
	"HQIAgAAAgAACAgCAAADAABgAABACAAAAMgIAgD8AAAAqAAAQAgAAAB0BgIAAgAAA",
	"MgAAED+AAAAyAgCAAAAAADMCAEABgAAAAADAAAIAAAAdAAAQAgBAADICAIBAIAAA",
	"HQIAQAAAgAACAgBAAgAAABgCAIACAEAAMgIAQD+AAAAqAgCAAgBAAB0BgIAAgAAA",
	"MgIAgD+AAAAyAgBAAAAAADMCACABgAAAAgAAAAIAQAAdAgCAAgCAADADAPEAABAA",
	"MgIAQD8AAAAqAgBAAwAAAB0BgIAAgAAAMwIAQAGAAAACAAAAAADAAB0CACACAEAA",
	"HQMAgAIAgAAdAwBAAgCAAB0DACACAIAAMgIAQD+AAAAdAwAQAgBAAB0BAPMDABsA"])

        public var filter:ShaderFilter, shader:Shader;
        public var fX:Number, fY:Number, fZ:Number;
        public var iMode:int;
        public var dat:BitmapData, pt:Point = new Point(0, 0);
        
        
        function Life() {
            Make();
        }
        
        public function Make():void {
			dat = new BitmapData(stage.stageWidth,stage.stageHeight);
			addChild(new Bitmap(dat));
        	
        	var vec:Vector.<uint> = dat.getVector(dat.rect);
        	for (var i:int = vec.length - 1; i >= 0; i--) {
        		vec[i] = Math.random() > 0.5 ? 0xffffffff : 0xff000000;
        	}
        	dat.setVector(dat.rect, vec);
        	
            var dec:Base64Decoder = new Base64Decoder;
            dec.decode(asShader.join(""));
            filter = new ShaderFilter(shader = new Shader(dec.drain()));
            stage.addEventListener(Event.ENTER_FRAME, Tick);
        }
        
        public function Tick(ev:Event):void {
        	dat.applyFilter(dat, dat.rect, pt, filter);
        }
    }
}

/*
<languageVersion: 1.0;>

// Life:
kernel Life
<   namespace : "";
    vendor : "JWB Software";
    version : 2;
    description : "Conway's game of life"; >
{
    input image4 src;
    output float4 dst;
    
    // evaluatePixel(): The function of the filter that actually does the 
    //                  processing of the image.  This function is called once 
    //                  for each pixel of the output image.
    void
    evaluatePixel()
    {
        float neighbours = 0.0;      
        
        neighbours += sampleNearest(src, outCoord() + float2(-1.0, -1.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(-1.0, 0.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(-1.0, 1.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(0.0, -1.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(0.0, 1.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(1.0, -1.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(1.0, 0.0)).r;
        neighbours += sampleNearest(src, outCoord() + float2(1.0, 1.0)).r;

        float deadTo = abs(neighbours - 3.0) < 0.5 ? 1.0 : 0.0;
        float liveTo = abs(neighbours - 2.5) < 1.0 ? 1.0 : 0.0;
        float goesTo = sampleNearest(src, outCoord()).r > 0.5 ? liveTo : deadTo;

        dst = float4(goesTo, goesTo, goesTo, 1.0);
    }
}
*/