/**
 * Copyright Nos_lkSsvOhB ( http://wonderfl.net/user/Nos_lkSsvOhB )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Ad3K
 */

package {
    import flash.text.TextField;
    import flash.display.*;
    import flash.events.Event;
    public class Oscillator extends Sprite {
        private var m1:Number=1;
        private var m2:Number=1;
        private var k:Number=5000;
        private var nl:Number=100;
        private var dt:Number=0.001;
        
        private var x1:Array=new Array();
        private var x2:Array=new Array();
        private var y1:Array=new Array();
        private var y2:Array=new Array();
         
        private var r1:Number=20;
        private var r2:Number=20;
        //バネ描画用変数
        private var w:Number=nl;    //width
        private var h:Number=20;    //height
        private var n:Number=5;    //分割数
        private var s:Number=20;    //span
        private var p:Number=(w-2*s)/n;    //pitch
        private var i:Number=10;
        private var sig:Number;
        private var lx:Number;
        private var ly:Number;
        private var bx1:Number;
        private var bx2:Number;
        private var by1:Number;
        private var by2:Number;
        
        private var b1:Sprite;
        private var b2:Sprite;
        private var sp:Sprite;
        public function Oscillator() {
            sp=new Sprite();
            sp.graphics.lineStyle(5, 0x000000, 1, false, LineScaleMode.NONE);
            sp.graphics.moveTo(-w/2,0);
            sp.graphics.lineTo(-w/2+s,0);
            sp.graphics.lineTo(-w/2+s+p/4,-h/2);
            for(i=1, sig=1;i<2*n;i++,sig*=-1){
              sp.graphics.lineTo(-w/2+s+p/4+i*p/2,sig*h/2);
            }
            i--;
            sp.graphics.lineTo(-w/2+s+p/4+i*p/2+p/4,0);
            sp.graphics.lineTo(-w/2+s+p/4+i*p/2+p/4+s,0);
            addChild(sp);
            sp.x=200;
            sp.y=200;
            
            b1=new Sprite();
            b1.graphics.beginFill(0x7F1A1A);
            b1.graphics.drawCircle(0,0,r1);
            b1.graphics.endFill();
            b1.x=-100;
            b1.y=-100;
            addChild(b1);
            
            b2=new Sprite();
            b2.graphics.beginFill(0x123456);
            b2.graphics.drawCircle(0,0,r2);
            b2.graphics.endFill();
            b2.x=-100;
            b2.y=-100;
            addChild(b2);
            
            x1[0]=mouseX;
            x1[1]=mouseX;
            x2[0]=mouseX+nl;
            x2[1]=mouseX+nl;
            y1[0]=mouseY;
            y1[1]=mouseY;
            y2[0]=mouseY;
            y2[1]=mouseY;
            
            addEventListener(Event.ENTER_FRAME,onEnter);
        }
        private function onEnter(event:Event):void {
            lx=nl*Math.cos(Math.atan2(b2.y-b1.y, b2.x-b1.x));
            ly=nl*Math.sin(Math.atan2(b2.y-b1.y, b2.x-b1.x));
            bx1=2*x1[1]-x1[0]+k*(x2[1]-x1[1]-lx)*Math.pow(dt,2)/m1;
            bx2=2*x2[1]-x2[0]-k*(x2[1]-x1[1]-lx)*Math.pow(dt,2)/m2;
        
            by1=2*y1[1]-y1[0]+k*(y2[1]-y1[1]-ly)*Math.pow(dt,2)/m1;
            by2=2*y2[1]-y2[0]-k*(y2[1]-y1[1]-ly)*Math.pow(dt,2)/m2;
        
            b1.x=bx1;
            b1.y=by1;
            b2.x=bx2;
            b2.y=by2;
            sp.x=(b1.x+b2.x)/2;
            sp.y=(b1.y+b2.y)/2;
            sp.scaleX=Math.sqrt(Math.pow(b2.x-b1.x,2)+Math.pow(b2.y-b1.y,2))/nl;
            sp.rotation=180/Math.PI*Math.atan2(b2.y-b1.y, b2.x-b1.x);
        
            x1[0]=x1[1];
            x1[1]=mouseX;
            x2[0]=x2[1];
            x2[1]=bx2;
        
            y1[0]=y1[1];
            y1[1]=mouseY;
            y2[0]=y2[1];
            y2[1]=by2;
    
        }


    }
}