/**
 * Copyright afs ( http://wonderfl.net/user/afs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Acuz
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        public var scrollArea:Box;
        public var scrollBar:Box;
        public var scrollBarshadow:Box;
        public var sb:SquareBoard;
        public var element:Box;
        public var elementArea:Sprite;
        public var elements:Array;
        
        public var bardist:Number;
        public var elementAreaDist:Number;
        public var targetDist:Number;
        public var ElementAreaLength:Number;
        public var scrollBarPoint:Number;
    
        public function FlashTest() {
            init();
        }

        public function init():void{
             //scrollArea = new Box(0,0,438,463,1,0xeeeeee);
             scrollArea = new Box(0,0,438,463,1,0xeeeeee);
             addChild(scrollArea);
             
             scrollBarshadow = new Box(0, 0, 15, scrollArea.height , 1 , 0xCCCCCC);
             scrollBar = new Box(0, 0, 15, 100, 1, 0x000000);
             scrollBarshadow.x = scrollBar.x = scrollArea.x + scrollArea.width + 10;
             scrollBarshadow.y = scrollArea.y;
             scrollBar.y = scrollArea.y + scrollArea.height - scrollBar.height;
             addChild(scrollBarshadow);
             addChild(scrollBar);
             
             bardist = scrollArea.height - scrollBar.height;

             elements = [];
             elementArea = new Sprite();
             elementArea.x = scrollArea.x;
             
             addChild(elementArea);

                 sb = new SquareBoard();
                 elements.push(sb);
                 sb.x = 0;
                 sb.y = 0;
                 elementArea.addChild(sb);


                
                
             elementAreaDist = elementArea.height - scrollArea.height + 10;
            
             elementArea.y -= elementArea.height - scrollArea.height; 
             elementArea.mask = scrollArea;
             
             addEventListener(Event.ENTER_FRAME, xinitMoveScroll);
             
        }
        
        public function xinitMoveScroll(e:Event):void{
            var vy:Number = (scrollArea.y - scrollBar.y) / 10; 
            var vy2:Number= ((scrollArea.y) - elementArea.y) /10;
            scrollBar.y += vy;
            elementArea.y += vy2;
            
            if((scrollBar.y-scrollArea.y) < 0.1 && (elementArea.y - scrollArea.y) < 0){
                scrollBar.y = scrollArea.y;
                elementArea.y = scrollArea.y;
                removeEventListener(Event.ENTER_FRAME, xinitMoveScroll);
                scrollBar.addEventListener(MouseEvent.MOUSE_DOWN, _scrollbarHandler);
                stage.addEventListener(MouseEvent.MOUSE_UP, _scrollbarUpHandler);
            }
        }
        
        public function _scrollbarHandler(e:MouseEvent):void{
            scrollBarPoint = scrollBar.height - (scrollBar.y + scrollBar.height - mouseY);
            addEventListener(Event.ENTER_FRAME, _onScrollArea );
        }
        public function _scrollbarUpHandler(e:MouseEvent):void{
            removeEventListener(Event.ENTER_FRAME, _onScrollArea );
        }
         
        public function _onScrollArea(e:Event = null):void{
            scrollBar.y = mouseY - scrollBarPoint;
            if(scrollBar.y + scrollBar.height  > scrollArea.y + scrollArea.height) {
                scrollBar.y = scrollArea.y + scrollArea.height - scrollBar.height;
            }
            if(scrollBar.y < scrollArea.y ) {
                scrollBar.y = scrollArea.y;    
            }
            targetDist = scrollArea.y - (elementAreaDist * ((scrollBar.y - scrollArea.y)/bardist)); 
            //elementArea.y += (targetDist - elementArea.y) * 0.2; //animation
            elementArea.y += (targetDist - elementArea.y); 
        }
    }
}
import flash.utils.Proxy;
import flash.geom.Point;

import flash.display.AVM1Movie;
import flash.text.TextField;
import flash.text.engine.TextBlock;

import flash.display.Sprite;
class Box extends Sprite {
    public function Box(x:Number,y:Number,width:Number = 20,height:Number = 20,line:Number = 1,color:uint = 0xFF0000):void{
        with(this.graphics) {
            beginFill(color);
            lineStyle(line);
            drawRect(x,y,width,height);
            endFill();
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.events.MouseEvent;

class SquareBoard extends Sprite {
    public var squareBoards:Array = [
        [
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0],
            [0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0],
            [0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0],
            [0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0],
            [0,0,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0],
            [0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,0,0],
            [0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,1,1,1,1,0,0,0],
            [0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0],
            [1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0],
            [1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0],
            [0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0],
            [0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0],
            [0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
        ],[
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0], 
            [0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0], 
            [0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0], 
            [0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0], 
            [0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
        ],[
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0], 
            [0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0], 
            [0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0], 
            [0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0], 
            [0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0], 
            [0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0], 
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
        ]
    ];

    public function SquareBoard():void {
        var i:int;
        var x:int;
        var y:int;
        for(i = 0; i < squareBoards.length; i++) {
            var bd:Board = new Board(i);
            bd.board = squareBoards[i];
            bd.squares = [];
            var txt:TextField = new TextField();
            txt.background = true;
            txt.backgroundColor = 0xcccccc;
            txt.width = 400;
            txt.height = 28;
            txt.text = "Grid Number " + String(i+1);
            bd.txt = txt;
            this.addChild(bd);
            bd.y = (i * (418 + 40)) + 40;
            this.addChild(txt);
            txt.y = bd.y - 30;
            for(y = 0; y < squareBoards[i].length; y++){
                bd.squares[y] = [];
                for(x = 0; x < squareBoards[i][y].length; x++){
                    var state:Boolean = Boolean(squareBoards[i][y][x]);
                    var sq:Square = new Square(state, x, y);
                    bd.squares[y][x] = sq;
                    sq.x = x * 19;
                    sq.y = y * 19;
                    bd.addChild(sq);
                }
            }
            var cc:ClickController = new ClickController(txt, bd.squares, bd.board);
            bd.addChild(cc);
        }
    }
}

import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.GradientType;
import flash.geom.Matrix;

class Board extends Sprite {
    public var board:Array;
    public var squares:Array;
    public var txt:TextField;
    public function Board(i:int):void {
        var g:Graphics = this.graphics;
        g.beginFill(0x3399ff);
        g.lineStyle(1, 0x000000);
        g.drawRect(0, 0, 418, 418);
        g.endFill();
    }
}

import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.GradientType;
import flash.geom.Matrix;

class Square extends Sprite {
    //public var x_s:int;
    //public var y_s:int;
    public var state_s:Boolean;
    public var g:Graphics;

    public function Square(state:Boolean, x:int, y:int):void {
        state_s = state;
        //x_s = x;
        //y_s = y;
        g = this.graphics;
        update();
    }

    public function update():void {
        var color:int = state_s ? 0xffffff : 0x000000;
        var alpha:int = state_s ? 1 : 0;
        g.clear();
        g.beginFill(color, alpha);
        g.lineStyle(1, 0x000000);
        g.drawRect(0, 0, 19, 19);
        g.endFill();
    }
}

class ClickController extends Sprite {
    public var x_s:int;
    public var y_s:int;
    public var txt_s:TextField;
    public var g:Graphics;
    public var counter:int;
    public var squares_s:Array;
    public var board_s:Array

    public function ClickController(txt:TextField, squares:Array, board:Array):void {
        txt_s = txt;
        squares_s = squares;
        board_s = board;
        g = this.graphics;
        g.clear();
        g.beginFill(0x000000, 0);
        g.lineStyle(1, 0x000000, 0);
        g.drawRect(0, 0, 418, 418);
        g.endFill();
        this.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
            //var scrollY:Number = squares_s[0][0].parent.parent.parent.parent.elementArea.y;
            //var p:Point = new Point(this.x, this.y);
            //var pg:Point = this.localToGlobal(p);
            var x:int = int(stage.mouseX / 19);
            var y:int = int((stage.mouseY - 40) / 19);
            //txt_s.text = pg.x + " " + pg.y;
            //txt_s.text = squares_s[0][0].parent.y + "";
            //txt_s.text = stage.mouseX + " -> " + x + " | " + (stage.mouseY - 40) + " -> " + y;
            squares_s[y][x].state_s = !squares_s[y][x].state_s;
            board_s[y][x] = int(squares_s[y][x].state_s);
            squares_s[y][x].update();
            //txt_s.text = String(board_s[y][x]);
        });
    }
}