/**
 * Copyright fujiopera ( http://wonderfl.net/user/fujiopera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Acoq
 */

package {
    import flash.display.Sprite;
    import flash.system.Capabilities;
    
    import flashx.textLayout.container.ContainerController;
    import flashx.textLayout.conversion.TextConverter;
    import flashx.textLayout.elements.TextFlow;
    import flashx.textLayout.formats.BlockProgression;
    import flashx.textLayout.formats.JustificationRule;
    import flashx.textLayout.formats.TextLayoutFormat;
    import flashx.textLayout.formats.VerticalAlign;
    
    public class TextLayoutFormatExample2 extends Sprite
    {
        public function TextLayoutFormatExample2()
        {
            // create TextFlow object
            var textFlow:TextFlow = new TextFlow();   
            // create TextLayoutFormat object
            var textLayoutFormat:TextLayoutFormat = new TextLayoutFormat();
            // define Japanese text in a string of Unicode characters
            var jaText:String = String.fromCharCode(
                0x30AF, 0x30ED, 0x30B9, 0x30D7, 0x30E9, 0x30C3, 0x30C8, 0x30D5, 
                0x30A9, 0x30FC, 0x30E0, 0x4E0A, 0x3067, 0x518D, 0x751F, 0x53EF, 
                0x80FD, 0x306A
            ) + 
            "Flash Video" +
            String.fromCharCode(
                0x3092, 0x914D, 0x4FE1, 0x3001, 0x653F, 0x5E9C, 0x6700, 0x65B0, 
                0x60C5, 0x5831, 0x3092, 0x3088, 0x308A, 0x591A, 0x304F, 0x306E, 
                0x56FD, 0x6C11, 0x306B, 0x9AD8, 0x54C1, 0x8CEA, 0x306A, 0x753B, 
                0x50CF, 0x3067, 0x7C21, 0x5358, 0x304B, 0x3064, 0x30EA, 0x30A2, 
                0x30EB, 0x30BF, 0x30A4, 0x30E0, 0x306B, 0x63D0, 0x4F9B, 0x3059, 
                0x308B, 0x3053, 0x3068, 0x304C, 0x53EF, 0x80FD, 0x306B, 0x306A, 
                0x308A, 0x307e, 0x3057, 0x305F, 0x3002);
            // convert the text into a TextFlow object
            textFlow = TextConverter.importToFlow(jaText, TextConverter.PLAIN_TEXT_FORMAT);
            // set the locale and fontFamily
            textLayoutFormat.locale = "ja";
            if (Capabilities.os.search("Mac OS") > -1) 
                textLayoutFormat.fontFamily = String.fromCharCode(0x5C0F, 0x585A, 0x660E, 0x671D) + " Pro R"; // "Kozuka Mincho Pro R"                    koFont.fontName = "Adobe " + String.fromCharCode(0xBA85, 0xC870) + " Std M"; // "Adobe Myungjo Std M"
            else 
                textLayoutFormat.fontFamily = "Kozuka Mincho Pro R";
            // specify right-to-left block progression, east Asian justification, and top vertical alignment
            textLayoutFormat.blockProgression = BlockProgression.RL;
            textLayoutFormat.justificationRule = JustificationRule.EAST_ASIAN;
            textLayoutFormat.verticalAlign = VerticalAlign.TOP;
            textFlow.hostFormat = textLayoutFormat;
            // add controller and update to display text
            textFlow.flowComposer.addController(new ContainerController(this, 300, 200));
            textFlow.flowComposer.updateAllControllers();
        }
    }
}