/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/AcKM
 */

// BSD License http://modestmaps.com/license.txt
// see http://modestmaps.com/
package
{
	import com.modestmaps.core.MapExtent;
	import com.modestmaps.events.MapEvent;
	import com.modestmaps.extras.MapControls;
	import com.modestmaps.extras.MapCopyright;
	import com.modestmaps.extras.ZoomSlider;
	import com.modestmaps.Map;
	import com.modestmaps.TweenMap;
	import flash.display.DisplayObject;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import flash.system.Security;
	import com.modestmaps.mapproviders.OpenStreetMapProvider;

	[SWF(width="480", height="480", backgroundColor="0x000000", frameRate="60")];
	public class OsmMap4 extends Sprite {
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var viewport:Viewport3D;
		private var render:BasicRenderEngine;
		private var rootNode:DisplayObject3D;	
		private var map:Map;
		private var obj:Sphere;
		private var id:int;
		private var rot:Boolean = true;
		private var button:MapButton;
		
		public function OsmMap4() {
			Security.loadPolicyFile("http://tile.openstreetmap.org/crossdomain.xml");	
			scene = new Scene3D();
			viewport = new Viewport3D(0, 0, true, false);
			rootNode = new DisplayObject3D();
			scene.addChild(rootNode);
			camera = new Camera3D();
			camera.z = -300;
			camera.focus = 500;
			camera.zoom = 1;
			render = new BasicRenderEngine();
			map = new TweenMap(520, 400, true, new OpenStreetMapProvider(), null);
			var mc:MovieClip = new MovieClip();
			mc.addChild(map);
			addChild(mc);
			var mx:MovieClip = new MovieClip();
			mx.graphics.beginFill(0x000000);
			mx.graphics.drawRect(0, 0, 480, 480);
			mx.graphics.endFill();
			addChild(mx);
			addChild(viewport);	
			var material:MovieMaterial = new MovieMaterial(mc, false, true, false, new Rectangle(0, 0, 520, 400));
			obj = new Sphere(material, 100, 24,24);
			obj.x = 20, obj.y = 0, obj.z = 0;
			rootNode.addChild(obj);
			this.addChild(new MapControls(map));
			this.addChild(new ZoomSlider(map));
			addEventListener(Event.ENTER_FRAME, update);
			button = new MapButton("Stop    ");
			button.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
				rot = !rot;
				if (rot) {
					button.setLabel("Stop   ");
				}else {
					button.setLabel("Rotate");
				}
			} );
			button.x = 15, button.y = 390;
			addChild(button);
			var part:Particles = new Particles("stardust");
			scene.addChild(part);
			var pm:ParticleMaterial = new ParticleMaterial(0xffdd00, 1);
			for (var i:int = 0; i < 400; i++) {
				var pc:Particle = new Particle(pm, 3 * Math.random(), 600 * Math.random() - 300, 600 * Math.random() - 300, 500 * Math.random() + 100);
				part.addParticle(pc);
			}
		}
		
		private function update(e:Event):void {
			if (rot) obj.rotationY -= .5;
			render.renderScene(scene, camera, viewport);
		}
	}
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.geom.ColorTransform;
import flash.system.Security;
import flash.text.TextField;
import flash.text.TextFormat;

class MapButton extends Sprite {
	private var label:TextField;
	private var overTransform:ColorTransform = new ColorTransform(1,1,1);
	private var outTransform:ColorTransform = new ColorTransform(1,.9,.6);
	private var normalFormat:TextFormat = new TextFormat( 'Verdana', 10, 0x000000, false);
	private var selectedFormat:TextFormat = new TextFormat( 'Verdana', 10, 0x000000, true);
	private var _selected:Boolean = false;
	public function MapButton(label_text:String) {
		useHandCursor = true;
		mouseChildren = false;
		buttonMode = true;
		addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
		addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
		filters = [ new DropShadowFilter(1,45,0,1,3,3,.7,2) ];
		transform.colorTransform = outTransform;
		label = new TextField();
		label.selectable = false;
		label.defaultTextFormat = normalFormat;
		label.text = label_text;
		label.width = label.textWidth + 8;
		label.height = 18;
		label.x = label.y=1;
		addChild( label );
		graphics.clear();
		graphics.beginFill(0xdddddd);
		graphics.drawRoundRect(0, 0, 102, 18, 9, 9);
		graphics.beginFill(0xffffff);
		graphics.drawRoundRect(0, 0, 100, 16, 9, 9);
		graphics.beginFill(0xbbbbbb);
		graphics.drawRoundRect(2, 2, 100, 16, 9, 9);
		graphics.beginFill(0xdddddd);
		graphics.drawRoundRect(1, 1, 100, 16, 9, 9);
	}
	public function onMouseOver(event:MouseEvent = null):void{
		transform.colorTransform = overTransform;
	}
	public function onMouseOut(event:MouseEvent = null):void{
		transform.colorTransform = outTransform;
	}
	public function setLabel(s:String):void {
		label.text = s;
	}
}