/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Abch
 */

package {
  import flash.display.*;
  import flash.geom.Rectangle;
  import flash.text.engine.LigatureLevel;
  import flashx.textLayout.elements.*;
  import flashx.textLayout.factory.TextFlowTextLineFactory;
  import flashx.textLayout.formats.TextLayoutFormat;

  public class ch18ex2 extends Sprite {
    public function ch18ex2() {
      //create the content models TextFlow > Paragraph > Span > text
      var content:TextFlow = new TextFlow();
      var p:ParagraphElement = new ParagraphElement();
      var span:SpanElement = new SpanElement();
      content.addChild(p);
      p.addChild(span);
      
      span.text = "Some say the world will end in fire,\n\
Some say in ice.\n\
From what I've tasted of desire\n\
I hold with those who favour fire.\n\
But if it had to perish twice,\n\
I think I know enough of hate\n\
To say that for destruction ice\n\
Is also great\n\
And would suffice.\n\n\
\u2014Robert Frost"; //unicode for em dash used in this line.
      
      //create the format model. use ligatures and leading
      var format:TextLayoutFormat = new TextLayoutFormat();
      format.fontFamily = "Caslon, Garamond, _serif";
      format.ligatureLevel = LigatureLevel.COMMON;
      format.fontSize = 17;
      format.lineHeight = 28;
      format.color = 0x303030;
      content.format = format;

      //create a factory, set its bounds, and let it generate lines
      var controller:TextFlowTextLineFactory = new TextFlowTextLineFactory();
      var fullW:Number = stage.stageWidth;
      var fullH:Number = stage.stageHeight;
      controller.compositionBounds = new Rectangle(fullW/4, 20, fullW/2, fullH);
      controller.createTextLines(onLineCreated, content);
    }
    //called by the TextFlowTextLineFactory every time a line is created
    private function onLineCreated(line:DisplayObject):void {
      //it's still our job to add these to the display list
      addChild(line);
    }
  }
}