/**
 * Copyright nausicaa ( http://wonderfl.net/user/nausicaa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AapV
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.CurveModifiers;
    import frocessing.color.ColorHSV;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]
    public class FlashTest extends Sprite {
    		private var _isMouseDown:Boolean = false;
    		private var _hsv:ColorHSV;
    	
        public function FlashTest() {
            // CurveModifiersを有効化
            CurveModifiers.init();
            
            // ColorHSVを色相0で作成
            _hsv = new ColorHSV(0, 1, 1, 1);
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
        }
        
        private function enterFrameHandler(e:Event):void{
        		// 色を更新
        		_hsv.h = ++_hsv.h % 360;
        		
        		//　マウスダウンされていなければ処理しない
        		if(!_isMouseDown) return;
        		
        		// マウスの位置にballを作成
        		var ball:Sprite = new Sprite();
        		ball.x = mouseX;
        		ball.y = mouseY;
        		ball.alpha = .3;
        		ball.graphics.beginFill(_hsv.value);
        		ball.graphics.drawCircle(0, 0, 20);
        		ball.graphics.endFill();
        		
        		addChild(ball);
        		
        		// 終了位置とコントロールポイント
        		var endX:Number = Math.random()*stage.stageWidth;
        		var ctlX:Number = mouseX + (endX - mouseX) / 2;
        		
        		Tweener.addTween(ball, {
        			x:endX,
        			y:stage.stageHeight,
        			_bezier:[{x:ctlX, y:0}],
        			time:1,
        			transition:"linear",
        			onComplete:onTweenComplete,
        			onCompleteParams:[ball]
        		});
        }
        private function onTweenComplete(ball:Sprite):void{
        		removeChild(ball);
        }
        private function mouseDownHandler(e:MouseEvent):void{
        		_isMouseDown = true;
        }
        private function mouseUpHandler(e:MouseEvent):void{
        		_isMouseDown = false;
        }
    }
}