/**
 * Copyright aqaqaqaqaiko ( http://wonderfl.net/user/aqaqaqaqaiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Aakh
 */

// forked from ProjectNya's スライドショー (1)
////////////////////////////////////////////////////////////////////////////////
// スライドショー (1)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.Dictionary;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        //メソッド
        private var prevBtn:Btn;
        private var nextBtn:Btn;
        private var provider:URLLoader;
        private static var dataPath:String = "t89829.xml";
        private var max:uint;
        private var thumbPaths:Array;
        private var photoPaths:Array;
        private var thumbs:Array;
        private var photos:Array;
        private var _loaders:Dictionary;
        private var loaders:Dictionary;
        private var loaded:uint = 0;
        private var plate:Sprite;
        private var container:Sprite;
        private var currentId:int = 0;
        private var targetPos:Number = 0;
        private static var deceleration:Number = 0.25;
        private var direction:int = 0;
        private static var basePath:String = "http://www.project-nya.jp/test/";

        //コンストラクタ
        public function Main() {
            init();
        }

        //メソッド
        private function init():void {
            //ボタンの配置
            prevBtn = new Btn();
            addChild(prevBtn);
            prevBtn.x = 42;
            prevBtn.y = 172;
            prevBtn.init({label: "prev"});
            prevBtn.addEventListener(MouseEvent.CLICK, prev, false, 0, true);
            prevBtn.enabled = false;
            nextBtn = new Btn();
            addChild(nextBtn);
            nextBtn.x = 422;
            nextBtn.y = 172;
            nextBtn.init({label: "next"});
            nextBtn.addEventListener(MouseEvent.CLICK, next, false, 0, true);
            nextBtn.enabled = false;
            //XMLの読み込み
            provider = new URLLoader();
            provider.addEventListener(Event.COMPLETE, parse, false, 0, true);
            //provider.load(new URLRequest(dataPath));
            provider.load(new URLRequest(basePath + dataPath));
            //コンテンツの配列
            thumbs = new Array();
            photos = new Array();
            //
            plate = new Sprite();
            addChild(plate);
            var overlay:Sprite = new Sprite();
            overlay.graphics.beginFill(0x000000);
            overlay.graphics.drawRect(10, 192, 445, 80);
            overlay.graphics.endFill();
            plate.mask = overlay;
            //
            container = new Sprite();
            addChild(container);
            container.graphics.beginFill(0x000000, 0.6);
            container.graphics.drawRect(0, 0, 465, 465);
            container.graphics.endFill();
            container.alpha = 0;
            container.visible = false;
            container.addEventListener(MouseEvent.CLICK, release, false, 0, true);
        }
        private function parse(evt:Event):void {
            //XMLの解析
            var xml:XML = XML(evt.target.data);
            max = xml.image.length();
            //画像パスの格納
            thumbPaths = new Array();
            photoPaths = new Array();
            for (var n:uint = 0; n < max*2; n++) {
                var image:XML = xml.image[n%max];
                //thumbPaths.push(image.thumb);
                //photoPaths.push(image.photo);
                thumbPaths.push(basePath + image.thumb);
                photoPaths.push(basePath + image.photo);
            }
            load();
        }
        /////////////////////////////////////////////
        //画像の読み込み
        /////////////////////////////////////////////
        private function load():void {
            _loaders = new Dictionary(true);
            loaders = new Dictionary(true);
            for (var n:uint = 0; n < max*2; n++) {
                var _loader:Loader = new Loader();
                _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _complete, false, 0, true);
                _loader.load(new URLRequest(thumbPaths[n%max]));
                _loaders[_loader] = n;
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
                loader.load(new URLRequest(photoPaths[n%max]));
                loaders[loader] = n;
            }
        }
        private function _complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, _complete);
            var _loader:Loader = Loader(evt.target.loader);
            var id:uint = _loaders[_loader];
            var content:Bitmap = Bitmap(_loader.content);
            var thumb:Thumb = new Thumb(content);
            thumb.id = id;
            thumbs[id] = thumb;
            thumb.mouseEnabled = false;
            thumb.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            initialize();
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            var loader:Loader = Loader(evt.target.loader);
            var id:uint = loaders[loader];
            var content:Bitmap = Bitmap(loader.content);
            var photo:Photo = new Photo(content);
            photo.id = id;
            photos[id] = photo;
            initialize();
        }
        private function initialize():void {
            loaded ++;
            if (loaded > max*4 - 1) {
                setup();
            }
        }
        /////////////////////////////////////////////
        //ボタン処理
        /////////////////////////////////////////////
        private function setup():void {
            //ボタン有効
            prevBtn.enabled = true;
            nextBtn.enabled = true;
            //画像(サムネイル)の配置
            for (var n:uint = 0; n < max*2; n++) {
                var thumb:Thumb = thumbs[n];
                thumb.mouseEnabled = true;
                plate.addChild(thumb);
                thumb.x = 52 + 90*n;
                thumb.y = 232;
            }
        }
        private function prev(evt:MouseEvent):void {
            direction = - 1;
            transit(currentId - 1);
        }
        private function next(evt:MouseEvent):void {
            direction = 1;
            transit(currentId + 1);
        }
        private function transit(id:uint):void {
            currentId = id;
            targetPos = - 90*currentId;
            if (direction < 0 && targetPos > 0) {
                currentId += max;
                plate.x -= 90*max;
                targetPos -= 90*max;
            }
            if (direction > 0 && targetPos < - 90*max) {
                currentId -= max;
                plate.x += 90*max;
                targetPos += 90*max;
            }
            addEventListener(Event.ENTER_FRAME, slide, false, 0, true);
        }
        private function slide(evt:Event):void {
            plate.x += (targetPos - plate.x)*deceleration;
            if (Math.abs(targetPos - plate.x) < 0.5) {
                plate.x = targetPos;
                removeEventListener(Event.ENTER_FRAME, slide);
            }
        }
        /////////////////////////////////////////////
        //画像表示
        /////////////////////////////////////////////
        private function click(evt:MouseEvent):void {
            select(evt.target.id);
        }
        private function select(id:uint):void {
            if (container.numChildren > 1) container.removeChildAt(1);
            var photo:Photo = photos[id];
            photo.x = 232;
            photo.y = 232;
            container.addChild(photo);
            //
            removeEventListener(Event.ENTER_FRAME, fadeOut);
            //container.alpha = 1;
            container.visible = true;
            addEventListener(Event.ENTER_FRAME, fadeIn, false, 0, true);
        }
        private function fadeIn(evt:Event):void {
            container.alpha += 0.05;
            if (container.alpha > 1) {
                container.alpha = 1;
                removeEventListener(Event.ENTER_FRAME, fadeIn);
            }
        }
        private function release(evt:MouseEvent):void {
            //container.alpha = 0;
            //container.visible = false;
            removeEventListener(Event.ENTER_FRAME, fadeIn);
            addEventListener(Event.ENTER_FRAME, fadeOut, false, 0, true);
        }
        private function fadeOut(evt:Event):void {
            container.alpha -= 0.05;
            if (container.alpha < 0) {
                container.alpha = 0;
                container.visible = false;
                removeEventListener(Event.ENTER_FRAME, fadeOut);
            }
        }

    }

}


//////////////////////////////////////////////////
// Thumbクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.filters.DropShadowFilter;

class Thumb extends Sprite {
    public var id:uint;
    private var bitmap:Bitmap;

    public function Thumb(b:Bitmap) {
        bitmap = b;
        init();
    }

    private function init():void {
        bitmap.x = - uint(bitmap.width/2);
        bitmap.y = - uint(bitmap.height/2);
        addChild(bitmap);
        bitmap.smoothing = true;
        filters = [new DropShadowFilter(1, 90, 0x000000, 0.4, 4, 4, 2, 3, false, false, false)];
        buttonMode = true;
        mouseChildren = false;
    }

}


//////////////////////////////////////////////////
// Photoクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.filters.DropShadowFilter;

class Photo extends Sprite {
    public var id:uint;
    private var bitmap:Bitmap;

    public function Photo(b:Bitmap) {
        bitmap = b;
        init();
    }

    private function init():void {
        bitmap.x = - uint(bitmap.width/2);
        bitmap.y = - uint(bitmap.height/2);
        addChild(bitmap);
        bitmap.smoothing = true;
        filters = [new DropShadowFilter(1, 90, 0x000000, 0.4, 8, 8, 2, 3, false, false, false)];
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
