/**
 * Copyright omari ( http://wonderfl.net/user/omari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AaFQz
 */

package jp.nya.project.controls {

    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.HTTPStatusEvent;
    import flash.events.SecurityErrorEvent;

    public class PhotoLoader extends Sprite {
        // プロパティ
        private var loader:Loader;
        private var info:LoaderInfo;
        public var content:*;
        private var smoothing:Boolean;
        public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
        public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
        public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
        public static const INIT:String = Event.INIT;
        public static const COMPLETE:String = Event.COMPLETE;

        // コンストラクタ
        public function PhotoLoader() {
            loader = new Loader();
            info = loader.contentLoaderInfo;
        }

        // メソッド
        public function load(file:String, s:Boolean = false):void {
            smoothing = s;
            info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
            info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
            info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
            info.addEventListener(Event.INIT, initialize, false, 0, true);
            info.addEventListener(Event.COMPLETE, complete, false, 0, true);
            try {
                loader.load(new URLRequest(file));
            } catch (err:Error) {
                trace(err.message);
            }
        }
        public function unload():void {
            loader.unload();
        }
        private function ioerror(evt:IOErrorEvent):void {
            loader.unload();
            dispatchEvent(new Event(PhotoLoader.IO_ERROR));
        }
        private function httpstatus(evt:HTTPStatusEvent):void {
            dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
        }
        private function securityerror(evt:SecurityErrorEvent):void {
            dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
        }
        private function initialize(evt:Event):void {
            if (smoothing) {
                content = Bitmap(info.content);
                content.smoothing = true;
            } else {
                content = info.content;
            }
            dispatchEvent(new Event(PhotoLoader.INIT));
        }
        private function complete(evt:Event):void {
            info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
            info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
            info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
            info.removeEventListener(Event.INIT, initialize);
            info.removeEventListener(Event.COMPLETE, complete);
            addChild(loader);
            dispatchEvent(new Event(PhotoLoader.COMPLETE));
        }
        public function centerize():void {
            content.x = -uint(content.width*0.5);
            content.y = -uint(content.height*0.5);
        }

    }

}