/**
 * Copyright tequibo ( http://wonderfl.net/user/tequibo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AaFJ
 */

//by tequibo http://tequibo.com
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;    
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;

    public class Main extends Sprite {
        private var mainLine:Sprite;
        private var Counter:Number;
        private var Points:Array;
        private var originalPoints:Array;
        private var invisibleButton:MovieClip;
        private var bg:Sprite;
        private var singleLine:Sprite;
        private var zeroPoint:Point;
        private var cut:Number;
        private var drawed:Boolean;
        private var cursIndex:Number;
        private var newAngle:Number;
        private var oldX:Number;
        private var oldY:Number;
        private var randomPoint:Point;        
        private var paperBitmap:Bitmap;
        private var paperData:BitmapData;
        private var randomPointRiched:Boolean;
        private var scale:Number;
        private var color:Number;
        private var tip:TextField;
        public function Main():void {
            tip = new TextField();
            
            tip.text = "Try to draw something";
            tip.setTextFormat(new TextFormat("Arial", 45, 0xffffff));
            tip.antiAliasType = flash.text.AntiAliasType.NORMAL;
            tip.autoSize = TextFieldAutoSize.LEFT
            
            //tip.x=stage.stageWidth/2
            tip.y=stage.stageHeight*.75
            color = Math.random() * 0xFFFFFF;
            scale = 1;
            randomPointRiched = false;
            randomPoint = new Point(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight);
            cursIndex = 0;
            drawed = false;
            cut =20;
            newAngle = Math.PI;
            Points = new Array();
            originalPoints = new Array();
            //zeroPoint = new Point(0, 0)
            //Points[0]=zeroPoint
            Counter = 0;
            paperData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
            paperBitmap = new Bitmap(paperData);
            paperData.fillRect(new Rectangle(0, 0, 600, 600), 0xffffff);
            mainLine = new Sprite;
            invisibleButton = new MovieClip();
            bg = new Sprite();            
            bg.graphics.beginFill(0x171717);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            singleLine = new Sprite();            
            invisibleButton.graphics.beginFill(0x171717,0);
            invisibleButton.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            invisibleButton.graphics.endFill();    
            
            
            invisibleButton.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            invisibleButton.addEventListener(MouseEvent.MOUSE_UP, onUp);
                            
            addChild(bg);
            addChild(paperBitmap);
            addChild(singleLine);
            addChild(mainLine);            
            addChild(tip);
            addChild(invisibleButton);
        }
        public function draw():void {
            var tmpPoint:Point = new Point(mouseX, mouseY);            
            var orPoint:Point =  new Point(mouseX, mouseY);            
            Points[Counter] = tmpPoint;
            originalPoints[Counter] = orPoint;
            Counter++;    
        }
        public function drawLineToBitmap(fromX:Number, fromY:Number, toX:Number, toY:Number):void {
            singleLine.graphics.clear();
            singleLine.graphics.lineStyle(1, color);
            singleLine.graphics.moveTo(fromX, fromY);
            singleLine.graphics.lineTo(toX, toY);
            paperData.draw(singleLine);
        }
        public function newPointToDraw():void {
                color = 0x999999+Math.random() * 0x333333;
                scale=1+Math.random()*3
                randomPointRiched = false;
                newAngle = Math.random() * Math.PI*2;                
                var cost:Number = Math.cos(newAngle)
                var sint:Number = Math.sin(newAngle)
                var dxt:Number= (originalPoints[originalPoints.length - 1].x - originalPoints[0].x)/scale
                var dyt:Number= (originalPoints[originalPoints.length - 1].y - originalPoints[0].y)/scale
                var w:Number=dxt*cost-dyt*sint
                var h:Number= dyt*cost+dxt*sint
                
                if(w>0){
                    randomPoint.x = Math.random() * (stage.stageWidth-w);
                }
                else {
                    randomPoint.x = Math.random() * (stage.stageWidth+w)+Math.abs(w);
                }                
                if(h>0){
                    randomPoint.y =  Math.random() * (stage.stageHeight-h);
                }
                else {
                    randomPoint.y = Math.random() * (stage.stageHeight+h)+Math.abs(h);
                }
        }
        public function moveCursour():void {
            if (cursIndex < Points.length - 1) {                
            cursIndex++;    
            var pencil:Point = Points[Points.length - 1];
            var cos:Number = Math.cos(newAngle);
            var sin:Number = Math.sin(newAngle);
            var dx:Number= (originalPoints[cursIndex].x - originalPoints[0].x)/scale
            var dy:Number= (originalPoints[cursIndex].y -originalPoints[0].y)/scale
            pencil.x = dx*cos-dy*sin+randomPoint.x;
            pencil.y = dy*cos+dx*sin+randomPoint.y;
            if(cursIndex>1){
                drawLineToBitmap(oldX , oldY , pencil.x , pencil.y)
            }
            oldX = pencil.x;
            oldY = pencil.y;            
            }
            else {
                newPointToDraw()
                cursIndex = 0;                
                oldX = (originalPoints[cursIndex].x-originalPoints[0].x) * Math.cos(newAngle)+300;
                oldY = (originalPoints[cursIndex].y -originalPoints[0].x)*Math.sin(newAngle)+300;
            }
            
            
        }
        public function alive():void {
            var pencil:Point = Points[Points.length - 1];
            
            if(randomPointRiched){
            moveCursour();
            }
            else {
                if (Point.distance(pencil, randomPoint) < 3) {                
                    randomPointRiched = true;
                }            
                pencil.offset((randomPoint.x-pencil.x)/9,(randomPoint.y-pencil.y)/9)            
            }
                    var speed:Number = 3;    
            for (var i:Number = Points.length-2; i > -1 ; i--)
            {    
                //var speed:Number = 2+Math.random()*10;            
            
            //original line points
            var or_first:Point = originalPoints[i];
            var or_second:Point = originalPoints[i + 1];
            //moving line points        
            var first:Point = Points[i];    
            var second:Point = Points[i + 1];
            var lowerDistance:Number = Point.distance(or_first, or_second)/3;//minimal distance between two points
            var lowerDistanceX:Number = or_second.x - or_first.x; 
            var lowerDistanceY:Number = or_second.y - or_first.y;
            var myAngle:Number = Math.atan2((first.y-second.y), (first.x-second.x));            
            var myDistance:Number = Point.distance(first, second)
            var myDistanceX:Number = second.x-first.x
            var myDistanceY:Number = second.y-first.y
            var pixelsX:Number=(myDistanceX-lowerDistanceX)/speed
            var pixelsY:Number=(myDistanceY-lowerDistanceY)/speed
            var pixels:Number=(myDistance-lowerDistance)/speed
            first.offset(pixelsX, pixelsY )
            
        }            
        }
        public function render():void {
            if(Points.length>0){
            mainLine.graphics.clear();
            mainLine.graphics.lineStyle(2,0xffffff)// 0xFFCC32);
            mainLine.graphics.moveTo(Points[0].x, Points[0].y)            
            for (var i:Number = 0; i < Points.length; i++)
            {                
                var tmpPoint2:Point = Points[i]                
                mainLine.graphics.lineTo(tmpPoint2.x, tmpPoint2.y);                
            }
            if (drawed) {                    
                    alive();
                }
            }
        }
        public function onFrame(event:Event):void
        {    
            if(!drawed){
            draw();    
            }
            render();
        }        
        public function onDown(event:MouseEvent):void {
            paperData.fillRect(new Rectangle(0, 0, 600, 600), 0xffffff);
            mainLine.graphics.clear();
            drawed = false;
            Counter = 0;
            Points.splice(0, Points.length);                
            originalPoints.splice(0, originalPoints.length);            
            invisibleButton.addEventListener(Event.ENTER_FRAME, onFrame);
        }
        public function onUp(event:MouseEvent):void {
            tip.visible = false;
            newPointToDraw()            
            mainLine.graphics.clear();
            randomPointRiched = false;
            cursIndex = 0;
            drawed = true;
            //for (var i:Number = Points.length-1; i >0 ; i-=cut) {//can simplify scribble
                    //Points.splice(i, 1);                        
                    //originalPoints.splice(i, 1);                        
            //}            
        
            
        }
    }
}