/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Aa8S
 */

// forked from yshu's Doughnut with colorful smoke
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix3D;
    import flash.geom.Point;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;
    
    public class Doughnut extends Sprite
    {
        private var screen:BitmapData                    = new BitmapData(475, 475, false, 0)
        private var vertices:Vector.<Number>            = new Vector.<Number>()
        private var uvtData:Vector.<Number>                = new Vector.<Number>()        
        private var matrix3D:Matrix3D                     = new Matrix3D()
        private var projectedVertices:Vector.<Number>    = new Vector.<Number>()        
        private var max  :Number  =  10000
        private var r    :Number  =  20            
        private var blurFilter:BlurFilter = new BlurFilter( 6,6,6 )  //  ( 3,10,3 )
        private var colorMatrixFilter:ColorMatrixFilter = new ColorMatrixFilter([1.0789172123219,-0.1599448999802,0.0810276876583043,0,0,-0.0310251294027207,1.07137488688194,-0.0403497574792219,0,0,-0.124238196271341,-0.0166172810316758,1.14085547730302,0,0,0,0,0,1,0])        
        //private var colorMatrixFilter:ColorMatrixFilter = new ColorMatrixFilter( [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0] )  //[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1] )  //  [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
        private var point:Point = new Point()
        
        
        public function Doughnut() 
        {
            stage.frameRate = 90 
            var a:Number
            var b:Number
            
            for (var c:Number = 0; c < max; c++ )
            {
                a = Math.PI * 2 * Math.random()  //2 * Math.random()
                b = Math.PI * 2 * Math.random()  //2 * Math.random()

                vertices.push
                (
                    ( ( r*Math.sin(a)*Math.cos(b) ) * 1) + 25,
                    ( ( r*Math.sin(a)*Math.sin(b) ) / 1) + 50,
                    ( ( r*Math.cos(a)*Math.sin(a) ) / 1)    
                )
            }

            addChild(new Bitmap(screen))
            
            //stage.align = 'TL'
            stage.quality= 'BEST'
            //stage.scaleMode = 'noScale'
            stage.addEventListener('enterFrame', render)
        }
        
        private function render(...e):void 
        {
            var t:Number = getTimer() / 6  //10
            
            matrix3D = new Matrix3D()
            matrix3D.prependRotation( t*-1.2 ,    Vector3D.X_AXIS)
            matrix3D.prependRotation( t,    Vector3D.Y_AXIS)

            Utils3D.projectVectors(matrix3D, vertices, projectedVertices, uvtData)
            
            screen.lock()
            screen.applyFilter(screen, screen.rect, point, blurFilter )
            screen.applyFilter(screen, screen.rect, point, colorMatrixFilter)
            screen.scroll(0,-10)
            for (var c:Number = 0;c<projectedVertices.length-1; c+=2 ) screen.setPixel(projectedVertices[c] + 238, projectedVertices[c + 1] + 238, 0xffffff/max*c)
            screen.unlock()
        }
    }
}