/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AQts
 */

// forked from the.kuniva's flash on 2014-6-8
package {

    import flash.display.*;



    public dynamic class Y8 extends SimpleButton {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class ButtonDownload extends SimpleButton {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class TubeTop extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class GUI extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class BirdBlue extends MovieClip {



    }

}//package 

﻿package {

    import flash.events.*;

    import flash.display.*;

    import flash.text.*;

    import lib.*;



    public class Preloader extends MovieClip {



        public var PLAYEVENT = true;

        public var TITLE = "FLAPPY BIRD";

        public var REF = "flappy_bird";

        public var GAME_TINY_URL = "http://bit.ly/LRKFON";

        public var FACEBOOK_URL = null;

        public var MOREGAMES_URL = "http://mylostgames.com/";

        public var GAME_URL_BASE = "http://mylostgames.com/play/";

        public var GAME_THUMBS_REF;

        public var CPMSTAR_ENABLED = true;

        public var CPMSTAR_WAIT = 2500;

        public var POOLID = 24729;

        public var SUBPOOLID = 16;

        public var VERSION = "2.0";

        public var MOCHI = false;

        public var LOADING_GAME_MSG = "LOADING FLAPPY BIRD ...";

        var progress_txt:TextField;



        public function Preloader():void{

            this.GAME_THUMBS_REF = ["madpet_jumper", "madpet_jumper", "madpet_jumper", "madpet_jumper"];

            this.progress_txt = new TextField();

            super();

            stop();

            this.progress_txt.x = 100;

            this.progress_txt.y = (stage.stageHeight / 2);

            addChild(this.progress_txt);

            loaderInfo.addEventListener(ProgressEvent.PROGRESS, this.onProgress);

            loaderInfo.addEventListener(Event.COMPLETE, this.onComplete);

            if (this.PLAYEVENT){

                GPlayEvent.send(root, {

                    ref:this.REF,

                    version:this.VERSION,

                    mochi:this.MOCHI

                });

            };

        }

        function onProgress(_arg1:ProgressEvent):void{

            this.progress_txt.text = (("LOADING ... " + String(Math.floor(((_arg1.bytesLoaded / _arg1.bytesTotal) * 100)))) + "%");

        }

        function onComplete(_arg1:Event):void{

            loaderInfo.removeEventListener(ProgressEvent.PROGRESS, this.onProgress);

            loaderInfo.removeEventListener(Event.COMPLETE, this.onComplete);

            gotoAndStop(2);

            var _local2:* = new Main();

            addChild(_local2);

            _local2.begin(this);

        }



    }

}//package 

﻿package {

    import flash.events.*;

    import flash.display.*;

    import flash.text.*;

    import flash.geom.*;

    import lib.*;

    import CPMStar.*;

    import flash.filters.*;

    import flash.ui.*;



    public class Main extends MovieClip {



        var _mochiads_game_id:String = "";

        public var gameWidth = 310;

        public var gameHeight = 400;

        public var PHYSICS_FRAME_RATE = 120;

        public var input:GInput;

        public var frame:GFrame;

        public var gsound:GSoundSimple;

        public var network:GNetwork;

        public var screen:Screen;

        public var game:Game;

        public var cookieVars;

        public var flashFocus:Boolean;

        public var sfxList;

        public var mouse;

        public var loaderRoot;

        public var status;



        public function Main(){

            this.cookieVars = new Object();

            this.sfxList = new Object();

            this.mouse = new Point();

            super();

        }

        public function begin(_arg1){

            this.loaderRoot = _arg1;

            this.flashFocus = true;

            var _local2:* = GCookie.restoreVars(_arg1.REF);

            if (((_local2) && (!((_local2.yourbest == undefined))))){

                this.cookieVars.yourbest = _local2.yourbest;

            } else {

                this.cookieVars.yourbest = 0;

            };

            this.gsound = new GSoundSimple();

            this.gsound.setSoundFxGap(200);

            this.network = new GNetwork();

            this.input = new GInput(stage, {

                mouseClick:this.mouseClick,

                mouseDown:this.mouseDown,

                mouseUp:this.mouseUp,

                mouseMove:this.mouseMove,

                mouseLeave:this.mouseLeave,

                keyDown:this.keyDown,

                keyUp:this.keyUp

            });

            this.frame = new GFrame(this.enterFrame, this.fixFrame, null, this.PHYSICS_FRAME_RATE);

            this.frame.addPermanentFrame(this.permanentFrame);

            this.game = new Game(this);

            this.screen = new Screen(this);

            addChild(this.screen);

            this.initGame(true);

        }

        public function stopEffects(){

        }

        public function initGame(_arg1){

            this.game.newHighScore = false;

            this.game.initTubes();

            this.game.initBird();

            this.game.backgroundIndex = (1 + int((2 * Math.random())));

            var _local2:* = new Date();

            var _local3:* = int((_local2.getTime() / 1000));

            var _local4:* = (_local3 > 1393502400);

            if (this.loaderRoot.VERSION == "Y8"){

                if (_arg1){

                    this.screen.showOpenAd(_local4);

                } else {

                    this.screen.showOpen();

                };

            } else {

                if (_arg1){

                    if (_local4){

                        this.screen.showOpenAd(true);

                    } else {

                        this.screen.showTitle();

                    };

                } else {

                    if (((!(_local4)) || ((Math.random() < 0.8)))){

                        this.screen.showOpen();

                    } else {

                        this.screen.showOpenAd(true);

                    };

                };

            };

        }

        public function startGame(){

            this.game.reset();

            this.game.start();

            this.screen.showPlay();

        }

        private function enterFrame(_arg1:Number){

            if (!this.flashFocus){

                return;

            };

            this.game.update(_arg1);

            this.screen.update(_arg1);

        }

        private function permanentFrame(_arg1:Number){

            if (!this.flashFocus){

                return;

            };

            if (this.screen.focusLostLayer){

                while (this.screen.focusLostLayer.numChildren) {

                    this.screen.focusLostLayer.removeChildAt(0);

                };

            };

        }

        private function fixFrame(_arg1:Number){

            if (!this.flashFocus){

                return;

            };

            this.game.fixFrame(_arg1);

        }

        private function mouseClick(_arg1){

        }

        private function mouseDown(_arg1){

        }

        private function mouseUp(_arg1){

        }

        private function mouseMove(_arg1){

            this.mouse.x = _arg1.stageX;

            this.mouse.y = _arg1.stageY;

        }

        private function mouseLeave(_arg1){

        }

        private function keyDown(_arg1){

            if (!this.flashFocus){

                return;

            };

            if (this.status == "play"){

                if (_arg1.keyCode == 32){

                    this.game.keyEvent("space", true);

                };

                if (_arg1.keyCode == 38){

                    this.game.keyEvent("up", true);

                };

                if (_arg1.keyCode == 37){

                    this.game.keyEvent("left", true);

                };

                if (_arg1.keyCode == 40){

                    this.game.keyEvent("down", true);

                };

                if (_arg1.keyCode == 39){

                    this.game.keyEvent("right", true);

                };

                if (_arg1.keyCode == 87){

                    this.game.keyEvent("w", true);

                };

                if (_arg1.keyCode == 65){

                    this.game.keyEvent("a", true);

                };

                if (_arg1.keyCode == 83){

                    this.game.keyEvent("s", true);

                };

                if (_arg1.keyCode == 68){

                    this.game.keyEvent("d", true);

                };

                if (_arg1.keyCode == 49){

                    this.game.keyEvent("1", true);

                };

                if (_arg1.keyCode == 50){

                    this.game.keyEvent("2", true);

                };

            };

        }

        private function keyUp(_arg1){

            if (!this.flashFocus){

                return;

            };

            if (this.status == "play"){

                if (_arg1.keyCode == 38){

                    this.game.keyEvent("up", false);

                };

                if (_arg1.keyCode == 37){

                    this.game.keyEvent("left", false);

                };

                if (_arg1.keyCode == 40){

                    this.game.keyEvent("down", false);

                };

                if (_arg1.keyCode == 39){

                    this.game.keyEvent("right", false);

                };

            };

        }

        public function gameOver(){

            this.screen.showGameOver();

        }

        public function getAdBox(){

            if (this.loaderRoot.CPMSTAR_ENABLED){

                return (AdLoader.LoadAd(this.loaderRoot.POOLID, this.loaderRoot.SUBPOOLID));

            };

            return (new AdHolder());

        }



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class TubeBottom extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class FlappyLogo extends MovieClip {



    }

}//package 

﻿package {

    import flash.media.*;



    public dynamic class WingSfx extends Sound {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class OpenAdScreen extends MovieClip {



        public var y8:Y8;

        public var adBox:MovieClip;

        public var buttonPlay:ButtonPlay;



    }

}//package 

﻿package mx.utils {

    import flash.utils.*;



    public class Base64Encoder {



        public static const CHARSET_UTF_8:String = "UTF-8";

        public static const MAX_BUFFER_SIZE:uint = 32767;

        private static const ESCAPE_CHAR_CODE:Number = 61;

        private static const ALPHABET_CHAR_CODES:Array = [65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47];



        public static var newLine:int = 10;



        public var insertNewLines:Boolean = true;

        private var _buffers:Array;

        private var _count:uint;

        private var _line:uint;

        private var _work:Array;



        public function Base64Encoder(){

            this._work = [0, 0, 0];

            super();

            this.reset();

        }

        public function drain():String{

            var _local3:Array;

            var _local1 = "";

            var _local2:uint;

            while (_local2 < this._buffers.length) {

                _local3 = (this._buffers[_local2] as Array);

                _local1 = (_local1 + String.fromCharCode.apply(null, _local3));

                _local2++;

            };

            this._buffers = [];

            this._buffers.push([]);

            return (_local1);

        }

        public function encode(_arg1:String, _arg2:uint=0, _arg3:uint=0):void{

            if (_arg3 == 0){

                _arg3 = _arg1.length;

            };

            var _local4:uint = _arg2;

            var _local5:uint = (_arg2 + _arg3);

            if (_local5 > _arg1.length){

                _local5 = _arg1.length;

            };

            while (_local4 < _local5) {

                this._work[this._count] = _arg1.charCodeAt(_local4);

                this._count++;

                if ((((this._count == this._work.length)) || (((_local5 - _local4) == 1)))){

                    this.encodeBlock();

                    this._count = 0;

                    this._work[0] = 0;

                    this._work[1] = 0;

                    this._work[2] = 0;

                };

                _local4++;

            };

        }

        public function encodeUTFBytes(_arg1:String):void{

            var _local2:ByteArray = new ByteArray();

            _local2.writeUTFBytes(_arg1);

            _local2.position = 0;

            this.encodeBytes(_local2);

        }

        public function encodeBytes(_arg1:ByteArray, _arg2:uint=0, _arg3:uint=0):void{

            if (_arg3 == 0){

                _arg3 = _arg1.length;

            };

            var _local4:uint = _arg1.position;

            _arg1.position = _arg2;

            var _local5:uint = _arg2;

            var _local6:uint = (_arg2 + _arg3);

            if (_local6 > _arg1.length){

                _local6 = _arg1.length;

            };

            while (_local5 < _local6) {

                this._work[this._count] = _arg1[_local5];

                this._count++;

                if ((((this._count == this._work.length)) || (((_local6 - _local5) == 1)))){

                    this.encodeBlock();

                    this._count = 0;

                    this._work[0] = 0;

                    this._work[1] = 0;

                    this._work[2] = 0;

                };

                _local5++;

            };

            _arg1.position = _local4;

        }

        public function flush():String{

            if (this._count > 0){

                this.encodeBlock();

            };

            var _local1:String = this.drain();

            this.reset();

            return (_local1);

        }

        public function reset():void{

            this._buffers = [];

            this._buffers.push([]);

            this._count = 0;

            this._line = 0;

            this._work[0] = 0;

            this._work[1] = 0;

            this._work[2] = 0;

        }

        public function toString():String{

            return (this.flush());

        }

        private function encodeBlock():void{

            var _local1:Array = (this._buffers[(this._buffers.length - 1)] as Array);

            if (_local1.length >= MAX_BUFFER_SIZE){

                _local1 = [];

                this._buffers.push(_local1);

            };

            _local1.push(ALPHABET_CHAR_CODES[((this._work[0] & 0xFF) >> 2)]);

            _local1.push(ALPHABET_CHAR_CODES[(((this._work[0] & 3) << 4) | ((this._work[1] & 240) >> 4))]);

            if (this._count > 1){

                _local1.push(ALPHABET_CHAR_CODES[(((this._work[1] & 15) << 2) | ((this._work[2] & 192) >> 6))]);

            } else {

                _local1.push(ESCAPE_CHAR_CODE);

            };

            if (this._count > 2){

                _local1.push(ALPHABET_CHAR_CODES[(this._work[2] & 63)]);

            } else {

                _local1.push(ESCAPE_CHAR_CODE);

            };

            if (this.insertNewLines){

                if ((this._line = (this._line + 4)) == 76){

                    _local1.push(newLine);

                    this._line = 0;

                };

            };

        }



    }

}//package mx.utils 

﻿package {

    import flash.display.*;



    public dynamic class BackScroll extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class AdHolder extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class Background extends MovieClip {



        public function Background(){

            addFrameScript(0, this.frame1, 1, this.frame2);

        }

        function frame1(){

            stop();

        }

        function frame2(){

            stop();

        }



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class HiscoreNew extends MovieClip {



    }

}//package 

﻿package {

    import flash.events.*;

    import flash.display.*;

    import flash.text.*;

    import flash.geom.*;

    import lib.*;

    import flash.filters.*;

    import flash.ui.*;



    public class Screen extends MovieClip {



        public var m:Object;

        public var guiFont;

        public var guiFontColor = 0xFFFFFF;

        public var guiFontShadowColor = 0;

        public var shadowOffset = 4;

        public var gameWidth;

        public var gameHeight;

        public var game:Object;

        public var input:GInput;

        public var frame:GFrame;

        public var gsound:GSoundSimple;

        public var network:GNetwork;

        public var wrapper:Sprite;

        public var focusLostLayer:Sprite;

        public var flashLayer:Sprite;

        public var guiLayer:Sprite;

        public var openScreen:MovieClip;

        public var playScreen:MovieClip;

        public var gameOverScreen:MovieClip;

        public var getReady:MovieClip;

        public var backScroll:MovieClip;

        public var gui:MovieClip;

        public var scoreSize = 32;

        public var gameOverScoreSize = 18;

        public var scoreX = 0;

        public var scoreY = 25;

        public var scoreWidget:GWidget;

        public var scoreWidgetShadow:GWidget;



        public function Screen(_arg1:Object){

            this.guiFont = GUIFont;

            super();

            this.m = _arg1;

            this.gameWidth = _arg1.gameWidth;

            this.gameHeight = _arg1.gameHeight;

            this.game = _arg1.game;

            this.input = _arg1.input;

            this.frame = _arg1.frame;

            this.gsound = _arg1.gsound;

            this.network = _arg1.network;

            this.wrapper = new Sprite();

            addChild(this.wrapper);

            this.focusLostLayer = new Sprite();

            addChild(this.focusLostLayer);

        }

        public function update(_arg1:Number){

            this.updateBird();

            this.updateBackScroll();

            this.updateFlashEffect(_arg1);

            this.updateGUI();

            this.updateGetReady(_arg1);

            this.updateGameOver(_arg1);

            if (this.focusLostLayer){

                while (this.focusLostLayer.numChildren) {

                    this.focusLostLayer.removeChildAt(0);

                };

            };

        }

        public function flashEffect(){

            this.flashLayer.alpha = 1;

            this.flashLayer.visible = true;

        }

        public function showOpenAd(_arg1){

            var openAdScreen:* = undefined;

            var adBox:* = undefined;

            var cpmstar:* = _arg1;

            this.m.status = "openad";

            while (this.wrapper.numChildren) {

                this.wrapper.removeChildAt(0);

            };

            openAdScreen = new OpenAdScreen();

            this.wrapper.addChild(openAdScreen);

            adBox = ((cpmstar) ? this.m.getAdBox() : new Sprite());

            openAdScreen.adBox.addChild(adBox);

            openAdScreen.y8.visible = (((this.m.loaderRoot.VERSION == "Y8")) && (!(cpmstar)));

            openAdScreen.y8.addEventListener(MouseEvent.CLICK, function (){

                network.gotoURL("http://y8.com/");

            });

            openAdScreen.buttonPlay.addEventListener(MouseEvent.CLICK, function (){

                openAdScreen.adBox.removeChild(adBox);

                wrapper.removeChild(openAdScreen);

                showTitle();

            });

            openAdScreen.buttonPlay.visible = false;

            this.frame.addTimer(1.5, function (){

                openAdScreen.buttonPlay.visible = true;

            });

            openAdScreen.focusRect = false;

        }

        public function showOpen(){

            this.m.status = "open";

            while (this.wrapper.numChildren) {

                this.wrapper.removeChildAt(0);

            };

            this.openScreen = new OpenScreen();

            this.wrapper.addChild(this.openScreen);

            var background:* = new Background();

            background.gotoAndStop(this.game.backgroundIndex);

            this.openScreen.addChild(background);

            this.backScroll = new BackScroll();

            this.openScreen.addChild(this.backScroll);

            this.getReady = new GetReady();

            this.getReady.alpha = 0;

            this.openScreen.addChild(this.getReady);

            this.openScreen.addChild(this.game.bird.clip);

            var scoreWidget:* = new GWidget({

                font:this.guiFont,

                color:this.guiFontColor,

                size:this.scoreSize,

                align:"center",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreMsg:* = scoreWidget.print("0", this.gameWidth);

            scoreMsg.x = this.scoreX;

            scoreMsg.y = this.scoreY;

            var scoreWidgetShadow:* = new GWidget({

                font:this.guiFont,

                color:this.guiFontShadowColor,

                size:this.scoreSize,

                align:"center",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreMsgShadow:* = scoreWidgetShadow.print("0", this.gameWidth);

            scoreMsgShadow.x = (this.scoreX + this.shadowOffset);

            scoreMsgShadow.y = (this.scoreY + this.shadowOffset);

            scoreMsgShadow.alpha = 0.6;

            this.openScreen.addChild(scoreMsgShadow);

            this.openScreen.addChild(scoreMsg);

            this.openScreen.addEventListener(MouseEvent.CLICK, function (){

                wrapper.removeChild(openScreen);

                m.startGame();

            });

            this.openScreen.focusRect = false;

        }

        public function showTitle(){

            var titleScreen:* = undefined;

            var buttonPlay:* = undefined;

            this.m.status = "title";

            while (this.wrapper.numChildren) {

                this.wrapper.removeChildAt(0);

            };

            titleScreen = new TitleScreen();

            this.wrapper.addChild(titleScreen);

            var background:* = new Background();

            background.gotoAndStop(1);

            titleScreen.addChild(background);

            this.backScroll = new BackScroll();

            titleScreen.addChild(this.backScroll);

            var logo:* = new FlappyLogo();

            titleScreen.addChild(logo);

            buttonPlay = new ButtonPlay();

            buttonPlay.x = 100;

            buttonPlay.y = 170;

            titleScreen.addChild(buttonPlay);

            this.game.birdOnTitle = new BirdBlue();

            this.game.birdOnTitle.x = ((this.gameWidth / 2) - 5);

            this.game.birdOnTitle.y = this.game.birdOnTitleY;

            titleScreen.addChild(this.game.birdOnTitle);

            buttonPlay.visible = false;

            buttonPlay.addEventListener(MouseEvent.CLICK, function (){

                wrapper.removeChild(titleScreen);

                showOpen();

            });

            this.frame.addTimer(0.5, function (){

                buttonPlay.visible = true;

            });

            titleScreen.focusRect = false;

        }

        public function showPlay(){

            var _local3:*;

            var _local4:*;

            var _local5:*;

            this.m.status = "play";

            while (this.wrapper.numChildren) {

                this.wrapper.removeChildAt(0);

            };

            this.playScreen = new PlayScreen();

            this.wrapper.addChild(this.playScreen);

            stage.focus = this.playScreen;

            this.flashLayer = new Sprite();

            this.flashLayer.graphics.beginFill(0xFFFFFF, 1);

            this.flashLayer.graphics.drawRect(0, 0, this.gameWidth, this.gameHeight);

            this.flashLayer.alpha = 0;

            this.flashLayer.visible = false;

            var _local1:* = new Background();

            _local1.gotoAndStop(this.game.backgroundIndex);

            this.backScroll = new BackScroll();

            this.playScreen.addChild(_local1);

            this.playScreen.addChild(this.getReady);

            this.game.visTubes = new Array();

            var _local2:* = 0;

            while (_local2 < 3) {

                _local3 = new Object();

                _local3.clip = new Sprite();

                _local3.clip.x = -100;

                this.playScreen.addChild(_local3.clip);

                _local4 = new TubeTop();

                _local4.y = (-(this.game.gateHeight) / 2);

                _local5 = new TubeBottom();

                _local5.y = (this.game.gateHeight / 2);

                _local3.clip.addChild(_local4);

                _local3.clip.addChild(_local5);

                this.game.visTubes.push(_local3);

                _local2++;

            };

            this.playScreen.addChild(this.game.bird.clip);

            this.playScreen.addChild(this.backScroll);

            this.playScreen.addChild(this.flashLayer);

            this.playScreen.addChild(this.buildGUI());

            this.playScreen.focusRect = false;

        }

        public function showGameOver(){

            var medal:* = undefined;

            var newRecord:* = undefined;

            var gameoveroffset:* = -30;

            this.m.status = "gameover";

            this.gameOverScreen = new GameOverScreen();

            this.gameOverScreen.x = this.gameWidth;

            this.gameOverScreen.alpha = 0;

            this.wrapper.addChild(this.gameOverScreen);

            var medalIdx:* = 0;

            if (this.game.score >= 30){

                medalIdx = 3;

            } else {

                if (this.game.score >= 20){

                    medalIdx = 2;

                } else {

                    if (this.game.score >= 10){

                        medalIdx = 1;

                    };

                };

            };

            if (medalIdx){

                medal = new Medal();

                medal.gotoAndStop(medalIdx);

                medal.x = 74;

                medal.y = (209 + gameoveroffset);

                this.gameOverScreen.addChild(medal);

            };

            if (this.gameOverScreen.buttonTweet){

                this.gameOverScreen.buttonTweet.addEventListener(MouseEvent.CLICK, function (){

                    network.gotoURL(((("http://twitter.com/?status=My new high score on flappy bird online is " + game.score) + "! ") + m.loaderRoot.GAME_TINY_URL));

                });

            };

            this.gameOverScreen.buttonMore.addEventListener(MouseEvent.CLICK, function (){

                network.gotoURL("http://mylostgames.com/");

            });

            this.gameOverScreen.buttonDownload.addEventListener(MouseEvent.CLICK, function (){

                network.gotoURL("http://mylostgames.com/");

            });

            this.gameOverScreen.buttonPlay.addEventListener(MouseEvent.CLICK, function (){

                wrapper.removeChild(gameOverScreen);

                wrapper.removeChild(playScreen);

                m.initGame(false);

            });

            this.gameOverScreen.buttonPlay.visible = false;

            this.gameOverScreen.buttonDownload.visible = false;

            this.gameOverScreen.buttonMore.visible = false;

            this.gameOverScreen.buttonTweet.visible = false;

            this.frame.addTimer(1.5, function (){

                gameOverScreen.buttonPlay.visible = true;

                gameOverScreen.buttonMore.visible = true;

                if (game.newHighScore){

                    gameOverScreen.buttonTweet.visible = true;

                } else {

                    gameOverScreen.buttonDownload.visible = true;

                };

            });

            if (this.game.score > this.m.cookieVars.yourbest){

                this.game.newHighScore = true;

                this.m.cookieVars.yourbest = this.game.score;

                newRecord = new HiscoreNew();

                newRecord.x = 175;

                newRecord.y = (221 + gameoveroffset);

                this.gameOverScreen.addChild(newRecord);

                this.gameOverScreen.buttonPlay.y = (this.gameOverScreen.buttonPlay.y + 68);

                this.gameOverScreen.buttonMore.y = (this.gameOverScreen.buttonMore.y + 68);

            };

            GCookie.saveVars(this.m.loaderRoot.REF, this.m.cookieVars);

            var scoreWidget:* = new GWidget({

                font:this.guiFont,

                color:this.guiFontColor,

                size:this.gameOverScoreSize,

                align:"right",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreMsg:* = scoreWidget.print(String(this.game.score), this.gameWidth);

            scoreMsg.x = -47;

            scoreMsg.y = (190 + gameoveroffset);

            var scoreWidgetShadow:* = new GWidget({

                font:this.guiFont,

                color:this.guiFontShadowColor,

                size:this.gameOverScoreSize,

                align:"right",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreMsgShadow:* = scoreWidgetShadow.print(String(this.game.score), this.gameWidth);

            scoreMsgShadow.x = (-47 + 3);

            scoreMsgShadow.y = ((190 + 3) + gameoveroffset);

            scoreMsgShadow.alpha = 0.7;

            var scoreBestWidget:* = new GWidget({

                font:this.guiFont,

                color:this.guiFontColor,

                size:this.gameOverScoreSize,

                align:"right",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreBestMsg:* = scoreBestWidget.print(String(this.m.cookieVars.yourbest), this.gameWidth);

            scoreBestMsg.x = -47;

            scoreBestMsg.y = (240 + gameoveroffset);

            var scoreBestWidgetShadow:* = new GWidget({

                font:this.guiFont,

                color:this.guiFontShadowColor,

                size:this.gameOverScoreSize,

                align:"right",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreBestMsgShadow:* = scoreBestWidgetShadow.print(String(this.m.cookieVars.yourbest), this.gameWidth);

            scoreBestMsgShadow.x = (-47 + 3);

            scoreBestMsgShadow.y = ((240 + 3) + gameoveroffset);

            scoreBestMsgShadow.alpha = 0.7;

            this.gameOverScreen.addChild(scoreMsgShadow);

            this.gameOverScreen.addChild(scoreBestMsgShadow);

            this.gameOverScreen.addChild(scoreMsg);

            this.gameOverScreen.addChild(scoreBestMsg);

        }

        public function buildGUI(){

            this.guiLayer = new Sprite();

            this.scoreWidget = new GWidget({

                font:this.guiFont,

                color:this.guiFontColor,

                size:this.scoreSize,

                align:"center",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreMsg:* = this.scoreWidget.print("", this.gameWidth);

            scoreMsg.x = this.scoreX;

            scoreMsg.y = this.scoreY;

            this.scoreWidgetShadow = new GWidget({

                font:this.guiFont,

                color:this.guiFontShadowColor,

                size:this.scoreSize,

                align:"center",

                margin:0,

                embed:true,

                antiAlias:true,

                letterSpacing:0

            });

            var scoreMsgShadow:* = this.scoreWidgetShadow.print("", this.gameWidth);

            scoreMsgShadow.x = (this.scoreX + this.shadowOffset);

            scoreMsgShadow.y = (this.scoreY + this.shadowOffset);

            scoreMsgShadow.alpha = 0.6;

            this.guiLayer.addChild(scoreMsgShadow);

            this.guiLayer.addChild(scoreMsg);

            var clickLayer:* = new Sprite();

            clickLayer.graphics.beginFill(0xFFFFFF, 0);

            clickLayer.graphics.drawRect(0, 0, this.gameWidth, this.gameHeight);

            clickLayer.addEventListener(MouseEvent.MOUSE_DOWN, function (){

                if (m.status == "play"){

                    game.clickOnPlay();

                };

            });

            this.guiLayer.addChild(clickLayer);

            this.gui = new GUI();

            this.guiLayer.addChild(this.gui);

            return (this.guiLayer);

        }

        private function updateGUI(){

            var _local1:*;

            if (!this.m.status){

                return;

            };

            if (this.m.status == "play"){

                _local1 = this.game.score.toString();

                if (this.scoreWidget){

                    this.scoreWidget.updateText(_local1);

                    this.scoreWidgetShadow.updateText(_local1);

                };

            };

        }

        private function updateGameOver(_arg1){

            var elapsed:* = _arg1;

            if (this.m.status != "gameover"){

                return;

            };

            this.frame.addTimer(0.8, function (){

                gameOverScreen.x = (gameOverScreen.x - (2000 * elapsed));

                if (gameOverScreen.x < 0){

                    gameOverScreen.x = 0;

                };

                gameOverScreen.alpha = (gameOverScreen.alpha + (2.5 * elapsed));

                if (gameOverScreen.alpha > 1){

                    gameOverScreen.alpha = 1;

                };

            });

        }

        private function updateGetReady(_arg1){

            if (!this.m.status){

                return;

            };

            if (this.m.status == "open"){

                if (this.m.screen.getReady.alpha < 1){

                    this.m.screen.getReady.alpha = (this.m.screen.getReady.alpha + (3 * _arg1));

                    if (this.m.screen.getReady.alpha > 1){

                        this.m.screen.getReady.alpha = 1;

                    };

                };

            };

            if (this.m.status == "play"){

                if (this.m.screen.getReady.visible){

                    this.m.screen.getReady.alpha = (this.m.screen.getReady.alpha - (3 * _arg1));

                    if (this.m.screen.getReady.alpha < 0){

                        this.m.screen.getReady.visible = false;

                    };

                };

            };

        }

        private function updateBird(){

            if (!this.game.bird){

                return;

            };

            this.game.bird.clip.x = this.game.bird.x;

            this.game.bird.clip.y = this.game.bird.y;

            this.game.bird.clip.rotation = this.game.bird.rotation;

            this.game.bird.clip.scaleX = this.game.bird.scale;

            this.game.bird.clip.scaleY = this.game.bird.scale;

            this.game.bird.clip.visible = true;

        }

        private function updateBackScroll(){

            if (this.backScroll){

                this.backScroll.x = -((this.game.virtualDistance % 23));

            };

        }

        private function updateFlashEffect(_arg1:Number){

            if (((this.flashLayer) && (this.flashLayer.visible))){

                this.flashLayer.alpha = (this.flashLayer.alpha - (6 * _arg1));

                if (this.flashLayer.alpha < 0){

                    this.flashLayer.alpha = 0;

                    this.flashLayer.visible = false;

                };

            };

        }



    }

}//package 

﻿package {

    import flash.events.*;

    import flash.display.*;

    import flash.text.*;

    import flash.geom.*;

    import lib.*;

    import flash.filters.*;

    import flash.ui.*;



    public class Game extends MovieClip {



        public var score:int;

        public var newHighScore:Boolean;

        public var virtualDistance:int;

        public var gameDistance:int;

        public var bird:Object;

        public var tubes:Array;

        public var visTubes:Array;

        public var leftTube:Object;

        public var birdOnTitle:MovieClip;

        public var birdOnTitleY = 130;

        public var backgroundIndex:int;

        public var numTubes = 1000;

        public var backSpeed = 125;

        public var birdStartX = 95;

        public var birdStartY = 210;

        public var birdUpSpeed = -2.45;

        public var birdMaxSpeed = 4;

        public var birdTurboSpeed = 3.5;

        public var birdTurboFactor = 1.05;

        public var birdAccelerate = 0.07;

        public var birdFallRotateSpeed = 13;

        public var firstTubePos = 640;

        public var tubeGap = 180;

        public var minTubeHeight = 80;

        public var gateHeight = 100;

        public var tubeWidth = 60;

        public var groundLine = 49;

        public var birdWidth = 34;

        public var birdHeight = 34;

        public var birdCollisionTop = 13;

        public var birdCollisionBottom = 10;

        public var birdCollisionHorizontal = 0.22;

        private var keyUp:Boolean;

        private var keyDown:Boolean;

        private var keyLeft:Boolean;

        private var keyRight:Boolean;

        private var m:Object;

        private var gameWidth;

        private var gameHeight;

        private var input:GInput;

        private var frame:GFrame;

        private var gsound:GSoundSimple;

        private var network:GNetwork;

        private var startTime:int;



        public function Game(_arg1:Object){

            this.m = _arg1;

            this.gameWidth = _arg1.gameWidth;

            this.gameHeight = _arg1.gameHeight;

            this.input = _arg1.input;

            this.frame = _arg1.frame;

            this.gsound = _arg1.gsound;

            this.network = _arg1.network;

        }

        public function initTubes(){

            var _local2:*;

            var _local3:*;

            var _local4:*;

            this.leftTube = null;

            this.tubes = new Array();

            var _local1:* = 0;

            while (_local1 < this.numTubes) {

                _local2 = ((this.gameHeight - this.groundLine) - (2 * this.minTubeHeight));

                _local3 = (this.minTubeHeight + (_local2 * Math.random()));

                _local4 = new Object();

                _local4.pos = (this.firstTubePos + (_local1 * this.tubeGap));

                _local4.gate = _local3;

                this.tubes.push(_local4);

                _local1++;

            };

        }

        public function initBird(){

            this.bird = new Object();

            var _local1:* = int((3 * Math.random()));

            switch (_local1){

                case 0:

                    this.bird.clip = new BirdBlue();

                    break;

                case 1:

                    this.bird.clip = new BirdRed();

                    break;

                case 2:

                    this.bird.clip = new BirdYellow();

                    break;

            };

            this.bird.clip.visible = false;

            this.bird.x = 0;

            this.bird.y = 0;

            this.bird.rotation = 0;

            this.bird.scale = 1;

            this.bird.spd = 0;

        }

        public function clickOnPlay(){

            if ((((this.bird.y < 0)) || (this.bird.crashed))){

                return;

            };

            this.bird.spd = this.birdUpSpeed;

            this.gsound.play(WingSfx);

        }

        public function reset(){

        }

        public function start(){

            this.score = 0;

            this.startTime = this.frame.getTime();

            this.virtualDistance = 0;

            this.gameDistance = 0;

            this.frame.resetTimer();

            this.keyUp = false;

            this.keyDown = false;

            this.keyLeft = false;

            this.keyRight = false;

            this.clickOnPlay();

        }

        public function fixFrame(_arg1:Number){

            var _local4:*;

            var _local2:* = this.frame.getTime();

            var _local3:* = (_local2 - this.startTime);

            if (this.m.status != "gameover"){

                if (!this.bird.crashed){

                    this.virtualDistance = int((this.backSpeed * _local3));

                };

            };

            if (this.m.status == "play"){

                if (!this.bird.crashed){

                    this.gameDistance = this.virtualDistance;

                };

                _local4 = this.score;

                this.score = int((((((this.gameDistance - this.firstTubePos) + this.birdStartX) - 15) / this.tubeGap) + 1));

                if (this.score < 0){

                    this.score = 0;

                };

                if (this.score > _local4){

                    this.gsound.play(ScoreSfx);

                };

                this.birdFrame();

                this.tubeFrame();

                if (((this.checkCollision()) && (!(this.bird.crashed)))){

                    this.gsound.play(FallSfx);

                    this.m.screen.flashEffect();

                    this.bird.crashed = true;

                };

            };

            if (this.m.status == "open"){

                this.bird.y = (this.birdStartY + (4 * Math.sin((_local2 * 9.7))));

                this.bird.x = this.birdStartX;

            };

            if (this.m.status == "title"){

                this.birdOnTitle.y = (this.birdOnTitleY + (4 * Math.sin((_local2 * 9.7))));

            };

        }

        public function update(_arg1:Number){

            if (this.m.status != "play"){

                return;

            };

        }

        public function keyEvent(_arg1:String, _arg2:Boolean){

            var _local3:*;

            switch (_arg1){

                case "up":

                    this.keyUp = _arg2;

                    break;

                case "down":

                    this.keyDown = _arg2;

                    break;

                case "left":

                    this.keyLeft = _arg2;

                    break;

                case "right":

                    this.keyRight = _arg2;

                    break;

            };

            if (_arg2){

                switch (_arg1){

                    case "up":

                        break;

                    case "down":

                        break;

                    case "left":

                        break;

                    case "right":

                        break;

                };

            };

        }

        private function tubeFrame(){

            var _local1:*;

            var _local2:*;

            var _local3:*;

            var _local4:*;

            var _local5:*;

            var _local6:*;

            if (((!(this.tubes)) || (!(this.visTubes)))){

                return;

            };

            for each (_local1 in this.visTubes) {

                _local1.clip.visible = false;

            };

            _local2 = 0;

            for each (_local3 in this.tubes) {

                _local4 = (-(this.tubeWidth) / 2);

                _local5 = (this.gameWidth + (this.tubeWidth / 2));

                _local6 = (_local3.pos - this.gameDistance);

                if ((((_local6 < _local4)) || ((_local6 > _local5)))){

                } else {

                    if (_local2 == 0){

                        this.leftTube = _local3;

                    };

                    var _temp1 = _local2;

                    _local2 = (_local2 + 1);

                    _local1 = this.visTubes[_temp1];

                    _local1.clip.visible = true;

                    _local1.clip.x = _local6;

                    _local1.clip.y = _local3.gate;

                };

            };

        }

        private function birdFrame(){

            this.bird.spd = (this.bird.spd + this.birdAccelerate);

            if (this.bird.spd > this.birdMaxSpeed){

                this.bird.spd = this.birdMaxSpeed;

            };

            if (this.bird.spd > this.birdTurboSpeed){

                this.bird.y = (this.bird.y + (this.bird.spd * this.birdTurboFactor));

            } else {

                this.bird.y = (this.bird.y + this.bird.spd);

            };

            var _local1:* = Number(this.bird.spd);

            if (_local1 < 2){

                _local1 = (_local1 * 0.4);

            } else {

                if (_local1 < 2.5){

                    _local1 = (_local1 * 0.5);

                } else {

                    if (_local1 < 3){

                        _local1 = (_local1 * 0.65);

                    } else {

                        if (_local1 < 3.5){

                            _local1 = (_local1 * 0.85);

                        };

                    };

                };

            };

            var _local2:* = (this.birdFallRotateSpeed * _local1);

            if (_local2 > 90){

                _local2 = 90;

                this.bird.clip.gotoAndStop("fall");

            } else {

                this.bird.clip.play();

            };

            if (_local2 < -25){

                _local2 = -25;

            };

            this.bird.rotation = _local2;

            var _local3:* = (((this.gameHeight - this.groundLine) - (this.birdHeight / 2)) + 5);

            if (this.bird.y > _local3){

                this.bird.y = _local3;

                _local2 = 90;

                this.bird.rotation = _local2;

                this.bird.clip.gotoAndStop("fall");

                if (!this.bird.crashed){

                    this.bird.crashed = true;

                    this.gsound.play(FallSfx);

                    this.m.screen.flashEffect();

                };

                if (_local2 == 90){

                    this.m.gameOver();

                };

            };

        }

        private function checkCollision(){

            if (!this.leftTube){

                return (false);

            };

            var _local1:* = (((this.gameDistance - this.firstTubePos) + this.birdStartX) / this.tubeGap);

            var _local2:* = Math.round(_local1);

            var _local3:* = Math.abs((_local2 - _local1));

            if ((((_local1 < -0.5)) || ((_local3 > this.birdCollisionHorizontal)))){

                return (false);

            };

            var _local4:* = (this.leftTube.gate - (this.gateHeight / 2));

            var _local5:* = (this.leftTube.gate + (this.gateHeight / 2));

            if (((((this.bird.y - this.birdCollisionTop) > _local4)) && (((this.bird.y + this.birdCollisionBottom) < _local5)))){

                return (false);

            };

            return (true);

        }



    }

}//package 

﻿package {

    import flash.text.*;



    public dynamic class GUIFont extends Font {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class BirdRed extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class ButtonTweet extends SimpleButton {



    }

}//package 

﻿package CPMStar {

    import flash.net.*;

    import flash.display.*;

    import flash.system.*;



    public class AdLoader {



        private static var cpmstarLoader:Loader;



        public static function LoadAd(_arg1:int, _arg2:int):DisplayObject{

            Security.allowDomain("server.cpmstar.com");

            var _local3 = "http://server.cpmstar.com/adviewas3.swf";

            cpmstarLoader = new Loader();

            cpmstarLoader.load(new URLRequest(((((_local3 + "?poolid=") + _arg1) + "&subpoolid=") + _arg2)));

            return (cpmstarLoader);

        }



    }

}//package CPMStar 

﻿package {

    import flash.display.*;



    public dynamic class BirdYellow extends MovieClip {



    }

}//package 

﻿package {

    import flash.media.*;



    public dynamic class FallSfx extends Sound {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class GameOverScreen extends MovieClip {



        public var buttonDownload:ButtonDownload;

        public var buttonTweet:ButtonTweet;

        public var buttonMore:ButtonScore;

        public var buttonPlay:ButtonPlay;



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class TitleScreen extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class ButtonScore extends SimpleButton {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class ButtonPlay extends SimpleButton {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class GetReady extends MovieClip {



    }

}//package 

﻿package {

    import flash.display.*;



    public dynamic class OpenScreen extends MovieClip {



    }

}//package 

﻿package com.adobe.serialization.json {



    public class JSONToken {



        private var _type:int;

        private var _value:Object;



        public function JSONToken(_arg1:int=-1, _arg2:Object=null){

            this._type = _arg1;

            this._value = _arg2;

        }

        public function get type():int{

            return (this._type);

        }

        public function set type(_arg1:int):void{

            this._type = _arg1;

        }

        public function get value():Object{

            return (this._value);

        }

        public function set value(_arg1:Object):void{

            this._value = _arg1;

        }



    }

}//package com.adobe.serialization.json 

﻿package com.adobe.serialization.json {

    import flash.utils.*;



    public class JSONEncoder {



        private var jsonString:String;



        public function JSONEncoder(_arg1){

            this.jsonString = this.convertToString(_arg1);

        }

        public function getString():String{

            return (this.jsonString);

        }

        private function convertToString(_arg1):String{

            if ((_arg1 is String)){

                return (this.escapeString((_arg1 as String)));

            };

            if ((_arg1 is Number)){

                return (((isFinite((_arg1 as Number))) ? _arg1.toString() : "null"));

            };

            if ((_arg1 is Boolean)){

                return (((_arg1) ? "true" : "false"));

            };

            if ((_arg1 is Array)){

                return (this.arrayToString((_arg1 as Array)));

            };

            if ((((_arg1 is Object)) && (!((_arg1 == null))))){

                return (this.objectToString(_arg1));

            };

            return ("null");

        }

        private function escapeString(_arg1:String):String{

            var _local3:String;

            var _local6:String;

            var _local7:String;

            var _local2 = "";

            var _local4:Number = _arg1.length;

            var _local5:int;

            while (_local5 < _local4) {

                _local3 = _arg1.charAt(_local5);

                switch (_local3){

                    case "\"":

                        _local2 = (_local2 + "\\\"");

                        break;

                    case "\\":

                        _local2 = (_local2 + "\\\\");

                        break;

                    case "\b":

                        _local2 = (_local2 + "\\b");

                        break;

                    case "\f":

                        _local2 = (_local2 + "\\f");

                        break;

                    case "\n":

                        _local2 = (_local2 + "\\n");

                        break;

                    case "\r":

                        _local2 = (_local2 + "\\r");

                        break;

                    case "\t":

                        _local2 = (_local2 + "\\t");

                        break;

                    default:

                        if (_local3 < " "){

                            _local6 = _local3.charCodeAt(0).toString(16);

                            _local7 = (((_local6.length == 2)) ? "00" : "000");

                            _local2 = (_local2 + (("\\u" + _local7) + _local6));

                        } else {

                            _local2 = (_local2 + _local3);

                        };

                };

                _local5++;

            };

            return ((("\"" + _local2) + "\""));

        }

        private function arrayToString(_arg1:Array):String{

            var _local2 = "";

            var _local3:int;

            while (_local3 < _arg1.length) {

                if (_local2.length > 0){

                    _local2 = (_local2 + ",");

                };

                _local2 = (_local2 + this.convertToString(_arg1[_local3]));

                _local3++;

            };

            return ((("[" + _local2) + "]"));

        }

        private function objectToString(_arg1:Object):String{

            var value:* = null;

            var key:* = null;

            var v:* = null;

            var o:* = _arg1;

            var s:* = "";

            var classInfo:* = describeType(o);

            if (classInfo.@name.toString() == "Object"){

                for (key in o) {

                    value = o[key];

                    if ((value is Function)){

                    } else {

                        if (s.length > 0){

                            s = (s + ",");

                        };

                        s = (s + ((this.escapeString(key) + ":") + this.convertToString(value)));

                    };

                };

            } else {

                for each (v in classInfo..*.(((name() == "variable")) || ((name() == "accessor")))) {

                    if (s.length > 0){

                        s = (s + ",");

                    };

                    s = (s + ((this.escapeString(v.@name.toString()) + ":") + this.convertToString(o[v.@name])));

                };

            };

            return ((("{" + s) + "}"));

        }



    }

}//package com.adobe.serialization.json 

﻿package com.adobe.serialization.json {



    public class JSONTokenizer {



        private var obj:Object;

        private var jsonString:String;

        private var loc:int;

        private var ch:String;



        public function JSONTokenizer(_arg1:String){

            this.jsonString = _arg1;

            this.loc = 0;

            this.nextChar();

        }

        public function getNextToken():JSONToken{

            var _local2:String;

            var _local3:String;

            var _local4:String;

            var _local1:JSONToken = new JSONToken();

            this.skipIgnored();

            switch (this.ch){

                case "{":

                    _local1.type = JSONTokenType.LEFT_BRACE;

                    _local1.value = "{";

                    this.nextChar();

                    break;

                case "}":

                    _local1.type = JSONTokenType.RIGHT_BRACE;

                    _local1.value = "}";

                    this.nextChar();

                    break;

                case "[":

                    _local1.type = JSONTokenType.LEFT_BRACKET;

                    _local1.value = "[";

                    this.nextChar();

                    break;

                case "]":

                    _local1.type = JSONTokenType.RIGHT_BRACKET;

                    _local1.value = "]";

                    this.nextChar();

                    break;

                case ",":

                    _local1.type = JSONTokenType.COMMA;

                    _local1.value = ",";

                    this.nextChar();

                    break;

                case ":":

                    _local1.type = JSONTokenType.COLON;

                    _local1.value = ":";

                    this.nextChar();

                    break;

                case "t":

                    _local2 = ((("t" + this.nextChar()) + this.nextChar()) + this.nextChar());

                    if (_local2 == "true"){

                        _local1.type = JSONTokenType.TRUE;

                        _local1.value = true;

                        this.nextChar();

                    } else {

                        this.parseError(("Expecting 'true' but found " + _local2));

                        return (null);

                    };

                    break;

                case "f":

                    _local3 = (((("f" + this.nextChar()) + this.nextChar()) + this.nextChar()) + this.nextChar());

                    if (_local3 == "false"){

                        _local1.type = JSONTokenType.FALSE;

                        _local1.value = false;

                        this.nextChar();

                    } else {

                        this.parseError(("Expecting 'false' but found " + _local3));

                        return (null);

                    };

                    break;

                case "n":

                    _local4 = ((("n" + this.nextChar()) + this.nextChar()) + this.nextChar());

                    if (_local4 == "null"){

                        _local1.type = JSONTokenType.NULL;

                        _local1.value = null;

                        this.nextChar();

                    } else {

                        this.parseError(("Expecting 'null' but found " + _local4));

                        return (null);

                    };

                    break;

                case "\"":

                    _local1 = this.readString();

                    break;

                default:

                    if (((this.isDigit(this.ch)) || ((this.ch == "-")))){

                        _local1 = this.readNumber();

                    } else {

                        if (this.ch == ""){

                            return (null);

                        };

                        this.parseError((("Unexpected " + this.ch) + " encountered"));

                        return (null);

                    };

            };

            return (_local1);

        }

        private function readString():JSONToken{

            var _local3:String;

            var _local4:int;

            var _local1:JSONToken = new JSONToken();

            _local1.type = JSONTokenType.STRING;

            var _local2 = "";

            this.nextChar();

            while (((!((this.ch == "\""))) && (!((this.ch == ""))))) {

                if (this.ch == "\\"){

                    this.nextChar();

                    switch (this.ch){

                        case "\"":

                            _local2 = (_local2 + "\"");

                            break;

                        case "/":

                            _local2 = (_local2 + "/");

                            break;

                        case "\\":

                            _local2 = (_local2 + "\\");

                            break;

                        case "b":

                            _local2 = (_local2 + "\b");

                            break;

                        case "f":

                            _local2 = (_local2 + "\f");

                            break;

                        case "n":

                            _local2 = (_local2 + "\n");

                            break;

                        case "r":

                            _local2 = (_local2 + "\r");

                            break;

                        case "t":

                            _local2 = (_local2 + "\t");

                            break;

                        case "u":

                            _local3 = "";

                            _local4 = 0;

                            while (_local4 < 4) {

                                if (!this.isHexDigit(this.nextChar())){

                                    this.parseError((" Excepted a hex digit, but found: " + this.ch));

                                    return (null);

                                };

                                _local3 = (_local3 + this.ch);

                                _local4++;

                            };

                            _local2 = (_local2 + String.fromCharCode(parseInt(_local3, 16)));

                            break;

                        default:

                            _local2 = (_local2 + ("\\" + this.ch));

                    };

                } else {

                    _local2 = (_local2 + this.ch);

                };

                this.nextChar();

            };

            if (this.ch == ""){

                this.parseError("Unterminated string literal");

                return (null);

            };

            this.nextChar();

            _local1.value = _local2;

            return (_local1);

        }

        private function readNumber():JSONToken{

            var _local1:JSONToken = new JSONToken();

            _local1.type = JSONTokenType.NUMBER;

            var _local2 = "";

            if (this.ch == "-"){

                _local2 = (_local2 + "-");

                this.nextChar();

            };

            if (!this.isDigit(this.ch)){

                this.parseError("Expecting a digit");

                return (null);

            };

            if (this.ch == "0"){

                _local2 = (_local2 + this.ch);

                this.nextChar();

                if (this.isDigit(this.ch)){

                    this.parseError("A digit cannot immediately follow 0");

                    return (null);

                };

            } else {

                while (this.isDigit(this.ch)) {

                    _local2 = (_local2 + this.ch);

                    this.nextChar();

                };

            };

            if (this.ch == "."){

                _local2 = (_local2 + ".");

                this.nextChar();

                if (!this.isDigit(this.ch)){

                    this.parseError("Expecting a digit");

                    return (null);

                };

                while (this.isDigit(this.ch)) {

                    _local2 = (_local2 + this.ch);

                    this.nextChar();

                };

            };

            if ((((this.ch == "e")) || ((this.ch == "E")))){

                _local2 = (_local2 + "e");

                this.nextChar();

                if ((((this.ch == "+")) || ((this.ch == "-")))){

                    _local2 = (_local2 + this.ch);

                    this.nextChar();

                };

                if (!this.isDigit(this.ch)){

                    this.parseError("Scientific notation number needs exponent value");

                    return (null);

                };

                while (this.isDigit(this.ch)) {

                    _local2 = (_local2 + this.ch);

                    this.nextChar();

                };

            };

            var _local3:Number = Number(_local2);

            if (((isFinite(_local3)) && (!(isNaN(_local3))))){

                _local1.value = _local3;

                return (_local1);

            };

            this.parseError((("Number " + _local3) + " is not valid!"));

            return (null);

        }

        private function nextChar():String{

            return ((this.ch = this.jsonString.charAt(this.loc++)));

        }

        private function skipIgnored():void{

            var _local1:int;

            do  {

                _local1 = this.loc;

                this.skipWhite();

                this.skipComments();

            } while (_local1 != this.loc);

        }

        private function skipComments():void{

            if (this.ch == "/"){

                this.nextChar();

                switch (this.ch){

                    case "/":

                        do  {

                            this.nextChar();

                        } while (((!((this.ch == "\n"))) && (!((this.ch == "")))));

                        this.nextChar();

                        break;

                    case "*":

                        this.nextChar();

                        while (true) {

                            if (this.ch == "*"){

                                this.nextChar();

                                if (this.ch == "/"){

                                    this.nextChar();

                                    break;

                                };

                            } else {

                                this.nextChar();

                            };

                            if (this.ch == ""){

                                this.parseError("Multi-line comment not closed");

                                return;

                            };

                        };

                        break;

                    default:

                        this.parseError((("Unexpected " + this.ch) + " encountered (expecting '/' or '*' )"));

                        return;

                };

            };

        }

        private function skipWhite():void{

            while (this.isWhiteSpace(this.ch)) {

                this.nextChar();

            };

        }

        private function isWhiteSpace(_arg1:String):Boolean{

            return ((((((((_arg1 == " ")) || ((_arg1 == "\t")))) || ((_arg1 == "\n")))) || ((_arg1 == "\r"))));

        }

        private function isDigit(_arg1:String):Boolean{

            return ((((_arg1 >= "0")) && ((_arg1 <= "9"))));

        }

        private function isHexDigit(_arg1:String):Boolean{

            var _local2:String = _arg1.toUpperCase();

            return (((this.isDigit(_arg1)) || ((((_local2 >= "A")) && ((_local2 <= "F"))))));

        }

        public function parseError(_arg1:String):void{

        }



    }

}//package com.adobe.serialization.json 

﻿package com.adobe.serialization.json {



    public class JSONTokenType {



        public static const UNKNOWN:int = -1;

        public static const COMMA:int = 0;

        public static const LEFT_BRACE:int = 1;

        public static const RIGHT_BRACE:int = 2;

        public static const LEFT_BRACKET:int = 3;

        public static const RIGHT_BRACKET:int = 4;

        public static const COLON:int = 6;

        public static const TRUE:int = 7;

        public static const FALSE:int = 8;

        public static const NULL:int = 9;

        public static const STRING:int = 10;

        public static const NUMBER:int = 11;



    }

}//package com.adobe.serialization.json 

﻿package com.adobe.serialization.json {



    public class JSONDecoder {



        private var value;

        private var tokenizer:JSONTokenizer;

        private var token:JSONToken;



        public function JSONDecoder(_arg1:String){

            this.tokenizer = new JSONTokenizer(_arg1);

            this.nextToken();

            this.value = this.parseValue();

        }

        public function getValue(){

            return (this.value);

        }

        private function nextToken():JSONToken{

            return ((this.token = this.tokenizer.getNextToken()));

        }

        private function parseArray():Array{

            var _local1:Array = new Array();

            this.nextToken();

            if (this.token == null){

                return (null);

            };

            if (this.token.type == JSONTokenType.RIGHT_BRACKET){

                return (_local1);

            };

            _local1.push(this.parseValue());

            this.nextToken();

            if (this.token == null){

                return (null);

            };

            if (this.token.type == JSONTokenType.RIGHT_BRACKET){

                return (_local1);

            };

            if (this.token.type == JSONTokenType.COMMA){

                this.nextToken();

            } else {

                this.tokenizer.parseError(("Expecting ] or , but found " + this.token.value));

                return (null);

            };

            //unresolved jump

        }

        private function parseObject():Object{

            var _local2:String;

            var _local1:Object = new Object();

            this.nextToken();

            if (this.token == null){

                return (null);

            };

            if (this.token.type == JSONTokenType.RIGHT_BRACE){

                return (_local1);

            };

            if (this.token.type == JSONTokenType.STRING){

                _local2 = String(this.token.value);

                this.nextToken();

                if (this.token == null){

                    return (null);

                };

                if (this.token.type == JSONTokenType.COLON){

                    this.nextToken();

                    _local1[_local2] = this.parseValue();

                    this.nextToken();

                    if (this.token == null){

                        return (null);

                    };

                    if (this.token.type == JSONTokenType.RIGHT_BRACE){

                        return (_local1);

                    };

                    if (this.token.type == JSONTokenType.COMMA){

                        this.nextToken();

                    } else {

                        this.tokenizer.parseError(("Expecting } or , but found " + this.token.value));

                        return (null);

                    };

                } else {

                    this.tokenizer.parseError(("Expecting : but found " + this.token.value));

                    return (null);

                };

            } else {

                this.tokenizer.parseError(("Expecting string but found " + this.token.value));

                return (null);

            };

            //unresolved jump

        }

        private function parseValue():Object{

            if (this.token == null){

                this.tokenizer.parseError("Unexpected end of input");

                return (null);

            };

            switch (this.token.type){

                case JSONTokenType.LEFT_BRACE:

                    return (this.parseObject());

                case JSONTokenType.LEFT_BRACKET:

                    return (this.parseArray());

                case JSONTokenType.STRING:

                case JSONTokenType.NUMBER:

                case JSONTokenType.TRUE:

                case JSONTokenType.FALSE:

                case JSONTokenType.NULL:

                    return (this.token.value);

                default:

                    this.tokenizer.parseError(("Unexpected " + this.token.value));

                    return (null);

            };

        }



    }

}//package com.adobe.serialization.json 

﻿package com.adobe.serialization.json {



    public class JSON {



        public static function encode(_arg1:Object):String{

            var _local2:JSONEncoder = new JSONEncoder(_arg1);

            return (_local2.getString());

        }

        public static function decode(_arg1:String){

            var _local2:JSONDecoder = new JSONDecoder(_arg1);

            return (_local2.getValue());

        }



    }

}//package com.adobe.serialization.json 

﻿package lib {

    import flash.events.*;

    import flash.net.*;

    import flash.display.*;



    public class GPlayEvent {



        public static function send(_arg1, _arg2){

            var root:* = _arg1;

            var data:* = _arg2;

            var eventFactor:* = 73;

            var d:* = new Date();

            var time:* = d.getTime();

            if ((time % eventFactor) != 0){

                return;

            };

            var req:* = new URLRequest("http://mylostgames.com/ajax/playevent");

            var vars:* = new URLVariables();

            vars.ref = data.ref;

            vars.version = ((data.version) ? data.version : "1.0");

            vars.mochi = ((data.mochi) ? 1 : 0);

            vars.factor = eventFactor;

            if (((((root) && (root.loaderInfo))) && (root.loaderInfo.loaderURL))){

                vars.url = root.loaderInfo.loaderURL;

            };

            req.data = vars;

            req.method = URLRequestMethod.GET;

            var loader:* = new URLLoader();

            loader.addEventListener(Event.COMPLETE, function (_arg1){

            });

            loader.addEventListener(IOErrorEvent.IO_ERROR, function (_arg1){

            });

            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, function (_arg1){

            });

            try {

                loader.load(req);

            } catch(error) {

            };

        }



    }

}//package lib 

﻿package lib {

    import com.adobe.serialization.json.*;

    import flash.external.*;



    public class GCookie {



        private static const FUNCTION_SETCOOKIE:String = ((((((((((((((("document.insertScript = function ()" + "{ ") + "if (document.snw_setCookie==null)") + "{") + "snw_setCookie = function (name, value, days)") + "{") + "if (days) {") + "var date = new Date();") + "date.setTime(date.getTime()+(days*24*60*60*1000));") + "var expires = '; expires='+date.toGMTString();") + "}") + "else var expires = '';") + "document.cookie = name+'='+value+expires+'; path=/';") + "}") + "}") + "}");

        private static const FUNCTION_GETCOOKIE:String = ((((((((((((((((("document.insertScript = function ()" + "{ ") + "if (document.snw_getCookie==null)") + "{") + "snw_getCookie = function (name)") + "{") + "var nameEQ = name + '=';") + "var cookieData = unescape(document.cookie);") + "var ca = cookieData.split(';');") + "for(var i=0;i < ca.length;i++) {") + "var c = ca[i];") + "while (c.charAt(0)==' ') c = c.substring(1,c.length);") + "if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);") + "}") + "return null;") + "}") + "}") + "}");



        private static var INITIALIZED:Boolean = false;



        private static function init():void{

            try {

                ExternalInterface.call(FUNCTION_GETCOOKIE);

            } catch(e) {

            };

            try {

                ExternalInterface.call(FUNCTION_SETCOOKIE);

            } catch(e) {

            };

            INITIALIZED = true;

        }

        public static function set(_arg1:String, _arg2:Object, _arg3:int):void{

            if (!INITIALIZED){

                init();

            };

            try {

                ExternalInterface.call("snw_setCookie", _arg1, _arg2, _arg3);

            } catch(e) {

            };

        }

        public static function get(_arg1:String):Object{

            var name:* = _arg1;

            if (!INITIALIZED){

                init();

            };

            try {

                return (ExternalInterface.call("snw_getCookie", name));

            } catch(e) {

                return (null);

            };

            return (null);

        }

        public static function erase(_arg1:String):void{

            if (!INITIALIZED){

                init();

            };

            try {

                ExternalInterface.call("snw_setCookie", _arg1, "", -1);

            } catch(e) {

            };

        }

        public static function saveVars(_arg1:String, _arg2:Object){

            var _local3:* = (_arg1 + "_params");

            set(_local3, JSON.encode(_arg2), 365);

        }

        public static function restoreVars(_arg1:String):Object{

            var _local4:*;

            var _local5:*;

            var _local2:* = (_arg1 + "_params");

            var _local3:* = get(_local2);

            if (_local3){

                _local4 = _local3.toString();

                if (_local4){

                    _local5 = JSON.decode(_local4);

                    if (_local5){

                        return (_local5);

                    };

                };

            };

            return (new Object());

        }



    }

}//package lib 

﻿package lib {

    import flash.events.*;

    import flash.display.*;

    import flash.text.*;



    public class GWidget {



        private var tf:TextFormat = null;

        private var textField:TextField = null;

        private var align:String = null;

        private var marginLeft:int = 0;

        private var marginRight:int = 0;

        private var marginTop:int = 0;

        private var marginBottom:int = 0;

        private var multiLine:Boolean = false;

        private var letterSpacing:int = 0;

        private var sheet:StyleSheet = null;

        private var fontClass:Font = null;

        private var fontName:String = "";

        private var fontSize:int = 0;

        private var fontColor = 0;

        private var fontAlpha:Number = 1;

        private var fontWeight:Boolean = false;

        private var embedFont:Boolean = false;

        private var mouseEnabled:Boolean = false;

        private var htmlText:Boolean = true;

        private var antiAlias:Boolean = false;

        private var antiAliasType:String = "";

        private var condenseWhite:Boolean = false;

        private var widgetStyle:Function = null;

        private var inputField:Boolean = false;

        private var ifMaxChars:int = 0;

        private var ifRestrict:String = "";



        public function GWidget(_arg1:Object=null){

            if (_arg1 === null){

                this.setFontSize(14);

                return;

            };

            if (_arg1.font != undefined){

                this.setFontClass(_arg1.font);

            };

            if (_arg1.name != undefined){

                this.setFontName(_arg1.name);

            };

            if (_arg1.color != undefined){

                this.setFontColor(_arg1.color, ((_arg1.alpha) ? _arg1.alpha : 1));

            };

            if (_arg1.size != undefined){

                this.setFontSize(_arg1.size);

            } else {

                this.setFontSize(14);

            };

            if (_arg1.weight != undefined){

                this.setFontWeight(_arg1.weight);

            };

            if (_arg1.inputField){

                this.setInputField();

            };

            if (_arg1.inputFieldMaxChars != undefined){

                this.setInputFieldMaxChars(_arg1.inputFieldMaxChars);

            };

            if (_arg1.restrictChars != undefined){

                this.setRestrictChars(_arg1.restrictChars);

            };

            if (_arg1.align != undefined){

                this.setTextAlign(_arg1.align);

            };

            if (_arg1.margin != undefined){

                if ((_arg1.margin is Number)){

                    this.setTextMargin(_arg1.margin);

                } else {

                    if ((_arg1.margin is Array)){

                        if (_arg1.margin.length == 1){

                            this.setTextMargin(_arg1.margin[0]);

                        } else {

                            if (_arg1.margin.length == 2){

                                this.setTextMargin(_arg1.margin[0], _arg1.margin[1]);

                            } else {

                                if (_arg1.margin.length == 3){

                                    this.setTextMargin(_arg1.margin[0], _arg1.margin[1], _arg1.margin[2]);

                                } else {

                                    if (_arg1.margin.length == 4){

                                        this.setTextMargin(_arg1.margin[0], _arg1.margin[1], _arg1.margin[2], _arg1.margin[3]);

                                    };

                                };

                            };

                        };

                    };

                };

            };

            if (_arg1.multiLine != undefined){

                this.setTextMultiLine(_arg1.multiLine);

            };

            if (_arg1.html != undefined){

                this.setTextHTML(_arg1.html);

            };

            if (_arg1.mouseEnabled != undefined){

                this.setMouseEnabled(_arg1.mouseEnabled);

            };

            if (_arg1.style != undefined){

                this.setStyle(_arg1.style);

            };

            if (_arg1.embed){

                this.setEmbedFont(true);

            };

            if (_arg1.antiAlias){

                this.setTextAdvancedAntiAlias(true);

            };

            if (_arg1.aaType){

                this.setTextAdvancedAntiAliasType(_arg1.aaType);

            };

            if (_arg1.letterSpacing != undefined){

                this.setTextLetterSpacing(_arg1.letterSpacing);

            };

        }

        public static function echo(_arg1:String, _arg2:Object=null, _arg3:int=0, _arg4:int=0){

            var _local5:* = new GWidget(_arg2);

            var _local6:* = _local5.print(_arg1, _arg3, _arg4);

            return (_local6);

        }

        public static function alignCenter(_arg1, _arg2, _arg3:int=0, _arg4:int=0, _arg5:int=0, _arg6:int=0){

            var _local7:* = ((_arg2.width - _arg3) - _arg5);

            var _local8:* = ((_arg2.height - _arg4) - _arg6);

            _arg1.x = (_arg3 + ((_local7 - _arg1.width) / 2));

            _arg1.y = (_arg4 + ((_local8 - _arg1.height) / 2));

        }



        public function setInputField(_arg1:Boolean=true){

            this.inputField = _arg1;

        }

        public function setInputFieldMaxChars(_arg1:int){

            this.ifMaxChars = _arg1;

        }

        public function setRestrictChars(_arg1:String){

            this.ifRestrict = _arg1;

        }

        public function setFontSize(_arg1:int, _arg2:Boolean=true){

            this.fontSize = _arg1;

            if (_arg2){

                this.setTextMargin(int((_arg1 * 0.7)));

            };

        }

        public function setFontColor(_arg1, _arg2:Number=1){

            this.fontColor = _arg1;

            this.fontAlpha = _arg2;

        }

        public function setFontWeight(_arg1:Boolean){

            this.fontWeight = _arg1;

        }

        public function setFontClass(_arg1){

            this.fontClass = new (_arg1)();

        }

        public function setFontName(_arg1:String){

            this.fontName = _arg1;

        }

        public function setEmbedFont(_arg1){

            this.embedFont = _arg1;

        }

        private function createTextFormat(){

            this.tf = new TextFormat();

            if (this.fontClass){

                this.tf.font = this.fontClass.fontName;

            } else {

                if (this.fontName){

                    this.tf.font = this.fontName;

                };

            };

            if (this.fontSize){

                this.tf.size = this.fontSize;

            };

            if (this.fontColor){

                this.tf.color = this.fontColor;

            };

            if (this.fontWeight){

                this.tf.bold = this.fontWeight;

            };

        }

        public function setTextAlign(_arg1:String){

            this.align = _arg1;

        }

        public function setTextLetterSpacing(_arg1:int){

            this.letterSpacing = _arg1;

        }

        public function setTextStyleSheet(_arg1:StyleSheet){

            this.sheet = _arg1;

        }

        public function setTextMargin(_arg1:int, _arg2:int=-1, _arg3:int=-1, _arg4:int=-1){

            if ((((((_arg2 == -1)) && ((_arg3 == -1)))) && ((_arg4 == -1)))){

                this.marginTop = _arg1;

                this.marginRight = _arg1;

                this.marginBottom = _arg1;

                this.marginLeft = _arg1;

            } else {

                if (((((!((_arg2 == -1))) && ((_arg3 == -1)))) && ((_arg4 == -1)))){

                    this.marginTop = _arg1;

                    this.marginRight = _arg2;

                    this.marginBottom = _arg1;

                    this.marginLeft = _arg2;

                } else {

                    if (((((!((_arg2 == -1))) && (!((_arg3 == -1))))) && ((_arg4 == -1)))){

                        this.marginTop = _arg1;

                        this.marginRight = _arg2;

                        this.marginBottom = _arg3;

                        this.marginLeft = _arg2;

                    } else {

                        this.marginTop = _arg1;

                        this.marginRight = _arg2;

                        this.marginBottom = _arg3;

                        this.marginLeft = _arg4;

                    };

                };

            };

        }

        public function setTextMarginLeft(_arg1:int){

            this.marginLeft = _arg1;

        }

        public function setTextMarginRight(_arg1:int){

            this.marginRight = _arg1;

        }

        public function setTextMarginTop(_arg1:int){

            this.marginTop = _arg1;

        }

        public function setTextMarginBottom(_arg1:int){

            this.marginBottom = _arg1;

        }

        public function setTextMultiLine(_arg1:Boolean){

            this.multiLine = _arg1;

        }

        public function setTextHTML(_arg1:Boolean){

            this.htmlText = _arg1;

        }

        public function setTextAdvancedAntiAlias(_arg1:Boolean){

            this.antiAlias = _arg1;

        }

        public function setTextAdvancedAntiAliasType(_arg1:String){

            (this.antiAliasType == _arg1);

        }

        public function setTextCondenseWhite(_arg1:Boolean){

            this.condenseWhite = _arg1;

        }

        public function setMouseEnabled(_arg1:Boolean){

            this.mouseEnabled = _arg1;

        }

        public function setStyle(_arg1:Function){

            this.widgetStyle = _arg1;

        }

        public function print(_arg1:String="", _arg2:int=0, _arg3:int=0):Sprite{

            this.textField = this.write(_arg1, _arg2, _arg3);

            var _local4:* = ((_arg2) ? _arg2 : ((this.textField.textWidth + this.marginLeft) + this.marginRight));

            var _local5:* = ((_arg3) ? _arg3 : ((this.textField.textHeight + this.marginTop) + this.marginBottom));

            var _local6:* = ((this.widgetStyle)!=null) ? this.widgetStyle(_local4, _local5) : null;

            var _local7:* = new Sprite();

            if (_local6){

                _local7.addChild(_local6);

            };

            _local7.addChild(this.textField);

            return (_local7);

        }

        public function getTextField(){

            return (this.textField);

        }

        public function updateText(_arg1:String){

            if (this.htmlText){

                this.textField.htmlText = _arg1;

            } else {

                this.textField.text = _arg1;

            };

        }

        private function write(_arg1:String, _arg2:int, _arg3:int):TextField{

            this.createTextFormat();

            if (this.align){

                this.tf.align = this.align;

            };

            if (this.marginLeft){

                this.tf.leftMargin = this.marginLeft;

            };

            if (this.marginRight){

                this.tf.rightMargin = this.marginRight;

            };

            if (this.letterSpacing){

                this.tf.letterSpacing = this.letterSpacing;

            };

            var _local4:* = new TextField();

            if (this.marginTop){

                _local4.y = this.marginTop;

            };

            if (this.multiLine){

                _local4.multiline = true;

                _local4.wordWrap = true;

            };

            if (_arg2){

                _local4.width = _arg2;

            };

            if (_arg3){

                _local4.height = _arg3;

            };

            if (this.sheet){

                _local4.styleSheet = this.sheet;

            } else {

                _local4.defaultTextFormat = this.tf;

            };

            _local4.alpha = this.fontAlpha;

            _local4.condenseWhite = this.condenseWhite;

            if (this.antiAlias){

                switch (this.antiAliasType){

                    case "ad_pixel":

                        _local4.antiAliasType = AntiAliasType.ADVANCED;

                        _local4.sharpness = 400;

                        _local4.gridFitType = GridFitType.PIXEL;

                        break;

                    default:

                        _local4.antiAliasType = AntiAliasType.NORMAL;

                        _local4.sharpness = 400;

                        _local4.gridFitType = GridFitType.NONE;

                };

            };

            _local4.defaultTextFormat = this.tf;

            _local4.embedFonts = this.embedFont;

            if (this.htmlText){

                _local4.htmlText = _arg1;

            } else {

                _local4.text = _arg1;

            };

            if (this.inputField){

                _local4.type = TextFieldType.INPUT;

                _local4.background = false;

                if (this.ifMaxChars){

                    _local4.maxChars = this.ifMaxChars;

                };

                if (this.ifRestrict){

                    _local4.restrict = this.ifRestrict;

                };

            } else {

                _local4.type = TextFieldType.DYNAMIC;

                _local4.mouseEnabled = this.mouseEnabled;

                if (_arg2){

                    switch (this.align){

                        case "left":

                            _local4.autoSize = TextFieldAutoSize.LEFT;

                            break;

                        case "right":

                            _local4.autoSize = TextFieldAutoSize.RIGHT;

                            break;

                        case "center":

                            _local4.autoSize = TextFieldAutoSize.CENTER;

                            break;

                        default:

                            _local4.autoSize = TextFieldAutoSize.LEFT;

                    };

                } else {

                    _local4.autoSize = TextFieldAutoSize.LEFT;

                };

            };

            return (_local4);

        }

        public function sampleWidgetStyle(_arg1:int, _arg2:int){

            var _local3:* = 3;

            var _local4:* = (_arg1 + _local3);

            var _local5:* = (_arg2 + _local3);

            var _local6:* = (-(_local3) / 2);

            var _local7:* = (_arg1 + (_local3 / 2));

            var _local8:* = (_arg2 + (_local3 / 2));

            var _local9:* = new Sprite();

            _local9.graphics.lineStyle(_local3, 0, 1, true, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.ROUND);

            _local9.graphics.moveTo(_local6, _local6);

            _local9.graphics.lineTo(_local6, _local8);

            _local9.graphics.lineTo(_local7, _local8);

            _local9.graphics.lineTo(_local7, _local6);

            _local9.graphics.lineTo(_local6, _local6);

            var _local10:* = new Sprite();

            _local10.graphics.beginFill(14708848, 0.7);

            _local10.graphics.drawRect(0, 0, (_local4 - _local3), (_local5 - _local3));

            var _local11:* = new Sprite();

            _local11.addChild(_local9);

            _local11.addChild(_local10);

            return (_local11);

        }



    }

}//package lib 

﻿package lib {

    import flash.events.*;

    import flash.display.*;



    public class GFrame extends Sprite {



        private var framecount;

        private var prevTime;

        private var realElapsed;

        private var fixElapsed;

        private var fps_timeElapsed:Number;

        private var fps_frameCount:int;

        private var fps:Number;

        private var paused;

        private var physics_frame_rate;

        private var timerList:Array;

        private var enterFrameCallback:Function;

        private var fixFrameCallback:Function;

        private var pauseCallback:Function;

        private var permanentFrameCallback:Function;



        public function GFrame(_arg1:Function=null, _arg2:Function=null, _arg3:Function=null, _arg4:Number=30){

            this.framecount = 0;

            this.prevTime = 0;

            this.reset();

            this.enterFrameCallback = _arg1;

            this.fixFrameCallback = _arg2;

            this.pauseCallback = _arg3;

            this.physics_frame_rate = _arg4;

            addEventListener(Event.ENTER_FRAME, this.enterFrame);

        }

        public function addPermanentFrame(_arg1:Function){

            this.permanentFrameCallback = _arg1;

        }

        public function destroy(){

            removeEventListener(Event.ENTER_FRAME, this.enterFrame);

        }

        public function getTime(){

            return ((this.realElapsed / 1000));

        }

        public function getFrameCount(){

            return (this.framecount);

        }

        public function getFPS(){

            return ((String(int(this.fps)) + " fps"));

        }

        public function reset(){

            this.realElapsed = 0;

            this.fixElapsed = 0;

            this.fps_timeElapsed = 0;

            this.fps_frameCount = 0;

            this.fps = 0;

            this.pause(false);

            this.resetTimer();

        }

        public function pause(_arg1:Boolean){

            if (((((_arg1) && (this.paused))) || (((!(_arg1)) && (!(this.paused)))))){

                return;

            };

            this.paused = _arg1;

            if (this.pauseCallback != null){

                this.pauseCallback(this.paused);

            };

        }

        public function isPaused(){

            return (this.paused);

        }

        public function addTimer(_arg1:Number, _arg2:Function, _arg3:int=1):Function{

            var _local5:*;

            var _local4:* = null;

            for each (_local5 in this.timerList) {

                if (!_local5.used){

                    _local4 = _local5;

                    break;

                };

            };

            if (!_local4){

                _local4 = new Object();

                this.timerList.push(_local4);

            };

            _local4.used = true;

            _local4.func = _arg2;

            _local4.time = (this.realElapsed + (1000 * _arg1));

            _local4.delay = (1000 * _arg1);

            _local4.count = _arg3;

            _local4.endless = ((_arg3)==0) ? true : false;

            return (_arg2);

        }

        public function removeTimer(_arg1:Function){

            var _local2:*;

            for each (_local2 in this.timerList) {

                if (!_local2.used){

                } else {

                    if (_local2.func == _arg1){

                        _local2.used = false;

                        break;

                    };

                };

            };

        }

        public function resetTimer(){

            this.timerList = new Array();

        }

        private function timerFrame(){

            var _local1:*;

            for each (_local1 in this.timerList) {

                if (!_local1.used){

                } else {

                    while (((((_local1.endless) || ((_local1.count > 0)))) && ((this.realElapsed >= _local1.time)))) {

                        _local1.func();

                        _local1.time = (_local1.time + _local1.delay);

                        _local1.count--;

                    };

                    if (((!(_local1.endless)) && ((_local1.count == 0)))){

                        _local1.used = false;

                    };

                };

            };

        }

        private function fixFrame(_arg1:Number){

        }

        private function stepFrame(){

            this.framecount++;

            var _local1:* = new Date();

            var _local2:* = int(_local1.time);

            var _local3:* = (_local2 - this.prevTime);

            if (this.prevTime == 0){

                this.prevTime = _local2;

                return (null);

            };

            this.prevTime = _local2;

            return (_local3);

        }

        private function calcFPS(_arg1:Number){

            this.fps_timeElapsed = (this.fps_timeElapsed + (_arg1 / 1000));

            this.fps_frameCount++;

            if (this.fps_timeElapsed > 1){

                this.fps = (this.fps_frameCount / this.fps_timeElapsed);

                this.fps_timeElapsed = 0;

                this.fps_frameCount = 0;

            };

        }

        private function enterFrame(_arg1){

            var _local2:* = this.stepFrame();

            if (_local2 === null){

                return;

            };

            this.calcFPS(_local2);

            if (this.permanentFrameCallback != null){

                this.permanentFrameCallback((_local2 / 1000));

            };

            if (this.paused){

                return;

            };

            var _local3:* = (1000 / this.physics_frame_rate);

            this.realElapsed = (this.realElapsed + _local2);

            while (this.fixElapsed < this.realElapsed) {

                if (this.fixFrameCallback != null){

                    this.fixFrameCallback((_local3 / 1000));

                };

                this.fixElapsed = (this.fixElapsed + _local3);

            };

            this.timerFrame();

            if (this.enterFrameCallback != null){

                this.enterFrameCallback((_local2 / 1000));

            };

        }



    }

}//package lib 

﻿package lib {

    import flash.events.*;

    import flash.net.*;

    import flash.display.*;

    import mx.utils.*;



    public class GNetwork {



        private var loadStartCount:int;

        private var loadFinishCount:int;

        private var auth:Boolean = false;

        private var user:String;

        private var pass:String;



        public function GNetwork(){

            this.loadStartCount = 0;

            this.loadFinishCount = 0;

        }

        public static function loadClipSimple(_arg1:String){

            var url:* = _arg1;

            var loader:* = new Loader();

            var req:* = new URLRequest(url);

            try {

                loader.load(req);

            } catch(error) {

            };

            loader.addEventListener(Event.COMPLETE, function (_arg1){

            });

            loader.addEventListener(IOErrorEvent.IO_ERROR, function (_arg1){

            });

            return (loader);

        }



        public function Auth(_arg1:String="", _arg2:String=""){

            this.auth = true;

            this.user = _arg1;

            this.pass = _arg2;

        }

        private function getRequest(_arg1){

            var _local2:*;

            var _local3:*;

            if (this.auth){

                _arg1.method = URLRequestMethod.POST;

                _arg1.data = new URLVariables("var=value");

                _local2 = new Base64Encoder();

                _local2.encode(((this.user + ":") + this.pass));

                _local3 = new URLRequestHeader("Authorization", ("Basic " + _local2.toString()));

                _arg1.requestHeaders.push(_local3);

            };

            return (_arg1);

        }

        public function gotoURL(_arg1:String, _arg2:Object=null, _arg3:String="post"){

            var _local4:* = new URLRequest(_arg1);

            if (_arg2){

                _local4.method = ((_arg3)=="post") ? URLRequestMethod.POST : URLRequestMethod.GET;

                _local4.data = _arg2;

            };

            navigateToURL(_local4);

        }

        public function loadFile(_arg1:String, _arg2:Function=null, _arg3:Function=null, _arg4:Function=null){

            var loader:* = undefined;

            var url:* = _arg1;

            var loadCompleteCallback = _arg2;

            var loadProgressCallback = _arg3;

            var loadErrorCallback = _arg4;

            this.loadStartCount++;

            loader = new URLLoader();

            var req:* = this.getRequest(new URLRequest(url));

            loader.addEventListener(Event.COMPLETE, function (_arg1){

                loadFinishCount++;

                if (loadCompleteCallback != null){

                    loadCompleteCallback(loader.data);

                };

            });

            loader.addEventListener(ProgressEvent.PROGRESS, function (_arg1){

                if (loadProgressCallback != null){

                    loadProgressCallback(_arg1);

                };

            });

            loader.addEventListener(IOErrorEvent.IO_ERROR, function (_arg1){

                if (loadErrorCallback != null){

                    loadErrorCallback(_arg1);

                };

            });

            try {

                loader.load(req);

            } catch(error) {

            };

        }

        public function loadClip(_arg1:String, _arg2=null, _arg3:Function=null, _arg4:Function=null, _arg5:Function=null){

            var loader:* = undefined;

            var url:* = _arg1;

            var layer = _arg2;

            var loadCompleteCallback = _arg3;

            var loadProgressCallback = _arg4;

            var loadErrorCallback = _arg5;

            loader = new Loader();

            var req:* = this.getRequest(new URLRequest(url));

            try {

                loader.load(req);

            } catch(error) {

            };

            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function (_arg1){

                if (loadCompleteCallback != null){

                    loadCompleteCallback(loader);

                };

            });

            loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, function (_arg1){

                if (loadProgressCallback != null){

                    loadProgressCallback(loader, _arg1);

                };

            });

            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, function (_arg1){

                if (loadErrorCallback != null){

                    loadErrorCallback(loader, _arg1);

                };

            });

            if (layer){

                layer.addChild(loader);

            };

        }

        public function ajaxRequest(_arg1:String, _arg2:URLVariables=null, _arg3="POST", _arg4:Function=null, _arg5:Function=null){

            var loader:* = undefined;

            var url:* = _arg1;

            var vars = _arg2;

            var method:String = _arg3;

            var responseCallback = _arg4;

            var loadErrorCallback = _arg5;

            var req:* = this.getRequest(new URLRequest(url));

            if (vars){

                req.data = vars;

            };

            req.method = method;

            loader = new URLLoader();

            try {

                loader.load(req);

                loader.addEventListener(Event.COMPLETE, function (_arg1){

                    if (responseCallback != null){

                        responseCallback(loader.data);

                    };

                });

                loader.addEventListener(IOErrorEvent.IO_ERROR, function (_arg1){

                    if (loadErrorCallback != null){

                        loadErrorCallback(_arg1);

                    };

                });

            } catch(error) {

            };

        }



    }

}//package lib 

﻿package lib {

    import flash.media.*;

    import flash.events.*;

    import flash.utils.*;

    import flash.geom.*;



    public class GSoundSimple {



        private var sfxSwitchCallback = null;

        private var sfxEnabled;

        private var sfxIcon = null;

        private var sfxVolume:Number = 1;

        private var fade:Object;

        private var fadeTimerDelay:Number = 0.025;

        private var soundFxGap:int = 300;

        private var music:Sound = null;

        private var musicChannels:Array;

        private var menuOverFx = null;

        private var sfxList;



        public function GSoundSimple(_arg1=true, _arg2=null){

            this.sfxList = new Object();

            super();

            this.sfxEnabled = _arg1;

            this.menuOverFx = _arg2;

            this.musicChannels = new Array();

            this.fade = new Object();

            this.fade.volume = 1;

            this.fade.active = false;

            this.fade.timer = new Timer((1000 * this.fadeTimerDelay));

            this.fade.timer.addEventListener(TimerEvent.TIMER, this.fadeEvent);

            this.fade.timer.start();

        }

        public function setSfxSwitchCallback(_arg1:Function){

            this.sfxSwitchCallback = _arg1;

        }

        public function isEnabledSfx(){

            return (this.sfxEnabled);

        }

        public function setSfxVolume(_arg1:Number){

            var _local2:*;

            this.sfxVolume = _arg1;

            for each (_local2 in this.musicChannels) {

                if (_local2.used){

                    this.updateChannelVolume(_local2.channel, true);

                };

            };

        }

        public function getSfxVolume(){

            return (this.sfxVolume);

        }

        public function setSoundFxGap(_arg1){

            this.soundFxGap = _arg1;

        }

        public function enableSfx(_arg1:Boolean, _arg2=true){

            var _local3:*;

            if (((((this.sfxSwitchCallback) && (_arg2))) && (!((_arg1 == this.sfxEnabled))))){

                this.sfxSwitchCallback(_arg1);

            };

            this.sfxEnabled = _arg1;

            for each (_local3 in this.musicChannels) {

                if (_local3.used){

                    this.updateChannelVolume(_local3.channel, true);

                };

            };

            if (this.sfxIcon){

                if (_arg1){

                    this.sfxIcon.gotoAndStop(1);

                } else {

                    this.sfxIcon.gotoAndStop(4);

                };

            };

        }

        public function addSfxIcon(_arg1){

            this.sfxIcon = new (_arg1)();

            this.sfxIcon.buttonMode = true;

            this.enableSfx(this.sfxEnabled);

            this.sfxIcon.addEventListener(MouseEvent.CLICK, this.clickSfxIcon);

            this.sfxIcon.addEventListener(MouseEvent.MOUSE_OVER, this.overSfxIcon);

            this.sfxIcon.addEventListener(MouseEvent.MOUSE_OUT, this.outSfxIcon);

            return (this.sfxIcon);

        }

        public function playMusic(_arg1, _arg2:int=0, _arg3=true){

            this.resetFade();

            this.music = new (_arg1)();

            var _local4:* = new Object();

            _local4.channel = this.music.play(_arg2, ((_arg3) ? 1000 : 1), new SoundTransform(((this.sfxEnabled) ? this.sfxVolume : 0)));

            _local4.used = true;

            this.updateChannelVolume(_local4.channel, true);

            this.musicChannels.push(_local4);

            return (_local4);

        }

        public function getMusicPosition(_arg1:Object){

            if (((!(_arg1)) || (!(_arg1.used)))){

                return (0);

            };

            return (_arg1.channel.position);

        }

        public function stopMusic(_arg1:Object){

            if (((!(_arg1)) || (!(_arg1.used)))){

                return;

            };

            _arg1.channel.stop();

            _arg1.used = false;

        }

        public function stopAllMusic(){

            var _local1:*;

            for each (_local1 in this.musicChannels) {

                if (_local1.used){

                    _local1.channel.stop();

                    _local1.used = false;

                };

            };

        }

        public function resetChannels(){

            this.stopAllMusic();

            this.musicChannels = new Array();

        }

        public function fadeMusic(_arg1:String, _arg2:Number=0.3){

            this.fade.active = true;

            if (_arg1 == "out"){

                this.fade.step = (-(this.fadeTimerDelay) / _arg2);

            } else {

                this.fade.step = (this.fadeTimerDelay / _arg2);

            };

        }

        public function play(_arg1, _arg2:Boolean=false, _arg3:int=0, _arg4:int=0):SoundChannel{

            if (!this.sfxEnabled){

                return (null);

            };

            if (!_arg4){

                _arg4 = this.soundFxGap;

            };

            var _local5:* = new Date();

            var _local6:* = getQualifiedClassName(_arg1).toString();

            if (!_arg2){

                if (((((this.sfxList) && (this.sfxList[_local6]))) && (((_local5.time - this.sfxList[_local6]) < _arg4)))){

                    return (null);

                };

                this.sfxList[_local6] = _local5.time;

            };

            var _local7:* = new (_arg1)();

            var _local8:* = _local7.play(_arg3);

            this.updateChannelVolume(_local8);

            return (_local8);

        }

        public function stop(_arg1:SoundChannel){

            if (_arg1){

                _arg1.stop();

            };

        }

        private function updateChannelVolume(_arg1:SoundChannel, _arg2:Boolean=false){

            if (_arg1){

                _arg1.soundTransform = new SoundTransform(((this.sfxEnabled) ? (this.sfxVolume * ((_arg2) ? this.fade.volume : 1)) : 0));

            };

        }

        private function clickSfxIcon(_arg1:MouseEvent){

            var _local2:*;

            this.sfxEnabled = !(this.sfxEnabled);

            if (this.sfxSwitchCallback){

                this.sfxSwitchCallback(this.sfxEnabled);

            };

            for each (_local2 in this.musicChannels) {

                if (_local2.used){

                    this.updateChannelVolume(_local2.channel, true);

                };

            };

            if (this.sfxEnabled){

                this.sfxIcon.gotoAndStop(2);

            } else {

                this.sfxIcon.gotoAndStop(3);

            };

        }

        private function overSfxIcon(_arg1:MouseEvent){

            if (this.menuOverFx){

                this.play(this.menuOverFx);

            };

            if (this.sfxEnabled){

                this.sfxIcon.gotoAndStop(2);

            } else {

                this.sfxIcon.gotoAndStop(3);

            };

        }

        private function outSfxIcon(_arg1:MouseEvent){

            if (this.sfxEnabled){

                this.sfxIcon.gotoAndStop(1);

            } else {

                this.sfxIcon.gotoAndStop(4);

            };

        }

        private function fadeEvent(_arg1:TimerEvent){

            var _local2:*;

            if (this.fade.active){

                this.fade.volume = (this.fade.volume + this.fade.step);

                if (this.fade.volume < 0){

                    this.fade.volume = 0;

                    this.fade.active = false;

                };

                if (this.fade.volume > 1){

                    this.fade.volume = 1;

                    this.fade.active = false;

                };

            };

            for each (_local2 in this.musicChannels) {

                if (_local2.used){

                    this.updateChannelVolume(_local2.channel, true);

                };

            };

        }

        private function resetFade(){

            var _local1:*;

            this.fade.active = false;

            this.fade.volume = 1;

            for each (_local1 in this.musicChannels) {

                if (_local1.used){

                    this.updateChannelVolume(_local1.channel, true);

                };

            };

        }



    }

}//package lib 

﻿package lib {

    import flash.events.*;

    import flash.display.*;

    import flash.geom.*;



    public class GInput extends Sprite {



        private var keyTable:Array;

        private var mouse:MouseEvent;

        private var dragEnabled:Boolean;

        private var dragLayer;

        private var drag:Boolean;

        private var dragStartMouse:Point;

        private var dragStartLayer:Point;

        private var dragOffset:Point;

        private var dragBound:Object;

        private var callbacks:Object;

        private var gameStage;



        public function GInput(_arg1, _arg2:Object=null){

            var _local3:*;

            super();

            this.mouse = null;

            this.dragEnabled = false;

            this.drag = false;

            this.dragLayer = null;

            this.dragBound = null;

            this.keyTable = new Array(0x0100);

            for each (_local3 in this.keyTable) {

                _local3.pressed = false;

            };

            this.callbacks = ((_arg2) ? _arg2 : new Object());

            this.gameStage = _arg1;

            this.gameStage.addEventListener(MouseEvent.MOUSE_MOVE, this.mouseMove);

            this.gameStage.addEventListener(MouseEvent.CLICK, this.mouseClick);

            this.gameStage.addEventListener(MouseEvent.MOUSE_DOWN, this.mouseDown);

            this.gameStage.addEventListener(MouseEvent.MOUSE_UP, this.mouseUp);

            this.gameStage.addEventListener(MouseEvent.MOUSE_WHEEL, this.mouseWheel);

            this.gameStage.addEventListener(Event.MOUSE_LEAVE, this.mouseLeave);

            this.gameStage.addEventListener(KeyboardEvent.KEY_DOWN, this.keyDown);

            this.gameStage.addEventListener(KeyboardEvent.KEY_UP, this.keyUp);

        }

        public function destroy(){

            this.gameStage.removeEventListener(MouseEvent.MOUSE_MOVE, this.mouseMove);

            this.gameStage.removeEventListener(MouseEvent.CLICK, this.mouseClick);

            this.gameStage.removeEventListener(MouseEvent.MOUSE_DOWN, this.mouseDown);

            this.gameStage.removeEventListener(MouseEvent.MOUSE_UP, this.mouseUp);

            this.gameStage.removeEventListener(MouseEvent.MOUSE_WHEEL, this.mouseWheel);

            this.gameStage.removeEventListener(Event.MOUSE_LEAVE, this.mouseLeave);

            this.gameStage.removeEventListener(KeyboardEvent.KEY_DOWN, this.keyDown);

            this.gameStage.removeEventListener(KeyboardEvent.KEY_UP, this.keyUp);

        }

        public function getMouse():Object{

            return (this.mouse);

        }

        public function getMouseCoord(_arg1:MouseEvent=null):Point{

            if (_arg1){

                return (new Point(_arg1.stageX, _arg1.stageY));

            };

            return (new Point(this.mouse.stageX, this.mouse.stageY));

        }

        public function setDragLayer(_arg1, _arg2:Boolean=true){

            this.dragLayer = _arg1;

            this.dragLayer.addEventListener(MouseEvent.MOUSE_DOWN, this.dragMouseDown);

            this.dragLayer.addEventListener(MouseEvent.MOUSE_UP, this.dragMouseUp);

            this.enableDrag(_arg2);

        }

        public function removeDragLayer(){

            this.dragLayer.removeEventListener(MouseEvent.MOUSE_DOWN, this.dragMouseDown);

            this.dragLayer.removeEventListener(MouseEvent.MOUSE_UP, this.dragMouseUp);

            this.enableDrag(false);

        }

        public function setDragBound(_arg1:Number, _arg2:Number, _arg3:Number, _arg4:Number){

            this.dragBound = {

                minx:_arg1,

                miny:_arg2,

                maxx:(_arg1 + _arg3),

                maxy:(_arg2 + _arg4)

            };

        }

        public function enableDrag(_arg1:Boolean=true){

            this.dragEnabled = _arg1;

        }

        public function getKey(_arg1:String){

            switch (_arg1){

                case "escape":

                    return (this.keyTable[27].pressed);

                case "enter":

                    return (this.keyTable[13].pressed);

                case "up":

                    return (this.keyTable[38].pressed);

                case "down":

                    return (this.keyTable[40].pressed);

                case "left":

                    return (this.keyTable[37].pressed);

                case "right":

                    return (this.keyTable[39].pressed);

            };

            return (null);

        }

        private function mouseMove(_arg1:MouseEvent){

            var _local2:*;

            var _local3:*;

            var _local4:*;

            this.mouse = _arg1;

            if (((((this.dragEnabled) && (this.drag))) && (this.dragLayer))){

                _local2 = this.getMouseCoord();

                this.dragOffset = _local2.subtract(this.dragStartMouse);

                _local3 = (this.dragStartLayer.x + this.dragOffset.x);

                _local4 = (this.dragStartLayer.y + this.dragOffset.y);

                if (this.dragBound){

                    if (_local3 > -(this.dragBound.minx)){

                        _local3 = -(this.dragBound.minx);

                    };

                    if (_local4 > -(this.dragBound.miny)){

                        _local4 = -(this.dragBound.miny);

                    };

                    if (_local3 < -(this.dragBound.maxx)){

                        _local3 = -(this.dragBound.maxx);

                    };

                    if (_local4 < -(this.dragBound.maxy)){

                        _local4 = -(this.dragBound.maxy);

                    };

                };

                this.dragLayer.x = _local3;

                this.dragLayer.y = _local4;

            };

            if (this.callbacks.mouseMove){

                this.callbacks.mouseMove(_arg1);

            };

        }

        private function mouseClick(_arg1:MouseEvent){

            this.mouse = _arg1;

            if (this.callbacks.mouseClick){

                this.callbacks.mouseClick(_arg1);

            };

        }

        private function mouseDown(_arg1:MouseEvent){

            this.mouse = _arg1;

            if (this.callbacks.mouseDown){

                this.callbacks.mouseDown(_arg1);

            };

        }

        private function mouseUp(_arg1:MouseEvent){

            this.mouse = _arg1;

            this.drag = false;

            if (this.callbacks.mouseUp){

                this.callbacks.mouseUp(_arg1);

            };

        }

        private function mouseWheel(_arg1:MouseEvent){

            this.mouse = _arg1;

            if (this.callbacks.mouseWheel){

                this.callbacks.mouseWheel(_arg1);

            };

        }

        private function mouseLeave(_arg1:Event){

            if (this.callbacks.mouseLeave){

                this.callbacks.mouseLeave(_arg1);

            };

        }

        private function keyDown(_arg1:KeyboardEvent){

            var _local2:* = _arg1.keyCode;

            if ((((_local2 > 0)) && ((_local2 < this.keyTable.length)))){

                this.keyTable[_local2] = {

                    pressed:true,

                    event:_arg1

                };

            };

            if (this.callbacks.keyDown){

                this.callbacks.keyDown(_arg1);

            };

        }

        private function keyUp(_arg1:KeyboardEvent){

            var _local2:* = _arg1.keyCode;

            if ((((_local2 > 0)) && ((_local2 < this.keyTable.length)))){

                this.keyTable[_local2] = {

                    pressed:false,

                    event:_arg1

                };

            };

            if (this.callbacks.keyUp){

    import flash.display.*;



    public dynamic class Medal extends MovieClip {



    }

}//package 

﻿package {

    import flash.media.*;



    public dynamic class ScoreSfx extends Sound {



    }

}//package