/**
 * Copyright mirrorboy ( http://wonderfl.net/user/mirrorboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AQHK
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    public class PerlinNoiseTest extends Sprite
    {
        private static const BASE_X:Number = 200;
        private static const BASE_Y:Number = 200;
        private static const NUM_OCTAVES:Number = 4;
        private static const RANDOM_SEED:Number = Number(new Date());
        private static const STITCH:Boolean = false;
        private static const FRACTAL:Boolean = true;
        private static const CHANNELS:uint = BitmapDataChannel.BLUE;
        private static const GRAYSCALE:Boolean = true;
        private static const OFFSET_X_RATE:Number = 2;
        private static const OFFSET_Y_RATE:Number = 5;
        
        private var _bitmapData:BitmapData;
        private var _offsets:Array;
        
        public function PerlinNoiseTest()
        {
            _bitmapData = new BitmapData( stage.stageWidth,stage.stageHeight);

            _offsets = [];
            
            for(var i:uint = 0 ; i < NUM_OCTAVES; i++){
                _offsets.push(new Point());
            }
            
            makePerlinNoise();
            
            addChild(new Bitmap(_bitmapData));
            addEventListener(Event.ENTER_FRAME,onSpriteEnterFrame);
        }
        
        private function makePerlinNoise():void{
            _bitmapData.perlinNoise(BASE_X,BASE_Y,NUM_OCTAVES,RANDOM_SEED,STITCH,FRACTAL,CHANNELS,GRAYSCALE,_offsets);
        }
        
        private function onSpriteEnterFrame(event:Event):void{
            var point:Point;
            var direction:int;
            
            for(var i:uint = 0 ; i < NUM_OCTAVES ; i++){
                point = _offsets[i] as Point;
                direction = (i%2 == 0 ) ? -1 :1;
                point.x += OFFSET_X_RATE / (NUM_OCTAVES - i ) * direction;
                point.y += OFFSET_Y_RATE / (NUM_OCTAVES - i ) * direction;
            }
            
            makePerlinNoise();
        }
    }
}