/**
 * Copyright Thumasz ( http://wonderfl.net/user/Thumasz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AQEP
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
    
        public var t:TextField;    
        public var crimes:Array;
        
        public function FlashTest() {
            // write as3 code here..
            t = new TextField();
            t.width = 800;
            t.height = 800;
            addChild(t);
            
            crimes = [
            // 1:Title, 2:Chance, 4:Hardness
                ["St10eal candy", 0, 0.1],
                ["S1teal from homeless", 0, 0.2],
                ["S2teal candy", 0, 0.5],
                ["St3eal candy", 0, 1.2],
                ["St4eal candy", 0, 2.5],
                ["St5eal candy", 0, 6],
                ["S6teal candy", 0, 14],
                ["S7teal candy", 0, 30],
                ["S8teal candy", 0, 60],
                ["S9teal candy", 0, 90],
                ["S11teal candy", 0, 100]
            ];
          
            populateCrimes();
            
            var gamePoints:int = Math.random()*1000000;
            
            for(var i:int = 0; i < crimes.length;i++){
                getOdds(i, gamePoints);
            }
           
           t.text = getCrimes(0, crimes.length);
           t.appendText(gamePoints.toString());
        }
        
        private function populateCrimes():void{
            for(var i:int = 0;i < crimes.length;i++){
                // Get Data from server, number crime-attempts
                crimes[i][1] = (Math.random()*1000)|0;
            }
        }
        
        private function getOdds(id:int, gamePoints:int):void{
            var chance:int =  ((gamePoints * 0.00001 - crimes[id][2] << 1) | 0) << 5;
            if(chance < 0){ 
                chance = 0;
            }else if(chance > 100){
                chance = 100;
            }
            crimes[id][1] = chance | 0;
        }
        
        public function getCrimes(min:int, max:int):String{
             var returnString:String = new String();
            for(var i:int = min; i < max;i++){
                returnString += "{" + crimes[i][0] + ": " + crimes[i][1] + "}\n"; 
            }
            return returnString;
        }


    }
}