/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AMkJ
 */

package  
{
	import com.bit101.components.CheckBox;
	import com.bit101.components.Panel;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * http://matrix3d.github.io/
	 * @author lizhi
	 */
	public class TestBmd extends Sprite
	{
		private var bmdSource:BitmapData;
		private var bmdSourceVec:Vector.<uint>;
		private var bmdTargetVec:Vector.<uint>;
		private var bmdTarget:BitmapData;
		private var r:Number = 100;
		private var rdis:Sprite = new Sprite;
		private var w:int = 400;
		private var h:int = w;
		private var len:int = w * h;
		private var c0:Color = new Color;
		private var c1:Color = new Color;
		private var c2:Color = new Color;
		private var c3:Color = new Color;
		private var isSmoothBtn:CheckBox;
		public function TestBmd() 
		{
			bmdSource = new BitmapData(w, h, false, 0);
			for (var x:int = 0; x < w;x++ ) {
				for (var y:int = 0; y < h; y++ ) {
					var ix:int = int(x / 10)%2;
					var iy:int = int(y / 10)%2;
					if (ix^iy) {
						bmdSource.setPixel(x, y, 0xffffff);
					}
				}
			}
			bmdSourceVec = bmdSource.getVector(bmdSource.rect);
			bmdTargetVec = new Vector.<uint>(bmdSourceVec.length);
			bmdTarget = bmdSource.clone();
			addChild(new Bitmap(bmdTarget));
			addChild(rdis);
			
			addEventListener(Event.ENTER_FRAME, enterFrame);
			
			var panel:Panel = new Panel(this);
			isSmoothBtn = new CheckBox(panel, 5, 5, "isSmooth");
			isSmoothBtn.selected = true;
			panel.setSize(isSmoothBtn.width+10, isSmoothBtn.height+10);
			//addChild(new Stats);
		}
		
		private function enterFrame(e:Event):void 
		{
			var mx:Number = mouseX;
			var my:Number=mouseY
			
			rdis.graphics.clear();
			rdis.graphics.lineStyle(0);
			//rdis.graphics.drawCircle(mx, my, r);
			for (var i:int = 0; i < len;i++ ) {
				var x:int = i % w;
				var y:int = i / w;
				var dx:Number = x - mx;
				var dy:Number = y - my;
				var d:Number = Math.sqrt(dx * dx + dy * dy);
				if (d < r) {
					var m:Number = Math.sin(Math.PI * d /r / 2);
					var cx:Number = mx + dx * m;
					var cy:Number = my + dy * m;
					if(isSmoothBtn.selected){
						bmdTargetVec[i] = smoothGetPix(cx, cy);
					}else {
						var ci:int = cx + int(cy) * w;
						if (ci >= 0 && ci < len )
						bmdTargetVec[i] = bmdSourceVec[ci];
					}
				}else {
					bmdTargetVec[i] = bmdSourceVec[i];
				}
			}
			
			bmdTarget.setVector(bmdTarget.rect, bmdTargetVec);
		}
		
		private function smoothGetPix(x:Number, y:Number):uint {
			var x0:int = x;
			var x1:int = x0 + 1;
			var y0:int = y;
			var y1:int = y + 1;
			var dx0:Number =  x - x0;
			var dx1:Number = 1 - dx0;
			var dy0:Number =  y - y0;
			var dy1:Number = 1 - dy0;
			
			c0.fromRGB();
			c1.fromRGB();
			c2.fromRGB();
			c3.fromRGB();
			
			
			if (x0>=0&&x0<w) {
				if (y0>=0&&y0<w) {
					c0.fromHex( bmdSourceVec[x0 + y0 * w]);
				}
				if (y1>=0&&y1<w) {
					c1.fromHex( bmdSourceVec[x0 + y1 * w]);
				}
			}
			if (x1>=0&&x1<w) {
				if (y0>=0&&y0<w) {
					c2.fromHex( bmdSourceVec[x1 + y0 * w]);
				}
				if (y1>=0&&y1<w) {
					c3.fromHex(bmdSourceVec[x1 + y1 * w]);
				}
			}
			c0.mulFloat(dx1).mulFloat(dy1);
			c1.mulFloat(dx1).mulFloat(dy0);
			c2.mulFloat(dx0).mulFloat(dy1);
			c3.mulFloat(dx0).mulFloat(dy0);
			c0.add(c1).add(c2).add(c3);
			c0.clamp();
			var hex:uint = c0.toHex();
			return hex;
		}
	}
}

class Color {
	public var r:uint;
	public var g:uint;
	public var b:uint;
	public function fromHex(hex:uint=0):void {
		r = (hex >> 16) & 0xff;
		g = (hex >> 8) & 0xff;
		b = hex & 0xff;
	}
	
	public function fromRGB(r:uint=0, g:uint=0, b:uint=0):Color {
		this.r = r;
		this.g = g;
		this.b = b;
		return this;
	}
	
	public function add(c:Color):Color {
		r = r + c.r;
		g = g + c.g;
		b = b + c.b;
		return this;
	}
	
	public function mulFloat(v:Number):Color {
		r *= v;
		g *= v;
		b *= v;
		return this;
	}
	
	public function clamp():Color {
		r = r & 0xff;
		g = g & 0xff;
		b = b & 0xff;
		return this;
	}
	
	public function toHex():uint {
		return (r << 16) | (g << 8) | b;
	}
}