/**
 * Copyright www0z0k ( http://wonderfl.net/user/www0z0k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AM66
 */

package {
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private const X:int = 200;
        private const Y:int = 200;
        private const R:int = 100;
        private var pointSprite:Sprite = new Sprite();
        public function FlashTest() {
            addChild(pointSprite);
            graphics.beginFill(0x0000ff, 0.4);
            graphics.lineStyle(1, 0x0000ff);
            graphics.drawCircle(X, Y, R);
            stage.addEventListener(MouseEvent.CLICK, redraw);
        }
        private function redraw(e:Event = null):void{            
            var radius:Number = 100;
            var center:Point = new Point(X, Y);
            
            //Then generate a random angle in radians from the center:
            
            var angle:Number = Math.random() * Math.PI * 2;
            
            //Then generate an effective radius of the returned point, so it'll be inside given radius. 
            //A simple Math.random()*radius won't do, because with this distribution 
            //the produces points will end up in the inner circle of half radius half of the time, 
            //but the square of that circle is a quarter of original. To create a proper distribution, 
            //the function should be like this:
            
            var rad:Number=(Math.random()+Math.random())*radius; // yes, two separate calls to random
            if (rad>radius) { rad=2*radius-rad; }
            
            //Now, get your random position:
            
            var result:Point = new Point(
                center.x + Math.cos(angle) * rad,
                center.y + Math.sin(angle) * rad
            );
            
            pointSprite.graphics.clear();
            pointSprite.graphics.beginFill(0);
            pointSprite.graphics.drawCircle(result.x, result.y, 2);
        }
    }
}