/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A8dj
 */

package {
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

            deb = new TextField();
            deb.width = 320; deb.height = 240;
            deb.mouseEnabled = false;
            addChild(deb);


            cw = 64; ch = 64;           
            mw = 8; mh = 8;
            vecGrid = new Vector.<int>(mw*mh, false);
            vecTemp = new Vector.<int>(vecGrid.length, false);

              upWall();

           
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public function onClick(e:MouseEvent):void
        {
          if (wtx < 0) { return; }   
          if (wty < 0) { return; }
          if (wtx >= mw) { return; }
          if (wty >= mh) { return; }
          
          var t:int;
          t =  vecGrid[wtx+(wty*mw)];
          vecGrid[wtx+(wty*mw)] = 1 - t;
          
          //no opt, update full map
          upWall();
        }//onclick        
        
        public function onEnter(e:Event):void
        {
            graphics.clear()
            graphics.lineStyle(2, 0); 
            
            var mx:Number;  var my:Number;
            mx = stage.mouseX;     my = stage.mouseY;         
            mx -= rendw;
            wmz = (2*my - mx)*0.5;  wmx = mx + wmz;
            wmx += camx;      wmz += camz;  
            
             drawBox(0,0,0, 512, ht, 512);  
                       
            gt  += 1;
            
            wtx = Math.floor(wmx/cw);
            wty = Math.floor(wmz/ch);
            deb.text = ""+wtx+"\n"+wty;
            
            var i:int; var k:int; var yt:int; var t:int;
            for (i = 0; i < mh; i++)
            { yt = i * mw;
             for (k = 0; k < mw; k++)
             {
               //t = vecGrid[yt+k];
               t = vecTemp[yt+k];
               if (t <= 0) { continue; }
               //drawBox2(k*cw, 0, i*ch, cw, 8+t, ch);
               drawWall(t, k*cw, 0, i*ch, cw, ht, ch);
               
             }//nextk
            }//nexti

            graphics.lineStyle(4, 0xFF, 0.5);            
            drawBox2(wtx*cw, 0, wty*ch, cw, ht, ch);
            
        }//onenter

        public function isWall(ax:int, ay:int):Boolean
        {
          if (ax < 0) { return true; }    if (ay < 0) { return true; }
          if (ax >= mw) { return true; }   if (ay >= mh) { return true; }
          return vecGrid[ax+(ay*mw)] <= 0;            
        }//iswall

        public function upWall():void
        {
            var f:int;
            var i:int; var k:int; var yt:int; var t:int;
            for (i = 0; i < mh; i++)
            { yt = i * mw;
             for (k = 0; k < mw; k++)
             {
               t = vecGrid[yt+k];
               if (t <= 0) { vecTemp[yt+k] = 0; continue; }
               f = 16;
               if (isWall(k-1, i)) { f |= 1; }
               if (isWall(k+1, i)) { f |= 2; }
               if (isWall(k, i-1)) { f |= 4; }
               if (isWall(k, i+1)) { f |= 8; }
               vecTemp[yt+k] = f;
             }//nextk
            }//nexti            
        }//upwall

        public var deb:TextField;


        public var cw:Number = 64;
        public var ch:Number = 64;
        public var ht:Number = 80;
        public var mw:int = 8;
        public var mh:int = 8;
        public var vecGrid:Vector.<int>;
        public var vecTemp:Vector.<int>;
        
        
        public var wmx:Number = 0;
        public var wmz:Number = 0;
        public var wtx:int = 0;
        public var wty:int = 0;

        public var gt:int = 0;
        
        public var rendw:Number = 465 * 0.5;
        public var rendh:Number = 465 * 0.5;

        public var camx:Number = 0;
        public var camy:Number = 0;
        public var camz:Number = 0;
        
        
        
        
        public function drawLine(ax:Number, ay:Number, az:Number,
        bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
           bx -= camx; by -= camy; bz -= camz;
    
            sx = ax - az + rendw;
            sy = (ax * 0.5) + (az * 0.5) - ay;
            graphics.moveTo(sx,sy);

            sx = bx - bz + rendw;
            sy = (bx * 0.5) + (bz * 0.5) - by;
            graphics.lineTo(sx, sy);
            
        }//drawline 
        
         public function drawBox2(ax:Number, ay:Number, az:Number,
       aw:Number, ah:Number, ad:Number):void
       {
           drawBox(ax,ay,az,ax+aw,ay+ah,az+ad);
       }//drawbox2
        
       public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox         
        
 
         public function addPlot(ax:Number, ay:Number, az:Number, move:Boolean=false):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
            sx = ax - az + rendw;
            sy = (ax * 0.5) + (az * 0.5) - ay;
            if (move) { graphics.moveTo(sx,sy); }
            else { graphics.lineTo(sx, sy); }
        }//addplot

 
       public function drawWall(f:int,ax:Number, ay:Number, az:Number,
          aw:Number, ah:Number, ad:Number):void
         {
          var bx:Number; var by:Number; var bz:Number;
          bx = ax+aw; by = ay+ah; bz= az+ad;   
 
         graphics.lineStyle();
         graphics.beginFill(0xa4a0a0, 1);            
            //drawBox2(ax,ay,az, bx,by,bz);
          addPlot(ax,ay,bz, true);
          addPlot(ax,ay,az);
          addPlot(bx,ay,az);
          addPlot(bx,ay,bz);
            /*
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, ay, az,   ax, ay, bz, true);
          drawLine(ax, ay, az,   bx, ay, az, true);

          drawLine(bx, ay, az,   bx, ay, bz, true);
          */
        graphics.endFill();
        
         graphics.lineStyle(4, 0);

         if ( (f & 4) > 0)
         {
          //drawLine(ax, by, az,   bx, by, az);
          //drawLine(ax, ay, az,   ax, by, az);
         // drawLine(bx, ay, az,   bx, by, az);
          
          graphics.beginFill(0x404070, 1);              
           addPlot(ax,by,az, true);
           addPlot(ax,ay,az);
           addPlot(bx,ay,az);
           addPlot(bx,by,az);
          
          graphics.endFill(); 
         }//endif4

        if ( (f & 1) > 0)
        {
         drawLine(ax, ay, bz,   ax, by, bz);
         drawLine(ax, by, az,   ax, by, bz);
         drawLine(ax, ay, az,   ax, by, az);        
         
          graphics.beginFill(0x403040, 1);              
           addPlot(ax,ay,bz, true);
           addPlot(ax,by,bz);
           addPlot(ax,by,az);
           addPlot(ax,ay,az);
         
          graphics.endFill();          
        }//endif1

            if ( (f & 2) > 0)
            {
              drawLine(bx, by, az,   bx, by, bz);
              drawLine(bx, ay, az,   bx, ay, bz);
               
            }//endif2
    
           if ( (f & 8) > 0)
            {
              drawLine(ax, by, bz,   bx, by, bz);
              drawLine(ax, ay, bz,   bx, ay, bz);
           
            }//endif2


      
         // drawLine(bx, ay, bz,   bx, by, bz);
          
          
             
         }//drawwall
              
        
        
        
        
    }//classend
}