/**
 * Copyright chabudai ( http://wonderfl.net/user/chabudai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A8Mf
 */

package {
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.display.Loader;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	
	import net.hires.debug.Stats;
	
	[SWF(backgroundColor="#EEEEEE", frameRate=60)]
	import flash.display.Bitmap;
	public class Main4 extends Sprite {
		
		private var camera:Camera3D;
		private var scene:Scene3D;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine;
		private var _picUrl:String = "http://assets.wonderfl.net/images/related_images/a/ac/ac83/ac839547597e54275fd6fa4d6df6ef80b22dbc99"
		private var _planeList:Array = [];
		private var loader:Loader
		
		public function Main4() {
			scene = new Scene3D();
			viewport = new Viewport3D(480, 480, true, true);
			renderer = new BasicRenderEngine();
			camera = new Camera3D();
			addChild(viewport);
			
			camera.focus = 50;
			camera.zoom = 1;
			camera.x = 2000;
			camera.y = 1100;
			camera.z = -700;
			
			var urlReq:URLRequest = new URLRequest(_picUrl);
            loader = new Loader();
            loader.load(urlReq);
            //addChild(loader);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,init);
		}
		
		private function init(e:Event = null):void {
			//メモリ表示
			addChild(new Stats());
			//addChild(loader);
			
            var bmd:BitmapData = new BitmapData(300, 300);
            bmd.draw(loader);
			var _picmaterial:BitmapMaterial = new BitmapMaterial(bmd);
			_picmaterial.doubleSided = true;
			
			for (var i:int = 0; i <= 6; i++) {
				for (var j:int = 0; j <= 8 ; j++) {
					var plane:Plane = new Plane(_picmaterial, 300, 300);
					plane.x = 480 * j;
					plane.y = 420 * i;
					scene.addChild(plane);
					_planeList.push(plane);
				}
			}
			addEventListener(Event.ENTER_FRAME, renderHandler);
			
		}
		
		private function renderHandler(e:Event):void {
			renderer.renderScene(scene, camera, viewport);
			for (var i:int = 0; i < _planeList.length; i++) {
				_planeList[i].rotationY += 2;
			}
		}
	}
	
}