/**
 * Copyright chiqui ( http://wonderfl.net/user/chiqui )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A8Fr
 */

package {
    import com.greensock.*;
    import flash.display.*;
    import flash.events.*;

    
    /**
     * generative grid
     */
    public class Main extends Sprite {
        
        public function Main():void {
            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var b:Box = new Box(this.stage.stageWidth, this.stage.stageHeight, 0, 0, this, Math.random()*0xAAAAAA, (Math.random()*0x555555)+0xAAAAAA, true);
            this.stage.addChild(b);
            this.stage.addEventListener(MouseEvent.CLICK, onClick);
            this.stage.addEventListener(MouseEvent.MOUSE_OVER, onmover);
            this.stage.addEventListener(MouseEvent.MOUSE_OUT, onmout);
        }
        
        private function onmout(e:MouseEvent):void {
            try {
                var b:Box = Box(e.target);
                TweenMax.to(b, .1, { alpha:1 } );
            }catch (e:*) { return; }
        }
        
        private function onmover(e:MouseEvent):void {
            try {
                var b:Box = Box(e.target);
                TweenMax.to(b, .1, { alpha:.5 } );
            }catch (e:*) { return; }
        }

        
        private function onClick(e:MouseEvent):void {
            try {
                var b:Box = Box(e.target);

                b.divide();
            }catch (e:*) { return; }
        }
        
    }
    
}
import com.greensock.*;
import flash.display.*;
class Box extends flash.display.Sprite {
    private var _ww:Number;
    private var _hh:Number;
    private var _ref:DisplayObjectContainer;
    private var _ca:uint;
    private var _cb:uint;
    private var _lastDiv:Boolean;
    public function Box(ww:Number, hh:Number, tx:Number, ty:Number, ref:DisplayObjectContainer, ca:uint, cb:uint, last:Boolean) {
        _ww = ww;
        _hh = hh;
        _ref = ref;
        _ca = ca;
        _cb = cb;
        _lastDiv = !last;
        this.x = tx;
        this.y = ty;
        this.graphics.beginFill(blend(_ca, _cb, Math.random()), .8);
        this.graphics.drawRect(0, 0, ww, hh);
        this.graphics.endFill();
        this.graphics.beginFill(_ca, 1);
        var px:Number = ww * 30 / ref.stage.stageWidth;
        var py:Number = hh * 30 / ref.stage.stageHeight;
        if (py < px) px = py;
        if (px < 1) px = 1;
        this.graphics.drawCircle(ww / 2, hh / 2, px);
        this.graphics.endFill();
        TweenMax.from(this, .2, { alpha:0 } );
    }
    public function divide():void {
        this.graphics.clear();
        var off:int = 0;
        var tv:int = 0;
        var b:Box;
        if (_lastDiv) {
            tv = (_hh - off) * ((Math.random()/3)+.3);
            b = new Box(_ww, tv, this.x, off+this.y, _ref,_ca,_cb, _lastDiv);
        }else {
            tv = (_ww - off) * Math.random();
            b = new Box(tv, _hh, off+this.x, this.y, _ref,_ca,_cb, _lastDiv);
        }
        off += tv;
        _ref.addChild(b);
        if (_lastDiv) {
            tv = _hh - off;
            b = new Box(_ww, tv, this.x, off+this.y, _ref,_ca,_cb, _lastDiv);
        }else {
            tv = _ww - off;
            b = new Box(tv, _hh, off+this.x, this.y, _ref,_ca,_cb, _lastDiv);
        }
        _ref.addChild(b);
        this.parent.removeChild(this);
        return;
    }
    public static function blend(first:uint, second:uint, percent:Number):uint {
        var r:int = ((first & 0xff0000) >> 16) * (1 - percent) + ((second & 0xff0000) >> 16) * percent;
        var g:int = ((first & 0x00ff00) >>  8) * (1 - percent) + ((second & 0x00ff00) >>  8) * percent;
        var b:int = ((first & 0x0000ff)      ) * (1 - percent) + ((second & 0x0000ff)      ) * percent;
        return r << 16 | g << 8 | b;
    }
}