/**
 * Copyright o_healer ( http://wonderfl.net/user/o_healer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A7zu
 */

//author Show=O=Healer

/*
　なんか「転送されてやってきました」的な演出が
　maskとfiltersで作れそうだったので作ってみた
*/

/*
　アルゴリズムの概要は以下のような感じ
　・上から徐々に見せるためのマスクを作成(m_Mask_Main)
　・それとは別に、境界線部分を発光させて見せるため、
　　コピー画像(m_CopyBitmapData)と
　　境界線だけ表示するマスク(m_Mask_Glow)を用意し、
　　filtersなどをいじることで発光させている
*/

/*
　一応、Effect_WarpAppear単体で使えるように分離してある
*/

/*
  本当は透明色ありの画像で試したいんだけど、うまくいかないのでこれで。
*/

package{
    import flash.display.*;
    import flash.events.*;

    public class FlashTest extends Sprite{
//        [Embed(source='Result.png')]
//         private static var Bitmap_Sample: Class;

        public function FlashTest(){
            var W:int = stage.stageWidth;
            var H:int = stage.stageHeight;

            //Base Graphic
            var shape:Shape = new Shape();
            {
                var g:Graphics = shape.graphics;

                g.lineStyle(5, 0x000000, 1.0);

                g.moveTo(W/2, H/2);
                for(var i:int = 0; i < 30; i++){
                    g.lineTo(W * Math.random(), H * Math.random());
                }
            }

            //Init
            {
                //Apply Effect
//                var effect:Effect_WarpAppear = new Effect_WarpAppear(new Bitmap_Sample(), 0x00FFFF, 0x4400FF);
                var effect:Effect_WarpAppear = new Effect_WarpAppear(shape, 0x00FFFF, 0x4400FF);
                addChild(effect);
            }

            //Update
            {
                var t:Number = 0;
                const TIME:Number = 10.0;
                addEventListener(Event.ENTER_FRAME, function(event:Event):void {
//*
                    //Timer
                    {
                        t += 1/24.0;
                        while(t >= TIME){t -= TIME;}
                    }

                    //Ratio
                    var ratio:Number;
                    {
                        ratio = t / TIME;
                    }

                    //Update Effect
                    effect.SetRatio(ratio);
/*/
                    //Timer
                    {
                        t += 1/24.0;
                    }

                    //Ratio
                    var ratio:Number;
                    {
                        ratio = 0.5 - 0.5*Math.cos(2*Math.PI * t / TIME);
                    }

                    //Update Effect
                    effect.SetRatio(ratio);
//*/
                });
            }
        }
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;

class Effect_WarpAppear extends Sprite{
    //==Const==

    //発光部分のメイン幅
    static public const LIGHT_W:int = 6;
    //発光部分のブラー幅
    static public const BLUR_W:int = 6;

    //==Func==

    //初期化
    public function Effect_WarpAppear(in_BaseGraphic:DisplayObject = null, in_BaseColor:uint = 0xFFFFFF, in_GlowColor:uint = 0xFFFFFF){
        Init(in_BaseGraphic, in_BaseColor, in_GlowColor);
    }

    public function Init(in_BaseGraphic:DisplayObject, in_BaseColor:uint = 0xFFFFFF, in_GlowColor:uint = 0xFFFFFF):void{
        //Check
        {
            if(in_BaseGraphic == null){
                return;
            }
        }

        //Init Param
        {
            m_BaseGraphic = in_BaseGraphic;

            m_W = m_BaseGraphic.width;
            m_H = m_BaseGraphic.height;

            m_GlowColor = in_GlowColor;
        }

        //Init Layer
        var Layer_Base:Sprite;
        var Layer_Over:Sprite;
        {
            Layer_Base = new Sprite();
            Layer_Over = new Sprite();

            addChild(Layer_Base);
            addChild(Layer_Over);
        }

        //まずはオリジナルの画像をコピー
        //m_CopyBitmapData
        {
            m_CopyBitmapData = new BitmapData(m_W, m_H, true, 0x00000000);
            m_CopyBitmapData.draw(m_BaseGraphic);
        }

        //Layer : Base : 元画像の表示レイヤー
        {
            //元画像を登録
            {
                Layer_Base.addChild(m_BaseGraphic);
            }

            //部分的に見せるためのマスクを作成
            //m_Mask_Main
            {
                //Create
                m_Mask_Main = new Shape();

                //Register
                Layer_Base.addChild(m_Mask_Main);
                Layer_Base.mask = m_Mask_Main;
            }
        }

        //Layer : Over : 境界の発光部分の表示レイヤー
        {
            //発光部分の作成
            {
                //まずはかぶせる画像を作成
                var bmp:Bitmap;
                {
                    bmp = new Bitmap(m_CopyBitmapData);//コピーした画像をそのまま使う

                    Layer_Over.addChild(bmp);//かぶせて表示（実際にはマスクで一部だけ表示）
                }

                //発光部分だけ表示するようにマスクをかける
                //m_Mask_Glow
                {
                    //Create
                    m_Mask_Glow = new Shape();

                    //Register
                    Layer_Over.addChild(m_Mask_Glow);
                    bmp.mask = m_Mask_Glow;
                }

                //表示された部分が発光して見えるようにする
                {
                    //Base
                    {//色計算の結果がBaseColorになるようにする
                        var base_r:uint = (in_BaseColor >> 16) & 0xFF;
                        var base_g:uint = (in_BaseColor >>  8) & 0xFF;
                        var base_b:uint = (in_BaseColor >>  0) & 0xFF;
                        bmp.transform.colorTransform = new ColorTransform(0,0,0,1, base_r, base_g, base_b, 0);//指定色に変更
                    }

                    //Glow
                    {//発光っぽくブラーやグローをかける
                        Layer_Over.filters = [
                            new BlurFilter(),
                            new GlowFilter(m_GlowColor, 1.0, BLUR_W, BLUR_W)
                        ];
                    }
                }
            }
        }

        //Reset Ratio
        {
            SetRatio(0);
        }
    }

    //Flag : Redraw : アニメーションするものをセットした場合、これをTrueにしておく
    public function SetRedrawFlag(in_Flag:Boolean):void{
        m_RedrawFlag = in_Flag;
    }

    //毎フレーム呼んで出現させる
    public function SetRatio(in_Ratio:Number):void{
        var g:Graphics;

        //Mask : Main
        {
            g = m_Mask_Main.graphics;

            g.clear();

            g.lineStyle(0, 0x000000, 0.0);

            g.beginFill(m_GlowColor, 1.0);
            g.drawRect(0, 0, m_W, m_H * in_Ratio);//上から徐々に見せる
            g.endFill();
        }

        //Mask : Glow
        {
            g = m_Mask_Glow.graphics;

            g.clear();

            g.lineStyle(0, 0x000000, 0.0);

            g.beginFill(m_GlowColor, 1.0);
            g.drawRect(0, m_H * in_Ratio, m_W, LIGHT_W);
            g.endFill();
        }

        //Redraw
        if(m_RedrawFlag)
        {//アニメーションなどをしてる場合を考慮する（幅の変動までは考えない）
            m_CopyBitmapData.draw(m_BaseGraphic);
        }
    }

    //==Var==

    //表示幅
    public var m_W:Number;
    public var m_H:Number;

    //出現用マスク
    public var m_Mask_Main:Shape;
    public var m_Mask_Glow:Shape;

    //元画像
    public var m_BaseGraphic:DisplayObject;
    //発光判断用コピーBitmap
    public var m_CopyBitmapData:BitmapData;

    //発光色
    public var m_GlowColor:uint = 0xFFFFFF;

    //アニメーションのように変動するものであれば、コピーを再計算するようにする
    public var m_RedrawFlag:Boolean = false;
}

