/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A7cp
 */

package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;

    [SWF(backgroundColor=0x000000, width=465, height=465)]

    public class mylazar2 extends Sprite
    {
        public var keys:Array=[];
        public var p:Player;
        public var t:Teki;
        public var b:Vector.<Beju>=new Vector.<Beju>();
        public var count:uint=0;
        public var baku:Vector.<Bakuhatu>=new Vector.<Bakuhatu>();

        public function mylazar2()
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            //this.blendMode=BlendMode.SUBTRACT;
            p=new Player(this);

            t=new Teki(this);
            t.x=stage.stageWidth / 2;
            t.y=50;
            for (var i:int=0; i < 10; i++)
                b.push(new Beju(this));
            addChild(t);
            addChild(p);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, keyUp);
        }

        private function keyUp(e:KeyboardEvent):void
        {
            keys[e.keyCode]=false;
        }

        private function keyDown(e:KeyboardEvent):void
        {
            keys[e.keyCode]=true;
        }

        public function baku_move():void
        {
            for (var i:int=0; i < baku.length; i++)
            {
                baku[i].move();
                if (baku[i].alpha <= 0)
                {
                    removeChild(baku[i]);
                    baku.splice(i--, 1);
                }
            }
        }

        private function onEnterFrame(e:Event):void
        {
            count++;
            p.move();
            t.move();
            baku_move();
            for (var i:int=0; i < 10; i++)
            {
                if (b[i].flag)
                {
                    b[i].move();
                }
            }
        }
    }
}

import flash.display.BlendMode;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.Point;
import flash.ui.Keyboard;

class Player extends Sprite
{
    private var field:mylazar2;
    public var r:Number;
    private var linesp:Sprite;
    private var lineg:Graphics;
    public var r2:Number;
    private var atan2:Number;
    private var cos:Number;
    private var sin:Number;

    public function Player(field:mylazar2)
    {
        this.field=field;
        this.x=field.stage.stageWidth / 2;
        this.y=300;
        linesp=new Sprite();
        this.addChild(linesp);
        lineg=linesp.graphics;
        draw();
    }

    private function draw():void
    {
        graphics.beginFill(0x00FF00);
        graphics.drawCircle(0, 0, 5);
        graphics.endFill();
    }

    public function move():void
    {
        if (field.keys[Keyboard.RIGHT])
            this.x+=5;
        if (field.keys[Keyboard.LEFT])
            this.x-=5;
        if (field.keys[Keyboard.UP])
            this.y-=5;
        if (field.keys[Keyboard.DOWN])
            this.y+=5;
        //lineg.clear();
        draw_line();
        if (field.keys[Keyboard.X] && field.count % 3 == 0)
        {
            for (var i:int=0; i < 10; i++)
            {
                if (!field.b[i].flag)
                {
                    field.b[i].flag=true;
                    field.b[i].init_points(this.x, this.y, r, r2);
                    //sfield.addChild(field.b[i]);
                    break;
                }
            }
        }
    }

    private function draw_line():void
    {
        atan2=Math.atan2(this.y - field.t.y, this.x - field.t.x);
        r=atan2 - Math.PI / 2;
        r2=atan2;
        //lineg.lineStyle(1, 0xFFFFFF);
        //lineg.moveTo(50 * Math.cos(r) + 30 * Math.cos(r2), 50 * Math.sin(r) + 30 * Math.sin(r2));
        //lineg.lineTo(50 * Math.cos(r + Math.PI) + 30 * Math.cos(r2), 50 * Math.sin(r + Math.PI) + 30 * Math.sin(r2));
    }
}

class Beju extends Sprite
{
    private var field:mylazar2;
    private var a:Point, b:Point, c:Point, d:Point;
    private var r:Number;
    private var rx:Number;
    private var ry:Number;
    private var t:Number=0;
    public var flag:Boolean;
    private var rate:Number=0.04;
    private var point_num:uint=1 / rate;
    private var old_rx:Number, old_ry:Number;
    private var points:Vector.<Sprite>=new Vector.<Sprite>();
    private var count:uint=0;
    private var atan2:Number;

    public function Beju(field:mylazar2)
    {
        this.field=field;
        this.flag=false;
        a=new Point();
        b=new Point();
        c=new Point();
        d=new Point();
        for (var i:int=0; i < point_num; i++)
        {
            points.push(new Sprite());
            points[i].filters=[new GlowFilter(0x0099EE, 1, 2, 2, 2), new GlowFilter(0xAAFF00, 0.8, 10, 10, 2)];
        }
    }

    //ベジュ曲線の点設定
    public function init_points(_x:Number, _y:Number, _r:Number, r2:Number):void
    {
        t=0;
        count=0;
        a.x=_x;
        a.y=_y;
        atan2=_r;
        r=Math.random() * 300 - 150;
        b.x=r * Math.cos(_r) + 150 * Math.cos(r2) + _x;
        b.y=r * Math.sin(_r) + 150 * Math.sin(r2) + _y;
        c.x=Math.random() * 300 * Math.cos(Math.random() * 2 * Math.PI) + field.t.x;
        c.y=Math.random() * 300 * Math.sin(Math.random() * 2 * Math.PI) + field.t.y;
        d.x=field.t.x;
        d.y=field.t.y;
        rx=a.x;
        ry=a.y;
    }

    public function move():void
    {
        //最終点は敵の位置にしないといけないので毎回更新してやる
        d.x=field.t.x;
        d.y=field.t.y;
        if (t <= 1)
        {
            t+=rate;
            old_rx=rx;
            old_ry=ry;
            rx=a.x * (1 - t) * (1 - t) * (1 - t) + 3 * b.x * t * (1 - t) * (1 - t) + 3 * c.x * t * t * (1 - t) + d.x * t * t * t;
            ry=a.y * (1 - t) * (1 - t) * (1 - t) + 3 * b.y * t * (1 - t) * (1 - t) + 3 * c.y * t * t * (1 - t) + d.y * t * t * t;
            draw_line();
            for (var j:int=0; j < 2; j++)
            {
                var k:Bakuhatu=new Bakuhatu(rx, ry);
                field.baku.push(k);
                field.addChild(field.baku[field.baku.length - 1]);
            }
            count++;
        }
        else
        {
            this.flag=false;
            for (var i:int=0; i < 15; i++)
            {
                var b:Bakuhatu=new Bakuhatu(field.t.x, field.t.y);
                field.baku.push(b);
                field.addChild(field.baku[field.baku.length - 1]);
            }
        }

    }

    private function draw_line():void
    {
        points[count].graphics.moveTo(old_rx, old_ry);
        points[count].graphics.lineStyle(1, 0xFFFFFF, 1, true, "none", "round");
        points[count].graphics.lineTo(rx, ry);
        points[count].addEventListener(Event.ENTER_FRAME, lineFrame);
        field.addChild(points[count]);
    }

    private function lineFrame(e:Event):void
    {
        e.currentTarget.alpha-=0.1;
        if (e.currentTarget.alpha < 0)
        {
            e.currentTarget.graphics.clear();
            e.currentTarget.alpha=1;
            field.removeChild(DisplayObject(e.currentTarget));
            e.currentTarget.removeEventListener(Event.ENTER_FRAME, lineFrame);
        }
    }


}

class MyLines extends Sprite
{
    public var count:uint=0;
    private var rx:Number;
    private var ry:Number;

    public function MyLines(_rx:Number, _ry:Number)
    {
        rx=_rx;
        ry=_ry;
        addEventListener(Event.ENTER_FRAME, enterFrame);
    }

    public function draw():void
    {

    }

    private function enterFrame(e:Event):void
    {

    }
}

class Teki extends Sprite
{
    private var field:mylazar2;
    private var count:uint=0;

    public function Teki(field:mylazar2)
    {
        this.field=field;

        draw();
    }

    private function draw():void
    {
        graphics.beginFill(0xFF0000);
        graphics.drawCircle(0, 0, 5);
        graphics.endFill();
    }

    public function move():void
    {
        count+=1;
        this.x=200 * Math.cos(Math.PI * count / 360) + field.stage.stageWidth / 2;
        this.y=200 * Math.sin(Math.PI * count / 360) + field.stage.stageHeight / 2;
    }
}


class Bakuhatu extends Sprite
{
    public var to_x:Number;
    public var to_y:Number;
    public function Bakuhatu(_x:Number, _y:Number)
    {
        this.filters=[new GlowFilter(0xFFCC00, 1, 8, 8, 4)];
        this.blendMode=BlendMode.ADD;
        graphics.beginFill(0xFFFFFF, 1);
        graphics.drawCircle(_x, _y, Math.random()*2+0.1);
        graphics.endFill();
        this.to_x=Math.random() * 60 - 30;
        this.to_y=Math.random() * 60 - 30;
    }

    public function move():void
    {
        this.x+=(this.to_x - this.x) / 8;
        this.y+=(this.to_y - this.y) / 8;
        this.alpha-=0.2;
    }
}













