/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A7OX
 */

// forked from clockmaker's 3D Flow Simulation with Field of Blur
// forked from clockmaker's 3D Flow Simulation
// forked from clockmaker's Interactive Liquid 10000
// forked from clockmaker's Liquid110000 By Vector
// forked from munegon's forked from: forked from: forked from: forked from: Liquid10000
// forked from Saqoosha's forked from: forked from: forked from: Liquid10000
// forked from nutsu's forked from: forked from: Liquid10000
// forked from nutsu's forked from: Liquid10000
// forked from zin0086's Liquid10000
package 
{
    /**
     * 矢印がいっぱいなんだけど、高速なデモ
     * 画質はディフォルトの StageQuality.HIGH で
     * 矢印 1000個
     * @author Yasu
     */
     
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.URLRequest;
    import flash.utils.*;
    import flash.system.Security;
    
    
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF")]
    public class BatFly extends Sprite {
        private const NUM_PARTICLE:uint = 70;
        private const ROT_STEPS:int = 240;
        
        private var forceMap:BitmapData = new BitmapData( 233, 233, false, 0x000000 );
        private var randomSeed:uint = Math.floor( Math.random() * 0xFFFF );
        private var particleList:Vector.<Arrow> = new Vector.<Arrow>(NUM_PARTICLE, true);
        private var rect:Rectangle = new Rectangle( 0, 0, 465, 465 );
        private var seed:Number = Math.floor( Math.random() * 0xFFFF );
        private var offset:Array = [new Point(), new Point()];
        private var timer:Timer;
        private var world:Sprite = new Sprite();
        private var rotArr:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true);
        
        ///////
        private var BatImgArray:Array = new Array();
        private var ImgDomain:String = "http://swimmingbird.heteml.jp/wonderfl/assets/";
        private var BatImages:Array = [
        	"bat/Bat20001.png", "bat/Bat20001.png", "bat/Bat20001.png", "bat/Bat20001.png", 
        	"bat/Bat20002.png", "bat/Bat20003.png", "bat/Bat20004.png", "bat/Bat20005.png", 
        	"bat/Bat20006.png", "bat/Bat20007.png", "bat/Bat20008.png", "bat/Bat20009.png",
        	"bat/Bat20010.png" 
        ];
        private var batCounter:int = 0;
        private var posList:Array = [{x:0, y:3},{x:0, y:4},{x:0, y:5},{x:0, y:6},{x:0, y:7},{x:1, y:2},{x:1, y:3},{x:1, y:4},{x:1, y:5},{x:1, y:6},{x:1, y:7},{x:1, y:8},{x:2, y:1},{x:2, y:2},{x:2, y:3},{x:2, y:4},{x:2, y:5},{x:2, y:6},{x:2, y:7},{x:2, y:8},{x:3, y:1},{x:3, y:2},{x:3, y:3},{x:3, y:4},{x:3, y:5},{x:3, y:6},{x:3, y:7},{x:3, y:8},{x:3, y:9},{x:4, y:0},{x:4, y:1},{x:4, y:2},{x:4, y:3},{x:4, y:4},{x:4, y:5},{x:4, y:6},{x:4, y:7},{x:4, y:8},{x:4, y:9},{x:5, y:1},{x:5, y:2},{x:5, y:3},{x:5, y:4},{x:5, y:5},{x:5, y:6},{x:5, y:7},{x:5, y:8},{x:5, y:9},{x:6, y:1},{x:6, y:2},{x:6, y:3},{x:6, y:4},{x:6, y:5},{x:6, y:6},{x:6, y:7},{x:6, y:8},{x:6, y:9},{x:7, y:2},{x:7, y:3},{x:7, y:4},{x:7, y:5},{x:7, y:6},{x:7, y:7},{x:7, y:8},{x:8, y:3},{x:8, y:4},{x:8, y:5},{x:8, y:6},{x:8, y:7}];
        

        public function BatFly() {
            Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
            loadBats();
        }

        private function loadBats():void {
        	var i:int;
        	for(i=0; i<BatImages.length; i++) {
        		var loader:Loader = new Loader();
        		var sp:Sprite = new Sprite();
        		sp.addChild(loader);
        		BatImgArray.push(sp);
        		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComp);
        		loader.load(new URLRequest(ImgDomain+BatImages[i]));
        	}
        }
        private function loadComp(event:Event):void {
        	if(batCounter==BatImages.length-1) {
        		init();
        	} else {
        		batCounter++;
        	}
        }
        
        private function init():void {
        	stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 60;
            
            addChild(world);
            
            // フォースマップの初期化をおこないます
            resetFunc();
            
            // ループ処理
            addEventListener( Event.ENTER_FRAME, loop );
            
            // 時間差でフォースマップと色変化の具合を変更しています
            var timer:Timer = new Timer(1000)
            timer.addEventListener(TimerEvent.TIMER, resetFunc);
            timer.start();
            
            // 矢印をプレレンダリング
            var dummy:Sprite = new Sprite();
            dummy.graphics.beginFill(0xFFFFFF, 1);
            dummy.graphics.lineStyle(1, 0x0, 1);
            dummy.graphics.moveTo(2, 4);
            dummy.graphics.lineTo(8, 4);
            dummy.graphics.lineTo(8, 0);
            dummy.graphics.lineTo(20, 7);
            dummy.graphics.lineTo(8, 14);
            dummy.graphics.lineTo(8, 10);
            dummy.graphics.lineTo(2, 10);
            dummy.graphics.lineTo(2, 4);
            
            var matrix:Matrix;
            var i:int = ROT_STEPS;
            while (i--)
            {
                matrix = new Matrix();
                matrix.translate( -75, -35);
                matrix.rotate( ( 360 / ROT_STEPS * i + 90)* Math.PI / 180);
                var scaleNum:Number = 0.3;
//                var scaleNum:Number = 0.1 + 0.2 * Math.abs( Math.cos(360 / ROT_STEPS * i) ); 
                matrix.scale( scaleNum, scaleNum );
                matrix.translate( 75, 35 );
                
                rotArr[i] = new BitmapData(150, 150, true, 0x0);
//                rotArr[i].draw(dummy, matrix);
                rotArr[i].draw(BatImgArray[i%10], matrix);
                
            }
            
            // パーティクルを生成します
            for (i = 0; i < NUM_PARTICLE; i++) {
                var px:Number = Math.random() * 465;
                var py:Number = Math.random() * 465;
                particleList[i] = new Arrow(px, py);
                world.addChild(particleList[i]);
            }
            
        }
        
        
        private function loop( e:Event ):void {
            
            var len:uint = particleList.length;
            var col:Number;
            
            for (var i:uint = 0; i < len; i++) {
                
                var arrow:Arrow = particleList[i];
                
                var oldX:Number = arrow.ox;
                var oldY:Number = arrow.oy;
                
                if(!arrow.isMass) {
	                col = forceMap.getPixel( arrow.x >> 1, arrow.y >> 1);
	                arrow.ax += ( (col      & 0xff) - 0x80 ) * .0005;
	                arrow.ay += ( (col >> 8 & 0xff) - 0x80 ) * .0005;
	                arrow.vx += arrow.ax;
	                arrow.vy += arrow.ay;
	                arrow.x += arrow.vx;
	                arrow.y += arrow.vy;
                }
                var _posX:Number = arrow.x;
                var _posY:Number = arrow.y;
                
                var rot:Number = - Math.atan2((_posX - oldX), (_posY - oldY)) * 180 / Math.PI + 90;
                var angle:int = rot / 360 * ROT_STEPS | 0;
                // Math.absの高速化ね
                angle = (angle ^ (angle >> 31)) - (angle >> 31);
                arrow.rot += (angle - arrow.rot) * 0.2;
                arrow.bitmapData = rotArr[arrow.rot];
                
                //if(!arrow.isMass) {
	                arrow.ax *= .96;
	                arrow.ay *= .96;
	                arrow.vx *= .92;
	                arrow.vy *= .92;
                //}
                // あと配置座標を整数化しておきます
                arrow.x = arrow.x | 0;
                arrow.y = arrow.y | 0;
                
                arrow.ox = arrow.x;
                arrow.oy = arrow.y;
                
                ( _posX > 465 ) ? arrow.x = 0 :
                    ( _posX < 0 ) ? arrow.x = 465 : 0;
                ( _posY > 465 ) ? arrow.y = 0 :
                    ( _posY < 0 ) ? arrow.y = 465 : 0;
            }
        }
        
        private function resetFunc(e:Event = null):void{
            forceMap.perlinNoise(117, 117, 3, seed, false, true, 6, false, offset);
            
            offset[0].x += 1.5;
            offset[1].y += 1;
            seed = Math.floor( Math.random() * 0xFFFFFF );
        }
    }
}

import flash.display.*;
import flash.geom.Point;
import caurina.transitions.Tweener;
import caurina.transitions.Equations;
import caurina.transitions.properties.CurveModifiers;

class Arrow extends Bitmap
{
    public var rot:int = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var ox:Number = 0;
    public var oy:Number = 0;
	
	private var targetPt:Point = new Point(0,0);
	private var tailPt:Point = new Point(0,0);
	private var middlePt:Point = new Point(0,0);
	private var nextPt:Point = new Point(0,0);
	
	public var isMass:Boolean = false;
	private var delayTime:Number;
	
    function Arrow( x:Number, y:Number) {
        this.x = x;
        this.y = y;
        CurveModifiers.init();
    }
    
    //目標の位置に移動するメソッド
    public function moveWithVector(tx:Number, ty:Number):void {
    	
    	isMass = true;
    	
    	targetPt.x = tx;
    	targetPt.y = ty;
    	
    	decideTails(targetPt,180,465*Math.random(), 465*Math.random());
    	gotoTargetR();
    }
    private function decideTails(target:Point, r:Number,_x:Number,_y:Number):void {
    	var tailRad:Number = 100;
    	//しっぽ
    	tailPt.x = target.x - tailRad * Math.cos(r*Math.PI/180);
    	tailPt.y = target.y - tailRad * Math.sin(r*Math.PI/180);
    	//次ステップ
    	nextPt.x = this.x + this.vx;
    	nextPt.y = this.y + this.vy;
    	//中間点
    	var dx:Number = tailPt.x - nextPt.x;
    	var dy:Number = tailPt.x - nextPt.y;
    	var nR:Number = Math.atan2(dy, dx);
    	var distance:Number = Math.sqrt(dx*dx+dy*dy);
    	middlePt.x = nextPt.x + (tailPt.x-nextPt.x)/2 + distance*0.25*Math.cos(nR+90*Math.PI/180);
    	middlePt.y = nextPt.y + (tailPt.y-nextPt.y)/2 + distance*0.25*Math.sin(nR+90*Math.PI/180);
    	this.vx = 100 * Math.cos(90*Math.PI/180);
    	this.vy = 100 * Math.sin(90*Math.PI/180);
    }
    private function gotoTargetR():void {
    	var bz:Array = [
    		{x:nextPt.x,y:nextPt.y},{x:middlePt.x,y:middlePt.y},{x:tailPt.x,y:tailPt.y}
    	];
    	Tweener.addTween(this, {x:targetPt.x, y:targetPt.y, _bezier:bz, time:1, transition:Equations.easeOutQuint});
    }
}