/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A78L
 */

package {

    import com.bit101.components.HSlider;
    import com.bit101.components.PushButton;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    
    public class Pratice0815 extends Sprite {
    
        public var W : int = 465;
        public var H : int = 465;
        public var MIN_SIZE : int = 5;
        public var MAX_LENGTH : Number;
        public var bmpd    : BitmapData;
        public var bmpdFilled : BitmapData;
        public var spContainer : Sprite = new Sprite;
        public var imgLoader : ImageLoader;
        
        public var slider0 : HSlider;
        public var slider1 : HSlider;
      
        public function Pratice0815() {
            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        
        public function init(e:Event=null) : void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addChild(spContainer);
            
            imgLoader = new ImageLoader(__loaded);
            bmpdFilled = new BitmapData(W, H, true, 0);
            MAX_LENGTH = lengthOfColor(0xFFFFFF);
            
            slider0 = new HSlider(this, 5, 35, clear);
            slider1 = new HSlider(this, 5, 55, clear);
            slider0.value = 50;
            slider1.value = 50;
            
            var btnImg:PushButton = new PushButton(this, 5, 5, "Load Image", __onSelect);
            addEventListener(Event.ENTER_FRAME, __loop);
        }
        
        
        private function __onSelect(e:MouseEvent=null) : void { imgLoader.browse(); }
        
        private function __loaded() : void {
            clear();
            if(bmpd == null) bmpd = new BitmapData(W, H, false, 0);
            else bmpd.fillRect(bmpd.rect, 0);
            
            var scale:Number = W / imgLoader.bitmapData.width;
            var mtx:Matrix = new Matrix;
            mtx.scale(scale, scale);
            var ty:Number = (imgLoader.bitmapData.height * scale - H) * .5;
            mtx.ty = -ty;
            bmpd.draw(imgLoader.bitmapData, mtx);
        }
        
        
        private function __loop(e:Event) : void {
            if(bmpd == null) return;
            var i : int =0;
            while(i++ < 10) render();
        }
        
        
        public function render() : void {
            var p:Point;
            var count : int = 0;
            do {
                p = new Point(Math.random() * (W-2), Math.random() * (H-2));
                count ++;
            }while(bmpdFilled.getPixel32(p.x, p.y) != 0x00000000 && count < 100);
            
            parseBitmap(new Rectangle(p.x, p.y, MIN_SIZE, MIN_SIZE));
        }
        
        
        public function clear(e:Event=null) : void {
            bmpdFilled.fillRect(bmpdFilled.rect, 0);
            spContainer.graphics.clear();
        }
        
        
        public function parseBitmap(rect:Rectangle) : void {
            if(rect.left < 0 || rect.top < 0 || rect.right > W || rect.bottom > H ) {
                if( rect.width != MIN_SIZE) fillBitmap(rect);
                return;
            }
            
            var v0:Number = getValueFromRectangle(bmpd, new Rectangle(rect.x, rect.y, rect.width/2, rect.height/2));
            var v1:Number = getValueFromRectangle(bmpd, new Rectangle(rect.x+rect.width/2, rect.y, rect.width/2, rect.height/2));
            var v2:Number = getValueFromRectangle(bmpd, new Rectangle(rect.x, rect.y+rect.height/2, rect.width/2, rect.height/2));
            var v3:Number = getValueFromRectangle(bmpd, new Rectangle(rect.x+rect.width/2, rect.y+rect.height/2, rect.width/2, rect.height/2));
            var min:Number = Math.min(v0, v1, v2, v3);
            var max:Number = Math.max(v0, v1, v2, v3);
            
            var THRESHOLD : Number = slider0.value / 100 * 100 + 5;
            var sMax:Number = slider1.value / 100 * 100 + 5;
            if( !isFilled(rect) ) {
                if(max - min > THRESHOLD && rect.width < sMax ) {
                    rect.inflate(1, 1);
                    parseBitmap( rect );
                } else {
                    fillBitmap(rect);
                }
            }
        }
        
        
        public function isFilled(rect:Rectangle) : Boolean {
            return bmpdFilled.histogram(rect)[3][0] != rect.width * rect.height;
        }
        
        
        public function fillBitmap(rect:Rectangle) : void {
            var color : uint = getColorFromRectangle(bmpd, rect);
            var l:Number = lengthOfColor(color)/MAX_LENGTH;
            spContainer.graphics.beginFill(0xFFFFFF, 1);
            spContainer.graphics.drawCircle(rect.x + rect.width/2, rect.y + rect.height/2, l*rect.width*.5);
            spContainer.graphics.endFill();
            bmpdFilled.fillRect(rect, 0xFF990000);
        }
        
        
        public static function getColorFromRectangle(source:BitmapData, rect:Rectangle) : uint {
            var hist:Vector.<Vector.<Number>> = source.histogram(rect); 
            var vecRed:Vector.<Number> = hist[0];
            var vecGreen:Vector.<Number> = hist[1];
            var vecBlue:Vector.<Number> = hist[2];
            var area:Number = Math.ceil(rect.width) * Math.ceil(rect.height);
            
            var r:Number = (histSum(vecRed) / area) & 0xFF;
            var g:Number = (histSum(vecGreen) / area) & 0xFF;
            var b:Number = (histSum(vecBlue) / area) & 0xFF;
            
            return (r << 16 | g << 8 | b);
        }
        
        
        public static function getValueFromRectangle(source:BitmapData, rect:Rectangle) : Number {
            var hist:Vector.<Vector.<Number>> = source.histogram(rect); 
            var vecRed:Vector.<Number> = hist[0];
            var vecGreen:Vector.<Number> = hist[1];
            var vecBlue:Vector.<Number> = hist[2];
            var area:Number = rect.width * rect.height;
            
            var r:Number = histSum(vecRed) / area;
            var g:Number = histSum(vecGreen) / area;
            var b:Number = histSum(vecBlue) / area;
            
            return Math.sqrt(r*r + g*g + b*b);
        }
        
        
        public static function histSum(v:Vector.<Number>) : Number {
            var total:Number = 0;
            for ( var i : int = 0; i<v.length; i++) {
                total += v[i] * i;
            }
            return total;
        }
        
        
        public static function lengthOfColor(color:uint) : Number {
            var o:Object = getRGB(color);
            
            return Math.sqrt(o.r * o.r + o.g * o.g + o.b * o.b);
            return 0;
        }
        
        
        public static function getRGB(pixelValue:uint) : Object {
            var red:uint = pixelValue >> 16 & 0xFF;
            var green:uint = pixelValue >> 8 & 0xFF;
            var blue:uint = pixelValue & 0xFF;
            
            return {r:red, g:green, b:blue};
        }
    }
}







import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.net.FileFilter;
import flash.net.FileReference;


class ImageLoader {
    
    public var fileRef:FileReference;
    public var callBack:Function;
    public var bitmapData:BitmapData;
    
    public function ImageLoader(_callBack:Function) : void {
        fileRef = new FileReference();
        callBack = _callBack;
    }
    
    
    public function browse() : void {
        fileRef.browse([new FileFilter("Images", "*.jpg;*.png")]);
        fileRef.addEventListener(Event.SELECT, _onSelected);
        fileRef.addEventListener(Event.COMPLETE, _onLoaded);
    }
    
    
    protected function _onSelected(e:Event) : void {
        fileRef.load();
    }
    
    
    protected function _onLoaded(e:Event) : void {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onImageLoaded);
        loader.loadBytes(fileRef.data);
    }
    
    
    protected function _onImageLoaded(e:Event) : void {
        bitmapData = Bitmap(e.target.content).bitmapData;
        callBack();
    }
    
    
    
}