/**
 * Copyright aznFanBoy ( http://wonderfl.net/user/aznFanBoy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A6if
 */

package {
  import flash.display.Sprite;
  import flash.display.Graphics
  import flash.filters.BlurFilter
  import flash.display.StageScaleMode
  
  import flash.events.Event
  import flash.events.MouseEvent
  import fl.transitions.TweenEvent
  
  import fl.transitions.Tween
  import fl.transitions.easing.Strong
  
  [SWF(backgroundColor=0xFFFFFF, width=465, height=465, frameRate=60)]
    
  public class resize extends Sprite {

    
    public var ldr:Sprite = new Sprite()
    public var bar_length:uint = 20
    public var bar_height:uint = 20
    
    private var blur:BlurFilter = new BlurFilter()
    private var tween_x:Tween
    private var tween_y:Tween
    
    public function resize() {
      init()
      StageScaleMode.NO_SCALE
    }
    
    private function init():void {
      
      ldr.graphics.moveTo(0, 0)
      ldr.graphics.beginFill(0x38CBF5)
      ldr.graphics.lineTo(bar_length, 0)
      ldr.graphics.lineTo(bar_length, bar_height)
      ldr.graphics.lineTo(0, bar_height)
      ldr.graphics.lineTo(0, 0)
      ldr.graphics.endFill()
      
      ldr.x = Math.round((stage.stageWidth - ldr.width)/2)
      ldr.y = Math.round((stage.stageHeight - ldr.height)/2)
      addChild(ldr)
      
      stage.addEventListener(MouseEvent.MOUSE_DOWN, motion)
      stage.addEventListener(Event.MOUSE_LEAVE, reset)
      tween_x.addEventListener(TweenEvent.MOTION_CHANGE, update_x)
      tween_y.addEventListener(TweenEvent.MOTION_CHANGE, update_y)
    }
    
    private function update_x(event:TweenEvent):void {
      blur.blurX = Math.abs(Math.round(mouseX - ldr.x))
      ldr.filters = [blur]
    }
    
    private function update_y(event:TweenEvent):void {
      blur.blurY = Math.abs(Math.round(mouseY - ldr.y))
      ldr.filters = [blur]
    }

    private function reset(event:Event):void {
      tween_x = new Tween(ldr, "x", Strong.easeOut, ldr.x, Math.round((stage.stageWidth - ldr.width)/2), 0.7, true)
      tween_y = new Tween(ldr, "y", Strong.easeOut, ldr.y, Math.round((stage.stageHeight - ldr.height)/2), 0.7, true)
    }

    private function motion(event:MouseEvent):void {
      tween_x = new Tween(ldr, "x", Strong.easeOut, ldr.x, Math.round(mouseX - ldr.width/2), 0.7, true)
      tween_y = new Tween(ldr, "y", Strong.easeOut, ldr.y, Math.round(mouseY - ldr.height/2), 0.7, true)
    }
  }
}