/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A6ex
 */

/*

colourlovers.comからカラーパレットを取得

↓ここからカラーパレットを取得。
http://ja-jp.colourlovers.com/

 * */

package 
{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.text.TextField;
    import flash.filters.DropShadowFilter;
    
    /**
     * ...
     * @author umhr
     */
    public class Main4 extends Sprite 
    {
        private var myText:TextField = new TextField();
        public function Main4():void 
        {
            var myLoader:URLLoader = new URLLoader();
            myLoader.addEventListener (Event.COMPLETE,COMPLETE);
            myLoader.load(new URLRequest("http://www.colourlovers.com/api/palettes/new"));
        }
           
        private function COMPLETE(e:Event):void 
        {
            var xml:XML = new XML(e.currentTarget.data);
            var _length:int = xml.palette.length();
            for (var i:int = 0; i < _length; i++) {
                for (var j:int = 0; j < 5; j++) {
                    var sp:Sprite = new Sprite();
                    sp.name = "0x"+xml.palette[i].colors.hex[j]+"\n by:"+xml.palette[i].userName;
                    sp.graphics.beginFill(int("0x"+xml.palette[i].colors.hex[j]));
                    sp.graphics.drawRect(j*465/5,(stage.stageHeight/_length)*i,465/5,(stage.stageHeight/_length));
                    sp.addEventListener(MouseEvent.MOUSE_MOVE,MOUSE_MOVE);
                    addChild(sp);
                }
            }
            myText.width = 150;
            myText.height = 40;
            myText.selectable = false;
            myText.filters = [new DropShadowFilter(0,45,0)]
            myText.textColor = 0xFFFFFF;
            addChild(myText);
        }
        private function MOUSE_MOVE(e:Event):void {
            myText.text = e.currentTarget.name;
            myText.x = stage.mouseX-65;
            myText.y = stage.mouseY;
        }
    }
}