/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A65q
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.media.Camera; 
    import flash.media.Video;
    import flash.events.Event;
    import flash.geom.Matrix;
    public class CameraSample02 extends Sprite {
        private var _video:Video;
        private var _canvas:BitmapData;
        private var _mirrorMatrix:Matrix;
        private const CAMERA_WIDTH:Number = 320;
        private const CAMERA_HEIGHT:Number = 240;
        public function CameraSample02() {
            var camera:Camera = Camera.getCamera();
            if (camera == null) {
                return;
            }
            camera.setMode(CAMERA_WIDTH, CAMERA_HEIGHT, 15);
            _video = new Video();
            _video.attachCamera(camera);
            // 描画用のBitmapDataを作成
             _canvas= new BitmapData(CAMERA_WIDTH, CAMERA_HEIGHT);
            // 表示オブジェクトに追加
            addChild(new Bitmap(_canvas));
            // 反転用のMatrix作成
            _mirrorMatrix = new Matrix();
            _mirrorMatrix.scale(-1, 1); // 反転
            _mirrorMatrix.translate(CAMERA_WIDTH, 0); // 元の位置に戻す

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }

        private function enterFrameHandler(e:Event):void {
            // 毎回Matrixを適用し、BitmapDataを更新する
            _canvas.draw(_video, _mirrorMatrix);
        }
    }
}
