/**
 * Copyright yotsu42keisuke ( http://wonderfl.net/user/yotsu42keisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A5Wc
 */

// forked from Wasp's forked from: Arduino Test
// forked from kotobuki's Arduino Test
// A simple example illustrates how to use Funnel with
// an Arduino board (via StandardFirmara)
// 
// Inputs:
// * a switch to D12 with a pull-down resistor (e.g. 10kohm)
// 
// Outputs:
// * a LED with a resistor (e.g. 330phm) to D11
// 
// Ref: Getting started with Funnel and Arduino
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.ArduinoGUI;
    import funnel.ui.*;

    public class ArduinoTest extends Sprite {
        // To change number of analog channels, modify this constant
        // 表示するアナログチャンネル数を変更するにはこの定数を変更する
        private const NUM_CHANNELS:int = 3;

        private var aio:Arduino;
        private var scopes:Array;

        public function ArduinoTest() {
            var config:Configuration = Arduino.FIRMATA;
            //config.setDigitalPinMode(11, PWM);
            config.setDigitalPinMode(7, IN);
            config.setDigitalPinMode(13, OUT);

            aio = new Arduino(config);

            scopes = new Array(NUM_CHANNELS);
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i] = new SignalScope(10, 10 + (60 * i), 200, "A" + i);
                addChild(scopes[i]);
            }

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            aio.gui = gui;

            var button:Button = new Button(aio.digitalPin(12));
            var externalLED:LED = new LED(aio.digitalPin(11));
            var onBoardLED:LED = new LED(aio.digitalPin(13));

            button.addEventListener(ButtonEvent.PRESS, function(e:Event):void {
                onBoardLED.on();
                externalLED.blink(1000, 0, Osc.SIN);
            });

            button.addEventListener(ButtonEvent.RELEASE, function(e:Event):void {
                onBoardLED.off();
                externalLED.stopBlinking();
            });

            aio.analogPin(0).addFilter(new Convolution(Convolution.MOVING_AVERAGE));

            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i].update(aio.analogPin(i));
            }
        }
    }
}
