/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A5Jf
 */

/*

Frocessingを始めてみようと思ってちょっと練習。

ステージ上でマウスをダウンせずにカーソル移動させると描画します。
マウスダウンで描画クリアです。

*/
package {
  import frocessing.display.*;
  import flash.geom.Point;
  
  [SWF(width="465", height="465", backgroundColor="0", frameRate="30")]
  
  public class Main extends F5MovieClip2DBmp{
      
    private static const WIDTH:Number  = 465;
    private static const HEIGHT:Number = 465;
    private var _t:Number = 0;
    private var _pastMousePos:Point
    private var _px:Number = 0
    private var _py:Number = 0
    
    public function Main() {
        super();
    }
    
    public function setup():void {
        size(WIDTH, HEIGHT);
        background(0);
        noFill();
        colorMode(HSV, 2, 1, 1);
    }

    public function draw():void{
        if(_pastMousePos != null){
            var p:Point = new Point(mouseX, mouseY)
            var distance:int = Point.distance(p, _pastMousePos);
            _pastMousePos = p
            //
            var r:int = Math.random()*5
            for(var i:int; i<distance ;i++){
                stroke(_t, 0.8, 1, 0.1);
                _px += (p.x+(Math.random()*distance-distance/2) - _px) * Math.random() * 0.5;    
                _py += (p.y+(Math.random()*distance-distance/2) - _py) * Math.random() * 0.5;
                ellipse(_px, _py, r*distance/2+2, r*distance/2+2)
            }
            _pastMousePos = p
        }else{
            _pastMousePos = new Point(mouseX, mouseY)
        }
        _t += 0.01;
        //
        if (isMousePressed){
            background(0, 1);
            _t = 0
        }
    }
  }
}