/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A4qQ
 */

package  
{
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.*;
    import flash.text.*;
    /**
     * ...
     * @author kiyo
     * 
     * 参考にさせてもらいました。
     * http://wonderfl.net/c/3cCi/
     * 
     * 
     */
     [SWF(backgroundColor="#000000")]
    public class TextDance extends Sprite
    {
        private var textCanvas:BitmapData;
        private var textBitmap:Bitmap;
        private var canvas:BitmapData;
        private var canvasBitmap:Bitmap;
        private var red:Bitmap;
        private var green:Bitmap;
        private var blue:Bitmap;
        private var speed:Number = 0.9;
        private var angle:Number = 0;
        private var range:Number = 5;
        private var centerX:Number;
        private var centerY:Number;
        
        public function TextDance() 
        {
            
            //canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            canvasBitmap = new Bitmap();
            red = new Bitmap();
            red.blendMode = "add";
            red.smoothing = true;
            green = new Bitmap();
            green.blendMode = "add";
            green.smoothing = true;
            blue = new Bitmap();
            blue.blendMode = "add";
            blue.smoothing = true;
            addChild(red);
            addChild(green);
            addChild(blue);
            addChild(canvasBitmap);
            canvasBitmap.smoothing = true;
            textCanvas = setBitmapText("RGB Dance");
            drawRGB(textCanvas);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function setBitmapText(str:String="HelloWorld!!",textFormat:TextFormat=null):BitmapData
        {
            var tf:TextField = new TextField();
            var bitmapText:BitmapData;
            if (!textFormat) {
                var tfFormat:TextFormat = new TextFormat();
                tfFormat.font = "Helvetica";
                tfFormat.size = 50;
                tfFormat.color = 0xffffff;
                tf.defaultTextFormat = tfFormat;
            }else {
                tf.defaultTextFormat = textFormat;
            }
            
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = str;
            //addChild(tf);
            bitmapText = new BitmapData(tf.textWidth, tf.textHeight, true, 0);
            bitmapText.draw(tf);
            return bitmapText;
            //canvasBitmap.bitmapData = textCanvas;

        }
        
        private function enterFrameHandler(e:Event):void 
        {
            red.x = centerX+Math.sin(angle) * range;
            blue.x = centerX-Math.sin(angle) * range;
            green.y = centerY+Math.sin(angle) * range;
            angle += speed;
        }
        
        private function drawRGB(bmd:BitmapData):void
        {
            var redbmd:BitmapData = new BitmapData(bmd.width, bmd.height, true, 0xff000000);
            var greenbmd:BitmapData = new BitmapData(bmd.width, bmd.height, true, 0xff000000);
            var bluebmd:BitmapData = new BitmapData(bmd.width,bmd.height, true, 0xff000000);
            
            redbmd.copyChannel(bmd, bmd.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED);
            greenbmd.copyChannel(bmd, bmd.rect, new Point(), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            bluebmd.copyChannel(bmd, bmd.rect, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
            
            red.bitmapData = redbmd;
            green.bitmapData = greenbmd;
            blue.bitmapData = bluebmd;
            
            centerX = red.x = green.x = blue.x = stage.stageWidth / 2 - red.width / 2;
            centerY = red.y = green.y = blue.y = stage.stageHeight / 2 - red.height / 2;
            
        }    
    }

}