/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A3xw
 */

// forked from _wonder's Papervision3D練習
package {
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import flash.events.Event;
    
    [SWF(backgroundColor=0)]
    public class Sample extends BasicView {
        private var sphere:Sphere;
        private var sphere2:Sphere;
        
        public function Sample() {
            var material:WireframeMaterial = new WireframeMaterial(0XFF0000);
            sphere = new Sphere(material, 300, 10, 10);
            sphere2 = new Sphere(material, 300, 10, 10);
            
            sphere.x = 500;
            sphere2.x = -500;
            
            scene.addChild( sphere );
            scene.addChild( sphere2 );
            startRendering();
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            sphere.rotationY += 1;
            sphere2.rotationY -= 1;
            
            var rateX:Number = mouseX / stage.stageWidth;
            var targetX:Number = -5000 * ( rateX - 0.5);
            camera.x += ( targetX - camera.x) * 0.2;
            
            var rateY:Number = mouseY / stage.stageHeight;
            var targetY:Number = 5000 * ( rateY - 0.5);
            camera.y += ( targetY - camera.y) * 0.2;
        }
    }
}