/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A3vF
 */

// forked from takishiki's load MP3
/*
 * mp3読込テスト
 * 公式にあるやつほとんどそのままです。
 * 
 * ♪使用音楽素材について♪
 * 音楽素材/魔王魂（http://maoudamashii.jokersounds.com/）の素材を使わせていただきました。
 * ありがとうございます。
 * 
 */
 package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundTransform;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.system.Security;
    
    // SWFメタデータタグ
    [SWF(width = "400", height = "400", frameRate = "30", backgroundColor = "0x000000")]
    public class Main extends Sprite {
        
        private var _tf:TextField = new TextField();
        
        //
        public function Main() {
            var snd:Sound = new Sound();
            Security.loadPolicyFile("http://vaindog.raindrop.jp/crossdomain.xml");
            //var req:URLRequest = new URLRequest("http://db.musicmanstore.net:8000/mumixradio");
            var req:URLRequest = new URLRequest("http://scfire-dtc-aa03.stream.aol.com:80/stream/1035");
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            snd.load(req,context);
            //snd.load(req);
            
            var channel:SoundChannel;
            channel = snd.play();
            var transform:SoundTransform = new SoundTransform();
            transform.volume = 0.5;
            transform.pan = 0.0;
            channel.soundTransform = transform;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            channel.addEventListener(Event.SOUND_COMPLETE, onPlaybackComplete);
            
            _tf.textColor = 0xFFFFFF;
            //_tf.autoSize = TextFieldAutoSize.LEFT;
            _tf.x = 0;
            _tf.y = 0;
            _tf.width = 300;
            _tf.height = 40;
            _tf.text = "L: 0\nR:"; 
            this.addChild(_tf);
        }
        
        //
        private function onEnterFrame(event:Event):void {
            var bytes:ByteArray = new ByteArray();
            const PLOT_HEIGHT:int = 200;
            const CHANNEL_LENGTH:int = 256;
            
            SoundMixer.computeSpectrum(bytes, false, 0);
            
            var g:Graphics = this.graphics;
            g.clear();
            
            g.lineStyle(0, 0x6600CC);
            g.beginFill(0x6600CC);
            g.moveTo(0, PLOT_HEIGHT);
            
            var n:Number = 0;
            var max:Number = 0;
            for (var i:int = 0; i < CHANNEL_LENGTH; i++) {
                n = (bytes.readFloat() * PLOT_HEIGHT);
                max = Math.max(max, n);
                g.lineTo(i * 2, PLOT_HEIGHT - n);
            }
            _tf.text = "L: " + max.toFixed(4);
            
            g.lineTo(CHANNEL_LENGTH * 2, PLOT_HEIGHT);
            g.endFill();
            
            g.lineStyle(0, 0xCC0066);
            g.beginFill(0xCC0066, 0.5);
            g.moveTo(CHANNEL_LENGTH * 2, PLOT_HEIGHT);
            
            for (i = CHANNEL_LENGTH; i > 0; i--) {
                n = (bytes.readFloat() * PLOT_HEIGHT);
                max = Math.max(max, n);
                g.lineTo(i * 2, PLOT_HEIGHT - n);
            }
            _tf.appendText("\nR: " + max.toFixed(4));
            
            g.lineTo(0, PLOT_HEIGHT);
            g.endFill();
        }
        
        //
        private function onPlaybackComplete(event:Event):void {
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
    }
}